/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;

public interface Catalog {
    public Table createTable(TableIdentifier var1, Schema var2, PartitionSpec var3, String var4, Map<String, String> var5);

    default public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, Map<String, String> properties) {
        return this.createTable(identifier, schema, spec, null, properties);
    }

    default public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec) {
        return this.createTable(identifier, schema, spec, null, null);
    }

    default public Table createTable(TableIdentifier identifier, Schema schema) {
        return this.createTable(identifier, schema, PartitionSpec.unpartitioned(), null, null);
    }

    default public boolean tableExists(TableIdentifier identifier) {
        try {
            this.loadTable(identifier);
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public boolean dropTable(TableIdentifier var1);

    public void renameTable(TableIdentifier var1, TableIdentifier var2);

    public Table loadTable(TableIdentifier var1);
}

