/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Reference;

public abstract class Predicate<T, R extends Reference>
implements Expression {
    private final Expression.Operation op;
    private final R ref;
    private final Literal<T> literal;

    Predicate(Expression.Operation op, R ref, Literal<T> lit) {
        this.op = op;
        this.ref = ref;
        this.literal = lit;
    }

    @Override
    public Expression.Operation op() {
        return this.op;
    }

    public R ref() {
        return this.ref;
    }

    public Literal<T> literal() {
        return this.literal;
    }

    public String toString() {
        switch (this.op) {
            case IS_NULL: {
                return "is_null(" + this.ref() + ")";
            }
            case NOT_NULL: {
                return "not_null(" + this.ref() + ")";
            }
            case LT: {
                return String.valueOf(this.ref()) + " < " + this.literal();
            }
            case LT_EQ: {
                return String.valueOf(this.ref()) + " <= " + this.literal();
            }
            case GT: {
                return String.valueOf(this.ref()) + " > " + this.literal();
            }
            case GT_EQ: {
                return String.valueOf(this.ref()) + " >= " + this.literal();
            }
            case EQ: {
                return String.valueOf(this.ref()) + " == " + this.literal();
            }
            case NOT_EQ: {
                return String.valueOf(this.ref()) + " != " + this.literal();
            }
        }
        return "Invalid predicate: operation = " + (Object)((Object)this.op);
    }
}

