/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.List;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.RewriteNot;
import org.apache.iceberg.expressions.UnboundPredicate;

public class Projections {
    private Projections() {
    }

    public static ProjectionEvaluator inclusive(PartitionSpec spec) {
        return new InclusiveProjection(spec, true);
    }

    public static ProjectionEvaluator inclusive(PartitionSpec spec, boolean caseSensitive) {
        return new InclusiveProjection(spec, caseSensitive);
    }

    public static ProjectionEvaluator strict(PartitionSpec spec) {
        return new StrictProjection(spec, true);
    }

    public static ProjectionEvaluator strict(PartitionSpec spec, boolean caseSensitive) {
        return new StrictProjection(spec, caseSensitive);
    }

    private static class StrictProjection
    extends BaseProjectionEvaluator {
        private StrictProjection(PartitionSpec spec, boolean caseSensitive) {
            super(spec, caseSensitive);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            List<PartitionField> parts = this.spec().getFieldsBySourceId(((BoundReference)pred.ref()).fieldId());
            if (parts == null) {
                return Expressions.alwaysFalse();
            }
            Expression result = Expressions.alwaysFalse();
            for (PartitionField part : parts) {
                UnboundPredicate<?> strictProjection = part.transform().projectStrict(part.name(), pred);
                if (strictProjection == null) continue;
                result = Expressions.or(result, strictProjection);
            }
            return result;
        }
    }

    private static class InclusiveProjection
    extends BaseProjectionEvaluator {
        private InclusiveProjection(PartitionSpec spec, boolean caseSensitive) {
            super(spec, caseSensitive);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            List<PartitionField> parts = this.spec().getFieldsBySourceId(((BoundReference)pred.ref()).fieldId());
            if (parts == null) {
                return Expressions.alwaysTrue();
            }
            Expression result = Expressions.alwaysTrue();
            for (PartitionField part : parts) {
                UnboundPredicate<?> inclusiveProjection = part.transform().project(part.name(), pred);
                if (inclusiveProjection == null) continue;
                result = Expressions.and(result, inclusiveProjection);
            }
            return result;
        }
    }

    private static class BaseProjectionEvaluator
    extends ProjectionEvaluator {
        private final PartitionSpec spec;
        private final boolean caseSensitive;

        private BaseProjectionEvaluator(PartitionSpec spec, boolean caseSensitive) {
            this.spec = spec;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Expression project(Expression expr) {
            return ExpressionVisitors.visit(ExpressionVisitors.visit(expr, RewriteNot.get()), this);
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            throw new UnsupportedOperationException("[BUG] project called on expression with a not");
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            Expression bound = pred.bind(this.spec.schema().asStruct(), this.caseSensitive);
            if (bound instanceof BoundPredicate) {
                return (Expression)this.predicate((BoundPredicate)bound);
            }
            return bound;
        }

        PartitionSpec spec() {
            return this.spec;
        }

        boolean isCaseSensitive() {
            return this.caseSensitive;
        }
    }

    public static abstract class ProjectionEvaluator
    extends ExpressionVisitors.ExpressionVisitor<Expression> {
        public abstract Expression project(Expression var1);
    }
}

