/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

enum Timestamps implements Transform<Long, Integer>
{
    YEAR(ChronoUnit.YEARS, "year"),
    MONTH(ChronoUnit.MONTHS, "month"),
    DAY(ChronoUnit.DAYS, "day"),
    HOUR(ChronoUnit.HOURS, "hour");

    private static final OffsetDateTime EPOCH;
    private final ChronoUnit granularity;
    private final String name;

    private Timestamps(ChronoUnit granularity, String name) {
        this.granularity = granularity;
        this.name = name;
    }

    @Override
    public Integer apply(Long timestampMicros) {
        OffsetDateTime timestamp = Instant.ofEpochSecond(timestampMicros / 1000000L).atOffset(ZoneOffset.UTC);
        Integer year = Long.valueOf(this.granularity.between(EPOCH, timestamp)).intValue();
        return year;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.TIMESTAMP;
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public UnboundPredicate<Integer> project(String fieldName, BoundPredicate<Long> pred) {
        if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        return ProjectionUtil.truncateLong(fieldName, pred, this);
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String fieldName, BoundPredicate<Long> pred) {
        if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        return ProjectionUtil.truncateLongStrict(fieldName, pred, this);
    }

    @Override
    public String toHumanString(Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
            case HOURS: {
                return TransformUtil.humanHour(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + this.granularity);
    }

    public String toString() {
        return this.name;
    }

    static {
        EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    }
}

