/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;

abstract class Truncate<T>
implements Transform<T, T> {
    Truncate() {
    }

    static <T> Truncate<T> get(Type type, int width) {
        switch (type.typeId()) {
            case INTEGER: {
                return new TruncateInteger(width);
            }
            case LONG: {
                return new TruncateLong(width);
            }
            case DECIMAL: {
                return new TruncateDecimal(width);
            }
            case STRING: {
                return new TruncateString(width);
            }
            case BINARY: {
                return new TruncateByteBuffer(width);
            }
        }
        throw new UnsupportedOperationException("Cannot truncate type: " + type);
    }

    public abstract Integer width();

    @Override
    public abstract T apply(T var1);

    @Override
    public Type getResultType(Type sourceType) {
        return sourceType;
    }

    private static class TruncateDecimal
    extends Truncate<BigDecimal> {
        private final BigInteger unscaledWidth;

        private TruncateDecimal(int unscaledWidth) {
            this.unscaledWidth = BigInteger.valueOf(unscaledWidth);
        }

        @Override
        public Integer width() {
            return this.unscaledWidth.intValue();
        }

        @Override
        public BigDecimal apply(BigDecimal value) {
            BigDecimal remainder = new BigDecimal(value.unscaledValue().remainder(this.unscaledWidth).add(this.unscaledWidth).remainder(this.unscaledWidth), value.scale());
            return value.subtract(remainder);
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.DECIMAL;
        }

        @Override
        public UnboundPredicate<BigDecimal> project(String name, BoundPredicate<BigDecimal> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateDecimal(name, pred, this);
        }

        @Override
        public UnboundPredicate<BigDecimal> projectStrict(String name, BoundPredicate<BigDecimal> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateDecimal that = (TruncateDecimal)o;
            return this.unscaledWidth.equals(that.unscaledWidth);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.unscaledWidth});
        }

        public String toString() {
            return "truncate[" + this.unscaledWidth + "]";
        }
    }

    private static class TruncateByteBuffer
    extends Truncate<ByteBuffer> {
        private final int length;

        private TruncateByteBuffer(int length) {
            this.length = length;
        }

        @Override
        public Integer width() {
            return this.length;
        }

        @Override
        public ByteBuffer apply(ByteBuffer value) {
            ByteBuffer ret = value.duplicate();
            ret.limit(Math.min(value.limit(), value.position() + this.length));
            return ret;
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.BINARY;
        }

        @Override
        public UnboundPredicate<ByteBuffer> project(String name, BoundPredicate<ByteBuffer> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateArray(name, pred, this);
        }

        @Override
        public UnboundPredicate<ByteBuffer> projectStrict(String name, BoundPredicate<ByteBuffer> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateByteBuffer that = (TruncateByteBuffer)o;
            return this.length == that.length;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.length});
        }

        @Override
        public String toHumanString(ByteBuffer value) {
            return value == null ? "null" : TransformUtil.base64encode(value);
        }

        public String toString() {
            return "truncate[" + this.length + "]";
        }
    }

    private static class TruncateString
    extends Truncate<CharSequence> {
        private final int length;

        private TruncateString(int length) {
            this.length = length;
        }

        @Override
        public Integer width() {
            return this.length;
        }

        @Override
        public CharSequence apply(CharSequence value) {
            return value.subSequence(0, Math.min(value.length(), this.length));
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.STRING;
        }

        @Override
        public UnboundPredicate<CharSequence> project(String name, BoundPredicate<CharSequence> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateArray(name, pred, this);
        }

        @Override
        public UnboundPredicate<CharSequence> projectStrict(String name, BoundPredicate<CharSequence> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateString that = (TruncateString)o;
            return this.length == that.length;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.length});
        }

        public String toString() {
            return "truncate[" + this.length + "]";
        }
    }

    private static class TruncateLong
    extends Truncate<Long> {
        private final int width;

        private TruncateLong(int width) {
            this.width = width;
        }

        @Override
        public Integer width() {
            return this.width;
        }

        @Override
        public Long apply(Long value) {
            return value - (value % (long)this.width + (long)this.width) % (long)this.width;
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.LONG;
        }

        @Override
        public UnboundPredicate<Long> project(String name, BoundPredicate<Long> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateLong(name, pred, this);
        }

        @Override
        public UnboundPredicate<Long> projectStrict(String name, BoundPredicate<Long> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateLong that = (TruncateLong)o;
            return this.width == that.width;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.width});
        }

        public String toString() {
            return "truncate[" + this.width + "]";
        }
    }

    private static class TruncateInteger
    extends Truncate<Integer> {
        private final int width;

        private TruncateInteger(int width) {
            this.width = width;
        }

        @Override
        public Integer width() {
            return this.width;
        }

        @Override
        public Integer apply(Integer value) {
            return value - (value % this.width + this.width) % this.width;
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.INTEGER;
        }

        @Override
        public UnboundPredicate<Integer> project(String name, BoundPredicate<Integer> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateInteger(name, pred, this);
        }

        @Override
        public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<Integer> predicate) {
            switch (predicate.op()) {
                case LT: {
                    int in = (Integer)predicate.literal().value() - 1;
                    int out = (Integer)predicate.literal().value();
                    int inImage = this.apply(in);
                    int outImage = this.apply(out);
                    if (inImage != outImage) {
                        return Expressions.predicate(Expression.Operation.LT_EQ, name, inImage);
                    }
                    return Expressions.predicate(Expression.Operation.LT, name, inImage);
                }
                case LT_EQ: {
                    int in = (Integer)predicate.literal().value();
                    int out = (Integer)predicate.literal().value() + 1;
                    int inImage = this.apply(in);
                    int outImage = this.apply(out);
                    if (inImage != outImage) {
                        return Expressions.predicate(Expression.Operation.LT_EQ, name, inImage);
                    }
                    return Expressions.predicate(Expression.Operation.LT, name, inImage);
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateInteger that = (TruncateInteger)o;
            return this.width == that.width;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.width});
        }

        public String toString() {
            return "truncate[" + this.width + "]";
        }
    }
}

