/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import com.google.common.base.Preconditions;
import org.apache.iceberg.expressions.Literal;

public class UnicodeUtil {
    private UnicodeUtil() {
    }

    public static boolean isCharHighSurrogate(char ch) {
        return (ch & 0xFC00) == 55296;
    }

    public static CharSequence truncateString(CharSequence input, int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Truncate length should be positive");
        StringBuffer sb = new StringBuffer(input);
        int numUniCodeCharacters = sb.codePointCount(0, sb.length());
        if (length >= numUniCodeCharacters) {
            return input;
        }
        int offsetByCodePoint = sb.offsetByCodePoints(0, length);
        return input.subSequence(0, offsetByCodePoint);
    }

    public static Literal<CharSequence> truncateStringMin(Literal<CharSequence> input, int length) {
        CharSequence truncatedInput = UnicodeUtil.truncateString(input.value(), length);
        return Literal.of(truncatedInput);
    }

    public static Literal<CharSequence> truncateStringMax(Literal<CharSequence> input, int length) {
        CharSequence inputCharSeq = input.value();
        StringBuffer truncatedStringBuffer = new StringBuffer(UnicodeUtil.truncateString(inputCharSeq, length));
        if (inputCharSeq.length() == truncatedStringBuffer.length()) {
            return input;
        }
        for (int i = length - 1; i >= 0; --i) {
            int nextCodePoint = truncatedStringBuffer.codePointAt(i) + 1;
            if (nextCodePoint == 0 || !Character.isValidCodePoint(nextCodePoint)) continue;
            int offsetByCodePoint = truncatedStringBuffer.offsetByCodePoints(0, i);
            truncatedStringBuffer.setLength(offsetByCodePoint);
            truncatedStringBuffer.appendCodePoint(nextCodePoint);
            return Literal.of(truncatedStringBuffer.toString());
        }
        return null;
    }
}

