/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.connector.SchemaTableName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.weakref.jmx.Managed;

public class CachingDirectoryLister
implements DirectoryLister {
    private final Cache<Path, List<LocatedFileStatus>> cache;
    private final Set<SchemaTableName> tableNames;

    @Inject
    public CachingDirectoryLister(HiveConfig hiveClientConfig) {
        this(hiveClientConfig.getFileStatusCacheExpireAfterWrite(), hiveClientConfig.getFileStatusCacheMaxSize(), hiveClientConfig.getFileStatusCacheTables());
    }

    public CachingDirectoryLister(Duration expireAfterWrite, long maxSize, List<String> tables) {
        this.cache = CacheBuilder.newBuilder().maximumWeight(maxSize).weigher((key, value) -> value.size()).expireAfterWrite(expireAfterWrite.toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        this.tableNames = tables.stream().map(CachingDirectoryLister::parseTableName).collect(Collectors.toSet());
    }

    private static SchemaTableName parseTableName(String tableName) {
        String[] parts = tableName.split("\\.");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid schemaTableName: %s", (Object)tableName);
        return new SchemaTableName(parts[0], parts[1]);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> list(FileSystem fs, Table table, Path path) throws IOException {
        List files = (List)this.cache.getIfPresent((Object)path);
        if (files != null) {
            return CachingDirectoryLister.simpleRemoteIterator(files);
        }
        RemoteIterator iterator = fs.listLocatedStatus(path);
        if (!this.tableNames.contains(table.getSchemaTableName())) {
            return iterator;
        }
        return this.cachingRemoteIterator((RemoteIterator<LocatedFileStatus>)iterator, path);
    }

    private RemoteIterator<LocatedFileStatus> cachingRemoteIterator(final RemoteIterator<LocatedFileStatus> iterator, final Path path) {
        return new RemoteIterator<LocatedFileStatus>(){
            private final List<LocatedFileStatus> files = new ArrayList<LocatedFileStatus>();

            public boolean hasNext() throws IOException {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    CachingDirectoryLister.this.cache.put((Object)path, (Object)ImmutableList.copyOf(this.files));
                }
                return hasNext;
            }

            public LocatedFileStatus next() throws IOException {
                LocatedFileStatus next = (LocatedFileStatus)iterator.next();
                this.files.add(next);
                return next;
            }
        };
    }

    private static RemoteIterator<LocatedFileStatus> simpleRemoteIterator(final List<LocatedFileStatus> files) {
        return new RemoteIterator<LocatedFileStatus>(){
            private final Iterator<LocatedFileStatus> iterator;
            {
                this.iterator = ImmutableList.copyOf((Collection)files).iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public LocatedFileStatus next() {
                return this.iterator.next();
            }
        };
    }

    @Managed
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Managed
    public Double getHitRate() {
        return this.cache.stats().hitRate();
    }

    @Managed
    public Double getMissRate() {
        return this.cache.stats().missRate();
    }

    @Managed
    public long getHitCount() {
        return this.cache.stats().hitCount();
    }

    @Managed
    public long getMissCount() {
        return this.cache.stats().missCount();
    }

    @Managed
    public long getRequestCount() {
        return this.cache.stats().requestCount();
    }
}

