/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.BucketFunction;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final List<TypeInfo> typeInfos;

    public HiveBucketFunction(int bucketCount, List<HiveType> hiveTypes) {
        this.bucketCount = bucketCount;
        this.typeInfos = Objects.requireNonNull(hiveTypes, "hiveTypes is null").stream().map(HiveType::getTypeInfo).collect(Collectors.toList());
    }

    public int getBucket(Page page, int position) {
        return HiveBucketing.getHiveBucket(this.bucketCount, this.typeInfos, page, position);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).add("typeInfos", this.typeInfos).toString();
    }
}

