/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.s3.S3FileSystemType;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"dfs.domain-socket-path", "hive.file-system-cache-ttl", "hive.max-global-split-iterator-threads", "hive.max-sort-files-per-bucket", "hive.bucket-writing", "hive.optimized-reader.enabled", "hive.orc.optimized-writer.enabled", "hive.rcfile-optimized-writer.enabled"})
public class HiveConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private String timeZone = TimeZone.getDefault().getID();
    private DataSize maxSplitSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxPartitionsPerScan = 100000;
    private int maxOutstandingSplits = 1000;
    private DataSize maxOutstandingSplitsSize = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private int maxSplitIteratorThreads = 1000;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private int maxInitialSplits = 200;
    private int splitLoaderConcurrency = 4;
    private Integer maxSplitsPerSecond;
    private DataSize maxInitialSplitSize;
    private int domainCompactionThreshold = 100;
    private DataSize writerSortBufferSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private boolean forceLocalScheduling;
    private boolean recursiveDirWalkerEnabled;
    private int maxConcurrentFileRenames = 20;
    private boolean allowCorruptWritesForTesting;
    private long perTransactionMetastoreCacheMaximumSize = 1000L;
    private HostAndPort metastoreSocksProxy;
    private Duration metastoreTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration ipcPingInterval = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration dfsKeyProviderCacheTtl = new Duration(30.0, TimeUnit.MINUTES);
    private int dfsConnectMaxRetries = 5;
    private boolean verifyChecksum = true;
    private String domainSocketPath;
    private S3FileSystemType s3FileSystemType = S3FileSystemType.PRESTO;
    private HiveStorageFormat hiveStorageFormat = HiveStorageFormat.ORC;
    private HiveCompressionCodec hiveCompressionCodec = HiveCompressionCodec.GZIP;
    private boolean respectTableFormat = true;
    private boolean immutablePartitions;
    private boolean createEmptyBucketFiles = true;
    private int maxPartitionsPerWriter = 100;
    private int maxOpenSortFiles = 50;
    private int writeValidationThreads = 16;
    private List<String> resourceConfigFiles = ImmutableList.of();
    private DataSize textMaxLineLength = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private boolean useParquetColumnNames;
    private boolean failOnCorruptedParquetStatistics = true;
    private DataSize parquetMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean assumeCanonicalPartitionKeys;
    private boolean useOrcColumnNames;
    private boolean orcBloomFiltersEnabled;
    private double orcDefaultBloomFilterFpp = 0.05;
    private DataSize orcMaxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcTinyStripeThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcStreamBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean orcLazyReadSmallRanges = true;
    private boolean orcWriteLegacyVersion;
    private double orcWriterValidationPercentage;
    private OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode = OrcWriteValidation.OrcWriteValidationMode.BOTH;
    private boolean rcfileWriterValidate;
    private HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType = HiveMetastoreAuthenticationType.NONE;
    private HdfsAuthenticationType hdfsAuthenticationType = HdfsAuthenticationType.NONE;
    private boolean hdfsImpersonationEnabled;
    private boolean hdfsWireEncryptionEnabled;
    private boolean skipDeletionForAlter;
    private boolean skipTargetCleanupOnRollback;
    private boolean bucketExecutionEnabled = true;
    private boolean sortedWritingEnabled = true;
    private int fileSystemMaxCacheSize = 1000;
    private boolean optimizeMismatchedBucketCount;
    private boolean writesToNonManagedTablesEnabled;
    private boolean createsOfNonManagedTablesEnabled = true;
    private boolean tableStatisticsEnabled = true;
    private int partitionStatisticsSampleSize = 100;
    private boolean ignoreCorruptedStatistics;
    private boolean collectColumnStatisticsOnWrite = true;
    private String recordingPath;
    private boolean replay;
    private Duration recordingDuration = new Duration(10.0, TimeUnit.MINUTES);
    private boolean s3SelectPushdownEnabled;
    private int s3SelectPushdownMaxConnections = 500;
    private boolean isTemporaryStagingDirectoryEnabled = true;
    private String temporaryStagingDirectoryPath = "/tmp/presto-${USER}";
    private Duration fileStatusCacheExpireAfterWrite = new Duration(1.0, TimeUnit.MINUTES);
    private long fileStatusCacheMaxSize = 1000000L;
    private List<String> fileStatusCacheTables = ImmutableList.of();

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="hive.max-initial-splits")
    public HiveConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return new DataSize(this.maxSplitSize.getValue() / 2.0, this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="hive.max-initial-split-size")
    public HiveConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitLoaderConcurrency() {
        return this.splitLoaderConcurrency;
    }

    @Config(value="hive.split-loader-concurrency")
    public HiveConfig setSplitLoaderConcurrency(int splitLoaderConcurrency) {
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        return this;
    }

    @Min(value=1L)
    @Nullable
    public @Min(value=1L) Integer getMaxSplitsPerSecond() {
        return this.maxSplitsPerSecond;
    }

    @Config(value="hive.max-splits-per-second")
    @ConfigDescription(value="Throttles the maximum number of splits that can be assigned to tasks per second")
    public HiveConfig setMaxSplitsPerSecond(Integer maxSplitsPerSecond) {
        this.maxSplitsPerSecond = maxSplitsPerSecond;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="hive.domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public HiveConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public DataSize getWriterSortBufferSize() {
        return this.writerSortBufferSize;
    }

    @Config(value="hive.writer-sort-buffer-size")
    public HiveConfig setWriterSortBufferSize(DataSize writerSortBufferSize) {
        this.writerSortBufferSize = writerSortBufferSize;
        return this;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @Config(value="hive.force-local-scheduling")
    public HiveConfig setForceLocalScheduling(boolean forceLocalScheduling) {
        this.forceLocalScheduling = forceLocalScheduling;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentFileRenames() {
        return this.maxConcurrentFileRenames;
    }

    @Config(value="hive.max-concurrent-file-renames")
    public HiveConfig setMaxConcurrentFileRenames(int maxConcurrentFileRenames) {
        this.maxConcurrentFileRenames = maxConcurrentFileRenames;
        return this;
    }

    @Config(value="hive.recursive-directories")
    public HiveConfig setRecursiveDirWalkerEnabled(boolean recursiveDirWalkerEnabled) {
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        return this;
    }

    public boolean getRecursiveDirWalkerEnabled() {
        return this.recursiveDirWalkerEnabled;
    }

    public DateTimeZone getDateTimeZone() {
        return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.timeZone));
    }

    @NotNull
    public String getTimeZone() {
        return this.timeZone;
    }

    @Config(value="hive.time-zone")
    public HiveConfig setTimeZone(String id) {
        this.timeZone = id != null ? id : TimeZone.getDefault().getID();
        return this;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerScan() {
        return this.maxPartitionsPerScan;
    }

    @Config(value="hive.max-partitions-per-scan")
    @ConfigDescription(value="Maximum allowed partitions for a single table scan")
    public HiveConfig setMaxPartitionsPerScan(int maxPartitionsPerScan) {
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    @ConfigDescription(value="Target number of buffered splits for each table scan in a query, before the scheduler tries to pause itself")
    public HiveConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @MinDataSize(value="1MB")
    public DataSize getMaxOutstandingSplitsSize() {
        return this.maxOutstandingSplitsSize;
    }

    @Config(value="hive.max-outstanding-splits-size")
    @ConfigDescription(value="Maximum amount of memory allowed for split buffering for each table scan in a query, before the query is failed")
    public HiveConfig setMaxOutstandingSplitsSize(DataSize maxOutstandingSplits) {
        this.maxOutstandingSplitsSize = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    @Deprecated
    public boolean getAllowCorruptWritesForTesting() {
        return this.allowCorruptWritesForTesting;
    }

    @Deprecated
    @Config(value="hive.allow-corrupt-writes-for-testing")
    @ConfigDescription(value="Allow Hive connector to write data even when data will likely be corrupt")
    public HiveConfig setAllowCorruptWritesForTesting(boolean allowCorruptWritesForTesting) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        return this;
    }

    public long getPerTransactionMetastoreCacheMaximumSize() {
        return this.perTransactionMetastoreCacheMaximumSize;
    }

    @Min(value=1L)
    @Config(value="hive.per-transaction-metastore-cache-maximum-size")
    public @Min(value=1L) HiveConfig setPerTransactionMetastoreCacheMaximumSize(long perTransactionMetastoreCacheMaximumSize) {
        this.perTransactionMetastoreCacheMaximumSize = perTransactionMetastoreCacheMaximumSize;
        return this;
    }

    public HostAndPort getMetastoreSocksProxy() {
        return this.metastoreSocksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public HiveConfig setMetastoreSocksProxy(HostAndPort metastoreSocksProxy) {
        this.metastoreSocksProxy = metastoreSocksProxy;
        return this;
    }

    @NotNull
    public Duration getMetastoreTimeout() {
        return this.metastoreTimeout;
    }

    @Config(value="hive.metastore-timeout")
    public HiveConfig setMetastoreTimeout(Duration metastoreTimeout) {
        this.metastoreTimeout = metastoreTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    @NotNull
    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public HiveConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        return this;
    }

    public HiveConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getIpcPingInterval() {
        return this.ipcPingInterval;
    }

    @Config(value="hive.dfs.ipc-ping-interval")
    public HiveConfig setIpcPingInterval(Duration pingInterval) {
        this.ipcPingInterval = pingInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HiveConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getDfsKeyProviderCacheTtl() {
        return this.dfsKeyProviderCacheTtl;
    }

    @Config(value="hive.dfs.key-provider.cache-ttl")
    public HiveConfig setDfsKeyProviderCacheTtl(Duration dfsClientKeyProviderCacheTtl) {
        this.dfsKeyProviderCacheTtl = dfsClientKeyProviderCacheTtl;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HiveConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HiveConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    @Config(value="hive.storage-format")
    public HiveConfig setHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        this.hiveStorageFormat = hiveStorageFormat;
        return this;
    }

    public HiveCompressionCodec getHiveCompressionCodec() {
        return this.hiveCompressionCodec;
    }

    @Config(value="hive.compression-codec")
    public HiveConfig setHiveCompressionCodec(HiveCompressionCodec hiveCompressionCodec) {
        this.hiveCompressionCodec = hiveCompressionCodec;
        return this;
    }

    public boolean isRespectTableFormat() {
        return this.respectTableFormat;
    }

    @Config(value="hive.respect-table-format")
    @ConfigDescription(value="Should new partitions be written using the existing table format or the default Presto format")
    public HiveConfig setRespectTableFormat(boolean respectTableFormat) {
        this.respectTableFormat = respectTableFormat;
        return this;
    }

    public boolean isImmutablePartitions() {
        return this.immutablePartitions;
    }

    @Config(value="hive.immutable-partitions")
    @ConfigDescription(value="Can new data be inserted into existing partitions or existing unpartitioned tables")
    public HiveConfig setImmutablePartitions(boolean immutablePartitions) {
        this.immutablePartitions = immutablePartitions;
        return this;
    }

    public boolean isCreateEmptyBucketFiles() {
        return this.createEmptyBucketFiles;
    }

    @Config(value="hive.create-empty-bucket-files")
    @ConfigDescription(value="Create empty files for buckets that have no data")
    public HiveConfig setCreateEmptyBucketFiles(boolean createEmptyBucketFiles) {
        this.createEmptyBucketFiles = createEmptyBucketFiles;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="hive.max-partitions-per-writers")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public HiveConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    @Min(value=2L)
    @Max(value=1000L)
    public @Min(value=2L) @Max(value=1000L) int getMaxOpenSortFiles() {
        return this.maxOpenSortFiles;
    }

    @Config(value="hive.max-open-sort-files")
    @ConfigDescription(value="Maximum number of writer temporary files to read in one pass")
    public HiveConfig setMaxOpenSortFiles(int maxOpenSortFiles) {
        this.maxOpenSortFiles = maxOpenSortFiles;
        return this;
    }

    public int getWriteValidationThreads() {
        return this.writeValidationThreads;
    }

    @Config(value="hive.write-validation-threads")
    @ConfigDescription(value="Number of threads used for verifying data after a write")
    public HiveConfig setWriteValidationThreads(int writeValidationThreads) {
        this.writeValidationThreads = writeValidationThreads;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="hive.dfs.domain-socket-path")
    public HiveConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    @NotNull
    public S3FileSystemType getS3FileSystemType() {
        return this.s3FileSystemType;
    }

    @Config(value="hive.s3-file-system-type")
    public HiveConfig setS3FileSystemType(S3FileSystemType s3FileSystemType) {
        this.s3FileSystemType = s3FileSystemType;
        return this;
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    @Config(value="hive.dfs.verify-checksum")
    public HiveConfig setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    public boolean isUseOrcColumnNames() {
        return this.useOrcColumnNames;
    }

    @Config(value="hive.orc.use-column-names")
    @ConfigDescription(value="Access ORC columns using names from the file")
    public HiveConfig setUseOrcColumnNames(boolean useOrcColumnNames) {
        this.useOrcColumnNames = useOrcColumnNames;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.orcMaxMergeDistance;
    }

    @Config(value="hive.orc.max-merge-distance")
    public HiveConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.orcMaxMergeDistance = orcMaxMergeDistance;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxBufferSize() {
        return this.orcMaxBufferSize;
    }

    @Config(value="hive.orc.max-buffer-size")
    public HiveConfig setOrcMaxBufferSize(DataSize orcMaxBufferSize) {
        this.orcMaxBufferSize = orcMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.orcStreamBufferSize;
    }

    @Config(value="hive.orc.stream-buffer-size")
    public HiveConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.orcStreamBufferSize = orcStreamBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcTinyStripeThreshold() {
        return this.orcTinyStripeThreshold;
    }

    @Config(value="hive.orc.tiny-stripe-threshold")
    public HiveConfig setOrcTinyStripeThreshold(DataSize orcTinyStripeThreshold) {
        this.orcTinyStripeThreshold = orcTinyStripeThreshold;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxReadBlockSize() {
        return this.orcMaxReadBlockSize;
    }

    @Config(value="hive.orc.max-read-block-size")
    public HiveConfig setOrcMaxReadBlockSize(DataSize orcMaxReadBlockSize) {
        this.orcMaxReadBlockSize = orcMaxReadBlockSize;
        return this;
    }

    @Deprecated
    public boolean isOrcLazyReadSmallRanges() {
        return this.orcLazyReadSmallRanges;
    }

    @Deprecated
    @Config(value="hive.orc.lazy-read-small-ranges")
    @ConfigDescription(value="ORC read small disk ranges lazily")
    public HiveConfig setOrcLazyReadSmallRanges(boolean orcLazyReadSmallRanges) {
        this.orcLazyReadSmallRanges = orcLazyReadSmallRanges;
        return this;
    }

    public boolean isOrcBloomFiltersEnabled() {
        return this.orcBloomFiltersEnabled;
    }

    @Config(value="hive.orc.bloom-filters.enabled")
    public HiveConfig setOrcBloomFiltersEnabled(boolean orcBloomFiltersEnabled) {
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
        return this;
    }

    public double getOrcDefaultBloomFilterFpp() {
        return this.orcDefaultBloomFilterFpp;
    }

    @Config(value="hive.orc.default-bloom-filter-fpp")
    @ConfigDescription(value="ORC Bloom filter false positive probability")
    public HiveConfig setOrcDefaultBloomFilterFpp(double orcDefaultBloomFilterFpp) {
        this.orcDefaultBloomFilterFpp = orcDefaultBloomFilterFpp;
        return this;
    }

    public boolean isOrcWriteLegacyVersion() {
        return this.orcWriteLegacyVersion;
    }

    @Config(value="hive.orc.writer.use-legacy-version-number")
    @ConfigDescription(value="Write ORC files with a version number that is readable by Hive 2.0.0 to 2.2.0")
    public HiveConfig setOrcWriteLegacyVersion(boolean orcWriteLegacyVersion) {
        this.orcWriteLegacyVersion = orcWriteLegacyVersion;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getOrcWriterValidationPercentage() {
        return this.orcWriterValidationPercentage;
    }

    @Config(value="hive.orc.writer.validation-percentage")
    @ConfigDescription(value="Percentage of ORC files to validate after write by re-reading the whole file")
    public HiveConfig setOrcWriterValidationPercentage(double orcWriterValidationPercentage) {
        this.orcWriterValidationPercentage = orcWriterValidationPercentage;
        return this;
    }

    @NotNull
    public OrcWriteValidation.OrcWriteValidationMode getOrcWriterValidationMode() {
        return this.orcWriterValidationMode;
    }

    @Config(value="hive.orc.writer.validation-mode")
    @ConfigDescription(value="Level of detail in ORC validation. Lower levels require more memory.")
    public HiveConfig setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode) {
        this.orcWriterValidationMode = orcWriterValidationMode;
        return this;
    }

    public boolean isRcfileWriterValidate() {
        return this.rcfileWriterValidate;
    }

    @Config(value="hive.rcfile.writer.validate")
    @ConfigDescription(value="Validate RCFile after write by re-reading the whole file")
    public HiveConfig setRcfileWriterValidate(boolean rcfileWriterValidate) {
        this.rcfileWriterValidate = rcfileWriterValidate;
        return this;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.assume-canonical-partition-keys")
    public HiveConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    @MinDataSize(value="1B")
    @MaxDataSize(value="1GB")
    @NotNull
    public DataSize getTextMaxLineLength() {
        return this.textMaxLineLength;
    }

    @Config(value="hive.text.max-line-length")
    @ConfigDescription(value="Maximum line length for text files")
    public HiveConfig setTextMaxLineLength(DataSize textMaxLineLength) {
        this.textMaxLineLength = textMaxLineLength;
        return this;
    }

    public boolean isUseParquetColumnNames() {
        return this.useParquetColumnNames;
    }

    @Config(value="hive.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file")
    public HiveConfig setUseParquetColumnNames(boolean useParquetColumnNames) {
        this.useParquetColumnNames = useParquetColumnNames;
        return this;
    }

    public boolean isFailOnCorruptedParquetStatistics() {
        return this.failOnCorruptedParquetStatistics;
    }

    @Config(value="hive.parquet.fail-on-corrupted-statistics")
    @ConfigDescription(value="Fail when scanning Parquet files with corrupted statistics")
    public HiveConfig setFailOnCorruptedParquetStatistics(boolean failOnCorruptedParquetStatistics) {
        this.failOnCorruptedParquetStatistics = failOnCorruptedParquetStatistics;
        return this;
    }

    @NotNull
    public DataSize getParquetMaxReadBlockSize() {
        return this.parquetMaxReadBlockSize;
    }

    @Config(value="hive.parquet.max-read-block-size")
    public HiveConfig setParquetMaxReadBlockSize(DataSize parquetMaxReadBlockSize) {
        this.parquetMaxReadBlockSize = parquetMaxReadBlockSize;
        return this;
    }

    public boolean isOptimizeMismatchedBucketCount() {
        return this.optimizeMismatchedBucketCount;
    }

    @Config(value="hive.optimize-mismatched-bucket-count")
    public HiveConfig setOptimizeMismatchedBucketCount(boolean optimizeMismatchedBucketCount) {
        this.optimizeMismatchedBucketCount = optimizeMismatchedBucketCount;
        return this;
    }

    public List<String> getFileStatusCacheTables() {
        return this.fileStatusCacheTables;
    }

    @Config(value="hive.file-status-cache-tables")
    public HiveConfig setFileStatusCacheTables(String fileStatusCacheTables) {
        this.fileStatusCacheTables = SPLITTER.splitToList((CharSequence)fileStatusCacheTables);
        return this;
    }

    public long getFileStatusCacheMaxSize() {
        return this.fileStatusCacheMaxSize;
    }

    @Config(value="hive.file-status-cache-size")
    public HiveConfig setFileStatusCacheMaxSize(long fileStatusCacheMaxSize) {
        this.fileStatusCacheMaxSize = fileStatusCacheMaxSize;
        return this;
    }

    public Duration getFileStatusCacheExpireAfterWrite() {
        return this.fileStatusCacheExpireAfterWrite;
    }

    @Config(value="hive.file-status-cache-expire-time")
    public HiveConfig setFileStatusCacheExpireAfterWrite(Duration fileStatusCacheExpireAfterWrite) {
        this.fileStatusCacheExpireAfterWrite = fileStatusCacheExpireAfterWrite;
        return this;
    }

    @NotNull
    public HiveMetastoreAuthenticationType getHiveMetastoreAuthenticationType() {
        return this.hiveMetastoreAuthenticationType;
    }

    @Config(value="hive.metastore.authentication.type")
    @ConfigDescription(value="Hive Metastore authentication type")
    public HiveConfig setHiveMetastoreAuthenticationType(HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType) {
        this.hiveMetastoreAuthenticationType = hiveMetastoreAuthenticationType;
        return this;
    }

    @NotNull
    public HdfsAuthenticationType getHdfsAuthenticationType() {
        return this.hdfsAuthenticationType;
    }

    @Config(value="hive.hdfs.authentication.type")
    @ConfigDescription(value="HDFS authentication type")
    public HiveConfig setHdfsAuthenticationType(HdfsAuthenticationType hdfsAuthenticationType) {
        this.hdfsAuthenticationType = hdfsAuthenticationType;
        return this;
    }

    public boolean isHdfsImpersonationEnabled() {
        return this.hdfsImpersonationEnabled;
    }

    @Config(value="hive.hdfs.impersonation.enabled")
    @ConfigDescription(value="Should Presto user be impersonated when communicating with HDFS")
    public HiveConfig setHdfsImpersonationEnabled(boolean hdfsImpersonationEnabled) {
        this.hdfsImpersonationEnabled = hdfsImpersonationEnabled;
        return this;
    }

    public boolean isHdfsWireEncryptionEnabled() {
        return this.hdfsWireEncryptionEnabled;
    }

    @Config(value="hive.hdfs.wire-encryption.enabled")
    @ConfigDescription(value="Should be turned on when HDFS wire encryption is enabled")
    public HiveConfig setHdfsWireEncryptionEnabled(boolean hdfsWireEncryptionEnabled) {
        this.hdfsWireEncryptionEnabled = hdfsWireEncryptionEnabled;
        return this;
    }

    public boolean isSkipDeletionForAlter() {
        return this.skipDeletionForAlter;
    }

    @Config(value="hive.skip-deletion-for-alter")
    @ConfigDescription(value="Skip deletion of old partition data when a partition is deleted and then inserted in the same transaction")
    public HiveConfig setSkipDeletionForAlter(boolean skipDeletionForAlter) {
        this.skipDeletionForAlter = skipDeletionForAlter;
        return this;
    }

    public boolean isSkipTargetCleanupOnRollback() {
        return this.skipTargetCleanupOnRollback;
    }

    @Config(value="hive.skip-target-cleanup-on-rollback")
    @ConfigDescription(value="Skip deletion of target directories when a metastore operation fails")
    public HiveConfig setSkipTargetCleanupOnRollback(boolean skipTargetCleanupOnRollback) {
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        return this;
    }

    public boolean isBucketExecutionEnabled() {
        return this.bucketExecutionEnabled;
    }

    @Config(value="hive.bucket-execution")
    @ConfigDescription(value="Enable bucket-aware execution: only use a single worker per bucket")
    public HiveConfig setBucketExecutionEnabled(boolean bucketExecutionEnabled) {
        this.bucketExecutionEnabled = bucketExecutionEnabled;
        return this;
    }

    public boolean isSortedWritingEnabled() {
        return this.sortedWritingEnabled;
    }

    @Config(value="hive.sorted-writing")
    @ConfigDescription(value="Enable writing to bucketed sorted tables")
    public HiveConfig setSortedWritingEnabled(boolean sortedWritingEnabled) {
        this.sortedWritingEnabled = sortedWritingEnabled;
        return this;
    }

    public int getFileSystemMaxCacheSize() {
        return this.fileSystemMaxCacheSize;
    }

    @Config(value="hive.fs.cache.max-size")
    @ConfigDescription(value="Hadoop FileSystem cache size")
    public HiveConfig setFileSystemMaxCacheSize(int fileSystemMaxCacheSize) {
        this.fileSystemMaxCacheSize = fileSystemMaxCacheSize;
        return this;
    }

    @Config(value="hive.non-managed-table-writes-enabled")
    @ConfigDescription(value="Enable writes to non-managed (external) tables")
    public HiveConfig setWritesToNonManagedTablesEnabled(boolean writesToNonManagedTablesEnabled) {
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        return this;
    }

    public boolean getWritesToNonManagedTablesEnabled() {
        return this.writesToNonManagedTablesEnabled;
    }

    @Config(value="hive.non-managed-table-creates-enabled")
    @ConfigDescription(value="Enable non-managed (external) table creates")
    public HiveConfig setCreatesOfNonManagedTablesEnabled(boolean createsOfNonManagedTablesEnabled) {
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        return this;
    }

    public boolean getCreatesOfNonManagedTablesEnabled() {
        return this.createsOfNonManagedTablesEnabled;
    }

    @Config(value="hive.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public HiveConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPartitionStatisticsSampleSize() {
        return this.partitionStatisticsSampleSize;
    }

    @Config(value="hive.partition-statistics-sample-size")
    @ConfigDescription(value="Maximum sample size of the partitions column statistics")
    public HiveConfig setPartitionStatisticsSampleSize(int partitionStatisticsSampleSize) {
        this.partitionStatisticsSampleSize = partitionStatisticsSampleSize;
        return this;
    }

    public boolean isIgnoreCorruptedStatistics() {
        return this.ignoreCorruptedStatistics;
    }

    @Config(value="hive.ignore-corrupted-statistics")
    @ConfigDescription(value="Ignore corrupted statistics rather than failing")
    public HiveConfig setIgnoreCorruptedStatistics(boolean ignoreCorruptedStatistics) {
        this.ignoreCorruptedStatistics = ignoreCorruptedStatistics;
        return this;
    }

    public boolean isCollectColumnStatisticsOnWrite() {
        return this.collectColumnStatisticsOnWrite;
    }

    @Config(value="hive.collect-column-statistics-on-write")
    @ConfigDescription(value="Enables automatic column level statistics collection on write")
    public HiveConfig setCollectColumnStatisticsOnWrite(boolean collectColumnStatisticsOnWrite) {
        this.collectColumnStatisticsOnWrite = collectColumnStatisticsOnWrite;
        return this;
    }

    @Config(value="hive.metastore-recording-path")
    public HiveConfig setRecordingPath(String recordingPath) {
        this.recordingPath = recordingPath;
        return this;
    }

    public String getRecordingPath() {
        return this.recordingPath;
    }

    @Config(value="hive.replay-metastore-recording")
    public HiveConfig setReplay(boolean replay) {
        this.replay = replay;
        return this;
    }

    public boolean isReplay() {
        return this.replay;
    }

    @Config(value="hive.metastore-recording-duration")
    public HiveConfig setRecordingDuration(Duration recordingDuration) {
        this.recordingDuration = recordingDuration;
        return this;
    }

    @NotNull
    public Duration getRecordingDuration() {
        return this.recordingDuration;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @Config(value="hive.s3select-pushdown.enabled")
    @ConfigDescription(value="Enable query pushdown to AWS S3 Select service")
    public HiveConfig setS3SelectPushdownEnabled(boolean s3SelectPushdownEnabled) {
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getS3SelectPushdownMaxConnections() {
        return this.s3SelectPushdownMaxConnections;
    }

    @Config(value="hive.s3select-pushdown.max-connections")
    public HiveConfig setS3SelectPushdownMaxConnections(int s3SelectPushdownMaxConnections) {
        this.s3SelectPushdownMaxConnections = s3SelectPushdownMaxConnections;
        return this;
    }

    @Config(value="hive.temporary-staging-directory-enabled")
    @ConfigDescription(value="Should use (if possible) temporary staging directory for write operations")
    public HiveConfig setTemporaryStagingDirectoryEnabled(boolean temporaryStagingDirectoryEnabled) {
        this.isTemporaryStagingDirectoryEnabled = temporaryStagingDirectoryEnabled;
        return this;
    }

    public boolean isTemporaryStagingDirectoryEnabled() {
        return this.isTemporaryStagingDirectoryEnabled;
    }

    @Config(value="hive.temporary-staging-directory-path")
    @ConfigDescription(value="Location of temporary staging directory for write operations. Use ${USER} placeholder to use different location for each user.")
    public HiveConfig setTemporaryStagingDirectoryPath(String temporaryStagingDirectoryPath) {
        this.temporaryStagingDirectoryPath = temporaryStagingDirectoryPath;
        return this;
    }

    @NotNull
    public String getTemporaryStagingDirectoryPath() {
        return this.temporaryStagingDirectoryPath;
    }

    public static enum HdfsAuthenticationType {
        NONE,
        KERBEROS;

    }

    public static enum HiveMetastoreAuthenticationType {
        NONE,
        KERBEROS;

    }
}

