/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveAnalyzeProperties;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveInputInfo;
import io.prestosql.plugin.hive.HiveInsertTableHandle;
import io.prestosql.plugin.hive.HiveOutputTableHandle;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HivePartitionResult;
import io.prestosql.plugin.hive.HivePartitioningHandle;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTableProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveViewNotSupportedException;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.HiveWriterFactory;
import io.prestosql.plugin.hive.HiveWrittenPartitions;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.ViewAlreadyExistsException;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.plugin.hive.statistics.HiveStatisticsProvider;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.Statistics;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTablePartitioning;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.DiscretePredicates;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.connector.ViewNotFoundException;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.TableStatisticType;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class HiveMetadata
implements TransactionalMetadata {
    public static final String PRESTO_VERSION_NAME = "presto_version";
    public static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    public static final String TABLE_COMMENT = "comment";
    private static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    private static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    private static final String TEXT_SKIP_HEADER_COUNT_KEY = "skip.header.line.count";
    private static final String TEXT_SKIP_FOOTER_COUNT_KEY = "skip.footer.line.count";
    public static final String AVRO_SCHEMA_URL_KEY = "avro.schema.url";
    private static final String CSV_SEPARATOR_KEY = "separatorChar";
    private static final String CSV_QUOTE_KEY = "quoteChar";
    private static final String CSV_ESCAPE_KEY = "escapeChar";
    private final boolean allowCorruptWritesForTesting;
    private final SemiTransactionalHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final TypeTranslator typeTranslator;
    private final String prestoVersion;
    private final HiveStatisticsProvider hiveStatisticsProvider;
    private final AccessControlMetadata accessControlMetadata;

    public HiveMetadata(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, boolean allowCorruptWritesForTesting, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, String prestoVersion, HiveStatisticsProvider hiveStatisticsProvider, AccessControlMetadata accessControlMetadata) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.hiveStatisticsProvider = Objects.requireNonNull(hiveStatisticsProvider, "hiveStatisticsProvider is null");
        this.accessControlMetadata = Objects.requireNonNull(accessControlMetadata, "accessControlMetadata is null");
    }

    public SemiTransactionalHiveMetastore getMetastore() {
        return this.metastore;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        if (HiveMetadata.getSourceTableNameFromSystemTable(tableName).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Unexpected table present in Hive metastore: " + tableName);
        }
        MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table.get()), table.get().getParameters());
        return new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName(), HiveUtil.getPartitionKeyColumnHandles(table.get()), HiveBucketing.getHiveBucketHandle(table.get()));
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        HiveTableHandle handle = this.getTableHandle(session, tableName);
        if (handle == null) {
            return null;
        }
        Optional<List<List<String>>> partitionValuesList = HiveAnalyzeProperties.getPartitionList(analyzeProperties);
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(handle.getSchemaTableName());
        handle = handle.withAnalyzePartitionValues(partitionValuesList);
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        partitionValuesList.ifPresent(list -> {
            if (partitionedBy.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition list provided but table is not partitioned");
            }
            for (List values : list) {
                if (values.size() == partitionedBy.size()) continue;
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition value count does not match partition column count");
            }
        });
        HiveTableHandle table = handle;
        return partitionValuesList.map(values -> this.partitionManager.getPartitions(table, (List<List<String>>)values)).map(result -> this.partitionManager.applyPartitionResult(table, (HivePartitionResult)result)).orElse(table);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        if (SystemTableHandler.PARTITIONS.matches(tableName)) {
            return this.getPartitionsSystemTable(session, tableName, SystemTableHandler.PARTITIONS.getSourceTableName(tableName));
        }
        if (SystemTableHandler.PROPERTIES.matches(tableName)) {
            return this.getPropertiesSystemTable(tableName, SystemTableHandler.PROPERTIES.getSourceTableName(tableName));
        }
        return Optional.empty();
    }

    private Optional<SystemTable> getPropertiesSystemTable(SchemaTableName tableName, SchemaTableName sourceTableName) {
        Optional<Table> table = this.metastore.getTable(sourceTableName.getSchemaName(), sourceTableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableSortedMap sortedTableParameters = ImmutableSortedMap.copyOf(table.get().getParameters());
        List columns = (List)sortedTableParameters.keySet().stream().map(key -> new ColumnMetadata(key, (Type)VarcharType.VARCHAR)).collect(ImmutableList.toImmutableList());
        List types = (List)columns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        ImmutableList propertyValues = ImmutableList.of((Object)ImmutableList.copyOf(sortedTableParameters.values()));
        return Optional.of(HiveMetadata.createSystemTable(new ConnectorTableMetadata(sourceTableName, columns), arg_0 -> HiveMetadata.lambda$getPropertiesSystemTable$4(types, (Iterable)propertyValues, arg_0)));
    }

    private Optional<SystemTable> getPartitionsSystemTable(ConnectorSession session, SchemaTableName tableName, SchemaTableName sourceTableName) {
        HiveTableHandle sourceTableHandle = this.getTableHandle(session, sourceTableName);
        if (sourceTableHandle == null) {
            return Optional.empty();
        }
        List<HiveColumnHandle> partitionColumns = sourceTableHandle.getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return Optional.empty();
        }
        List partitionColumnTypes = (List)partitionColumns.stream().map(HiveColumnHandle::getTypeSignature).map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        List partitionSystemTableColumns = (List)partitionColumns.stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getTypeSignature()), (String)column.getComment().orElse(null), column.isHidden())).collect(ImmutableList.toImmutableList());
        Map fieldIdToColumnHandle = (Map)IntStream.range(0, partitionColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), partitionColumns::get));
        return Optional.of(HiveMetadata.createSystemTable(new ConnectorTableMetadata(tableName, partitionSystemTableColumns), constraint -> {
            TupleDomain targetTupleDomain = constraint.transform(fieldIdToColumnHandle::get);
            Predicate<Map<ColumnHandle, NullableValue>> targetPredicate = HiveMetadata.convertToPredicate((TupleDomain<ColumnHandle>)targetTupleDomain);
            Constraint targetConstraint = new Constraint(targetTupleDomain, targetPredicate);
            Iterable records = () -> Streams.stream(this.partitionManager.getPartitions(this.metastore, sourceTableHandle, targetConstraint).getPartitions()).map(hivePartition -> IntStream.range(0, partitionColumns.size()).mapToObj(fieldIdToColumnHandle::get).map(columnHandle -> hivePartition.getKeys().get(columnHandle).getValue()).collect(Collectors.toList())).iterator();
            return new InMemoryRecordSet((Collection)partitionColumnTypes, records).cursor();
        }));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(((HiveTableHandle)tableHandle).getSchemaTableName());
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        try {
            return this.doGetTableMetadata(tableName);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to construct table metadata for table " + tableName, e);
        }
    }

    private ConnectorTableMetadata doGetTableMetadata(SchemaTableName tableName) {
        String textSkipFooterCount;
        String textSkipHeaderCount;
        String avroSchemaUrl;
        String orcBloomFilterFfp;
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        Function<HiveColumnHandle, ColumnMetadata> metadataGetter = HiveMetadata.columnMetadataGetter(table.get(), this.typeManager);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(table.get())) {
            columns.add((Object)metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (table.get().getTableType().equals(TableType.EXTERNAL_TABLE.name())) {
            properties.put((Object)"external_location", (Object)table.get().getStorage().getLocation());
        }
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table.get());
            properties.put((Object)"format", (Object)format);
        }
        catch (PrestoException format) {
            // empty catch block
        }
        List partitionedBy = table.get().getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        table.get().getStorage().getBucketProperty().ifPresent(property -> {
            properties.put((Object)"bucket_count", (Object)property.getBucketCount());
            properties.put((Object)"bucketed_by", property.getBucketedBy());
            properties.put((Object)"sorted_by", property.getSortedBy());
        });
        String orcBloomFilterColumns = table.get().getParameters().get(ORC_BLOOM_FILTER_COLUMNS_KEY);
        if (orcBloomFilterColumns != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFfp = table.get().getParameters().get(ORC_BLOOM_FILTER_FPP_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFfp));
        }
        if ((avroSchemaUrl = table.get().getParameters().get(AVRO_SCHEMA_URL_KEY)) != null) {
            properties.put((Object)"avro_schema_url", (Object)avroSchemaUrl);
        }
        if ((textSkipHeaderCount = table.get().getParameters().get(TEXT_SKIP_HEADER_COUNT_KEY)) != null) {
            properties.put((Object)"textfile_skip_header_line_count", (Object)Integer.valueOf(textSkipHeaderCount));
        }
        if ((textSkipFooterCount = table.get().getParameters().get(TEXT_SKIP_FOOTER_COUNT_KEY)) != null) {
            properties.put((Object)"textfile_skip_footer_line_count", (Object)Integer.valueOf(textSkipFooterCount));
        }
        HiveMetadata.getCsvSerdeProperty(table.get(), CSV_SEPARATOR_KEY).ifPresent(csvSeparator -> properties.put((Object)"csv_separator", csvSeparator));
        HiveMetadata.getCsvSerdeProperty(table.get(), CSV_QUOTE_KEY).ifPresent(csvQuote -> properties.put((Object)"csv_quote", csvQuote));
        HiveMetadata.getCsvSerdeProperty(table.get(), CSV_ESCAPE_KEY).ifPresent(csvEscape -> properties.put((Object)"csv_escape", csvEscape));
        Optional<String> comment = Optional.ofNullable(table.get().getParameters().get(TABLE_COMMENT));
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), comment);
    }

    private static Optional<String> getCsvSerdeProperty(Table table, String key) {
        return HiveMetadata.getSerdeProperty(table, key).map(csvSerdeProperty -> {
            if (csvSerdeProperty.length() > 1) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Only single character can be set for property: " + key);
            }
            return csvSerdeProperty;
        });
    }

    private static Optional<String> getSerdeProperty(Table table, String key) {
        String serdePropertyValue = table.getStorage().getSerdeParameters().get(key);
        String tablePropertyValue = table.getParameters().get(key);
        if (serdePropertyValue != null && tablePropertyValue != null && !tablePropertyValue.equals(serdePropertyValue)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Different values for '%s' set in serde properties and table properties: '%s' and '%s'", key, serdePropertyValue, tablePropertyValue));
        }
        return HiveMetadata.firstNonNullable(tablePropertyValue, serdePropertyValue);
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        return ((HiveTableHandle)table).getPartitions().map(partitions -> new HiveInputInfo((List)partitions.stream().map(HivePartition::getPartitionId).collect(ImmutableList.toImmutableList()), false));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent()) {
            return ImmutableList.of((Object)schemaName.get());
        }
        return this.listSchemaNames(session);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return (Map)HiveUtil.hiveColumnHandles(table).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        Map columns = (Map)this.getColumnHandles(session, tableHandle).entrySet().stream().filter(entry -> !((HiveColumnHandle)entry.getValue()).isHidden()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map columnTypes = (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.getColumnMetadata(session, tableHandle, (ColumnHandle)entry.getValue()).getType()));
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, tableHandle, constraint);
        List<HivePartition> partitions = this.partitionManager.getPartitionsAsList(partitionResult);
        return this.hiveStatisticsProvider.getTableStatistics(session, ((HiveTableHandle)tableHandle).getSchemaTableName(), columns, columnTypes, partitions);
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (!prefix.getTable().isPresent()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata(this.typeManager);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(locationUri));
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        this.metastore.createDatabase(database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, Optional.of(schemaName)).isEmpty() || !this.listViews(session, Optional.of(schemaName)).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        this.metastore.dropDatabase(schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Path targetPath;
        boolean external;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if ((bucketProperty.isPresent() || !partitionedBy.isEmpty()) && HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing/Partitioning columns not supported when Avro schema url is set");
        }
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, new HdfsEnvironment.HdfsContext(session, schemaName, tableName));
        hiveStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        String externalLocation = HiveTableProperties.getExternalLocation(tableMetadata.getProperties());
        if (externalLocation != null) {
            if (!this.createsOfNonManagedTablesEnabled) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create non-managed Hive table");
            }
            external = true;
            targetPath = this.getExternalPath(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), externalLocation);
        } else {
            external = false;
            LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName);
            targetPath = this.locationService.getQueryWriteInfo(locationHandle).getTargetPath();
        }
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), schemaName, tableName, session.getUser(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, tableProperties, targetPath, external, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(table.getOwner());
        HiveBasicStatistics basicStatistics = table.getPartitionColumns().isEmpty() ? HiveBasicStatistics.createZeroStatistics() : HiveBasicStatistics.createEmptyStatistics();
        this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), ignoreExisting, new PartitionStatistics(basicStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of()));
    }

    private Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, HdfsEnvironment.HdfsContext hdfsContext) {
        String avroSchemaUrl;
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        List<String> columns = HiveTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties());
        if (columns != null && !columns.isEmpty()) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.ORC, "orc_bloom_filter_columns");
            tableProperties.put((Object)ORC_BLOOM_FILTER_COLUMNS_KEY, (Object)Joiner.on((String)",").join(columns));
            tableProperties.put((Object)ORC_BLOOM_FILTER_FPP_KEY, (Object)String.valueOf(HiveTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        if ((avroSchemaUrl = HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties())) != null) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.AVRO, "avro_schema_url");
            tableProperties.put((Object)AVRO_SCHEMA_URL_KEY, (Object)this.validateAndNormalizeAvroSchemaUrl(avroSchemaUrl, hdfsContext));
        }
        HiveTableProperties.getTextHeaderSkipCount(tableMetadata.getProperties()).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 0) {
                HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, "textfile_skip_header_line_count");
                tableProperties.put((Object)TEXT_SKIP_HEADER_COUNT_KEY, (Object)String.valueOf(headerSkipCount));
            }
            if (headerSkipCount < 0) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "textfile_skip_header_line_count", headerSkipCount));
            }
        });
        HiveTableProperties.getTextFooterSkipCount(tableMetadata.getProperties()).ifPresent(footerSkipCount -> {
            if (footerSkipCount > 0) {
                HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, "textfile_skip_footer_line_count");
                tableProperties.put((Object)TEXT_SKIP_FOOTER_COUNT_KEY, (Object)String.valueOf(footerSkipCount));
            }
            if (footerSkipCount < 0) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "textfile_skip_footer_line_count", footerSkipCount));
            }
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_escape");
            tableProperties.put((Object)CSV_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_quote").ifPresent(quote -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_quote");
            tableProperties.put((Object)CSV_QUOTE_KEY, (Object)quote.toString());
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_separator");
            tableProperties.put((Object)CSV_SEPARATOR_KEY, (Object)separator.toString());
        });
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)TABLE_COMMENT, value));
        return tableProperties.build();
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, HiveStorageFormat expectedStorageFormat, String propertyName) {
        if (actualStorageFormat != expectedStorageFormat) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", new Object[]{propertyName, actualStorageFormat}));
        }
    }

    private String validateAndNormalizeAvroSchemaUrl(String url, HdfsEnvironment.HdfsContext context) {
        try {
            new URL(url).openStream().close();
            return url;
        }
        catch (MalformedURLException e) {
            if (new File(url).exists()) {
                return new File(url).toURI().toString();
            }
            try {
                if (!this.hdfsEnvironment.getFileSystem(context, new Path(url)).exists(new Path(url))) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot locate Avro schema file: " + url);
                }
                return url;
            }
            catch (IOException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Avro schema file is not a valid file system URI: " + url, (Throwable)ex);
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot open Avro schema file: " + url, (Throwable)e);
        }
    }

    private Path getExternalPath(HdfsEnvironment.HdfsContext context, String location) {
        try {
            Path path = new Path(location);
            if (!HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path) && !this.hdfsEnvironment.getFileSystem(context, path).isDirectory(path)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory");
            }
            return path;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI", (Throwable)e);
        }
    }

    private void checkPartitionTypesSupported(List<Column> partitionColumns) {
        for (Column partitionColumn : partitionColumns) {
            Type partitionType = this.typeManager.getType(partitionColumn.getType().getTypeSignature());
            HiveUtil.verifyPartitionTypeSupported(partitionColumn.getName(), partitionType);
        }
    }

    private static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Path targetPath, boolean external, String prestoVersion) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            HiveType type = columnHandle.getHiveType();
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new Column(name, type, columnHandle.getComment()));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        ImmutableMap.Builder tableParameters = ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)queryId).putAll(additionalTableParameters);
        if (external) {
            tableParameters.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType((external ? TableType.EXTERNAL_TABLE : TableType.MANAGED_TABLE).name()).setDataColumns((List<Column>)columns.build()).setPartitionColumns(partitionColumns).setParameters((Map<String, String>)tableParameters.build());
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat(hiveStorageFormat)).setBucketProperty(bucketProperty).setLocation(targetPath.toString());
        return tableBuilder.build();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(handle);
        this.metastore.addColumn(handle.getSchemaName(), handle.getTableName(), column.getName(), HiveType.toHiveType(this.typeTranslator, column.getType()), column.getComment());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(hiveTableHandle);
        HiveColumnHandle sourceHandle = (HiveColumnHandle)source;
        this.metastore.renameColumn(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), sourceHandle.getName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(hiveTableHandle);
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        this.metastore.dropColumn(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), columnHandle.getName());
    }

    private void failIfAvroSchemaIsSet(HiveTableHandle handle) {
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.getParameters().containsKey(AVRO_SCHEMA_URL_KEY) || table.getStorage().getSerdeParameters().containsKey(AVRO_SCHEMA_URL_KEY)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ALTER TABLE not supported when Avro schema url is set");
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.renameTable(handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.commentTable(handle.getSchemaName(), handle.getTableName(), comment);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional<Table> target = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.verifyJvmTimeZone();
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        List<Column> partitionColumns = table.getPartitionColumns();
        List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        List<HiveColumnHandle> hiveColumnHandles = HiveUtil.hiveColumnHandles(table);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> computedStatisticsMap = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionColumnNames, columnTypes);
        if (partitionColumns.isEmpty()) {
            this.metastore.setTableStatistics(table, this.createPartitionStatistics(session, columnTypes, computedStatisticsMap.get(ImmutableList.of())));
        } else {
            List partitionValuesList = handle.getAnalyzePartitionValues().isPresent() ? handle.getAnalyzePartitionValues().get() : (List)this.metastore.getPartitionNames(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(((HiveTableHandle)tableHandle).getSchemaTableName())).stream().map(HiveUtil::toPartitionValues).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder partitionStatistics = ImmutableMap.builder();
            Map columnStatisticTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !partitionColumnNames.contains(columnHandle.getName())).filter(column -> !column.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> ImmutableSet.copyOf(this.metastore.getSupportedColumnStatistics(this.typeManager.getType(column.getTypeSignature())))));
            Supplier emptyPartitionStatistics = Suppliers.memoize(() -> Statistics.createEmptyPartitionStatistics(columnTypes, columnStatisticTypes));
            int usedComputedStatistics = 0;
            for (List partitionValues : partitionValuesList) {
                ComputedStatistics collectedStatistics = computedStatisticsMap.get(partitionValues);
                if (collectedStatistics == null) {
                    partitionStatistics.put((Object)partitionValues, emptyPartitionStatistics.get());
                    continue;
                }
                ++usedComputedStatistics;
                partitionStatistics.put((Object)partitionValues, (Object)this.createPartitionStatistics(session, columnTypes, collectedStatistics));
            }
            Verify.verify((usedComputedStatistics == computedStatistics.size() ? 1 : 0) != 0, (String)"All computed statistics must be used", (Object[])new Object[0]);
            this.metastore.setPartitionStatistics(table, (Map<List<String>, PartitionStatistics>)partitionStatistics.build());
        }
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.verifyJvmTimeZone();
        if (HiveTableProperties.getExternalLocation(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "External tables cannot be created using CREATE TABLE AS");
        }
        if (HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS not supported when Avro schema url is set");
        }
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, new HdfsEnvironment.HdfsContext(session, schemaName, tableName));
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat actualStorageFormat = partitionedBy.isEmpty() ? tableStorageFormat : partitionStorageFormat;
        actualStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName);
        HiveOutputTableHandle result = new HiveOutputTableHandle(schemaName, tableName, columnHandles, this.metastore.generatePageSinkMetadata(schemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, partitionedBy, bucketProperty, session.getUser(), tableProperties);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), schemaTableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        PartitionStatistics tableStatistics;
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(handle.getLocationHandle());
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getAdditionalTableParameters(), writeInfo.getTargetPath(), false, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(handle.getTableOwner());
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                this.createEmptyFiles(session, partitionUpdate.getWritePath(), table, partition, partitionUpdate.getFileNames());
            }
        }
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, handle.getPartitionedBy(), columnTypes);
        if (table.getPartitionColumns().isEmpty()) {
            HiveBasicStatistics basicStatistics = partitionUpdates.stream().map(PartitionUpdate::getStatistics).reduce((first, second) -> Statistics.reduce(first, second, Statistics.ReduceOperator.ADD)).orElse(HiveBasicStatistics.createZeroStatistics());
            tableStatistics = this.createPartitionStatistics(session, basicStatistics, columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
        } else {
            tableStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
        this.metastore.createTable(session, table, principalPrivileges, Optional.of(writeInfo.getWritePath()), false, tableStatistics);
        if (!handle.getPartitionedBy().isEmpty()) {
            if (HiveSessionProperties.isRespectTableFormat(session)) {
                Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
            }
            for (PartitionUpdate update : partitionUpdates) {
                Partition partition = this.buildPartitionObject(session, table, update);
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, update.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), this.buildPartitionObject(session, table, update), update.getWritePath(), partitionStatistics);
            }
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    private List<PartitionUpdate> computePartitionUpdatesForMissingBuckets(ConnectorSession session, HiveWritableTableHandle handle, Table table, List<PartitionUpdate> partitionUpdates) {
        ImmutableList.Builder partitionUpdatesForMissingBucketsBuilder = ImmutableList.builder();
        HiveStorageFormat storageFormat = table.getPartitionColumns().isEmpty() ? handle.getTableStorageFormat() : handle.getPartitionStorageFormat();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, table, storageFormat, partitionUpdate.getTargetPath(), bucketCount, partitionUpdate);
            partitionUpdatesForMissingBucketsBuilder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), fileNamesForMissingBuckets, 0L, 0L, 0L));
        }
        return partitionUpdatesForMissingBucketsBuilder.build();
    }

    private List<String> computeFileNamesForMissingBuckets(ConnectorSession session, Table table, HiveStorageFormat storageFormat, Path targetPath, int bucketCount, PartitionUpdate partitionUpdate) {
        if (partitionUpdate.getFileNames().size() == bucketCount) {
            return ImmutableList.of();
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(hdfsContext, targetPath));
        String fileExtension = HiveWriterFactory.getFileExtension(conf, StorageFormat.fromHiveStorageFormat(storageFormat));
        ImmutableSet fileNames = ImmutableSet.copyOf(partitionUpdate.getFileNames());
        ImmutableList.Builder missingFileNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < bucketCount; ++i) {
            String fileName = HiveWriterFactory.computeBucketedFileName(session.getQueryId(), i) + fileExtension;
            if (fileNames.contains(fileName)) continue;
            missingFileNamesBuilder.add((Object)fileName);
        }
        ImmutableList missingFileNames = missingFileNamesBuilder.build();
        Verify.verify((fileNames.size() + missingFileNames.size() == bucketCount ? 1 : 0) != 0);
        return missingFileNames;
    }

    private void createEmptyFiles(ConnectorSession session, Path path, Table table, Optional<Partition> partition, List<String> fileNames) {
        StorageFormat format;
        Properties schema;
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName()), path));
        if (partition.isPresent()) {
            schema = MetastoreUtil.getHiveSchema(partition.get(), table);
            format = partition.get().getStorage().getStorageFormat();
        } else {
            schema = MetastoreUtil.getHiveSchema(table);
            format = table.getStorage().getStorageFormat();
        }
        this.hdfsEnvironment.doAs(session.getUser(), () -> {
            for (String fileName : fileNames) {
                HiveMetadata.writeEmptyFile(session, new Path(path, fileName), conf, schema, format.getSerDe(), format.getOutputFormat());
            }
        });
    }

    private static void writeEmptyFile(ConnectorSession session, Path target, JobConf conf, Properties properties, String serDe, String outputFormatName) {
        HiveWriteUtils.initializeSerializer((Configuration)conf, properties, serDe);
        FileSinkOperator.RecordWriter recordWriter = HiveWriteUtils.createRecordWriter(target, conf, properties, outputFormatName, session);
        try {
            recordWriter.close(false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error write empty file to Hive", (Throwable)e);
        }
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.verifyJvmTimeZone();
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        HiveWriteUtils.checkTableIsWritable(table, this.writesToNonManagedTablesEnabled);
        for (Column column : table.getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table %s with column type %s not supported", tableName, column.getType()));
        }
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles(table).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table);
        if (tableStorageFormat == HiveStorageFormat.TEXTFILE) {
            if (table.getParameters().containsKey(TEXT_SKIP_HEADER_COUNT_KEY)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with %s property not supported", TEXT_SKIP_HEADER_COUNT_KEY));
            }
            if (table.getParameters().containsKey(TEXT_SKIP_FOOTER_COUNT_KEY)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with %s property not supported", TEXT_SKIP_FOOTER_COUNT_KEY));
            }
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        HiveInsertTableHandle result = new HiveInsertTableHandle(tableName.getSchemaName(), tableName.getTableName(), handles, this.metastore.generatePageSinkMetadata(tableName), locationHandle, table.getStorage().getBucketProperty(), tableStorageFormat, HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session));
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), tableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (!table.getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
        }
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                this.createEmptyFiles(session, partitionUpdate.getWritePath(), table, partition, partitionUpdate.getFileNames());
            }
        }
        List partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionedBy, columnTypes);
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            PartitionStatistics partitionStatistics;
            if (partitionUpdate.getName().isEmpty()) {
                if (!table.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
                }
                PartitionStatistics partitionStatistics2 = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    PrincipalPrivileges principalPrivileges = PrincipalPrivileges.fromHivePrivilegeInfos(this.metastore.listTablePrivileges(handle.getSchemaName(), handle.getTableName(), null));
                    this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
                    this.metastore.createTable(session, table, principalPrivileges, Optional.of(partitionUpdate.getWritePath()), false, partitionStatistics2);
                    continue;
                }
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                    this.metastore.finishInsertIntoExistingTable(session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics2);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported update mode: " + (Object)((Object)partitionUpdate.getUpdateMode()));
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                List<String> partitionValues = HiveUtil.toPartitionValues(partitionUpdate.getName());
                partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partitionValues));
                this.metastore.finishInsertIntoExistingPartition(session, handle.getSchemaName(), handle.getTableName(), partitionValues, partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics);
                continue;
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                Partition partition = this.buildPartitionObject(session, table, partitionUpdate);
                if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
                }
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), partition.getValues());
                }
                partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), partitionStatistics);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported update mode: %s", new Object[]{partitionUpdate.getUpdateMode()}));
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    private Partition buildPartitionObject(ConnectorSession session, Table table, PartitionUpdate partitionUpdate) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionUpdate.getName())).setParameters((Map<String, String>)ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build()).withStorage(storage -> storage.setStorageFormat(HiveSessionProperties.isRespectTableFormat(session) ? table.getStorage().getStorageFormat() : StorageFormat.fromHiveStorageFormat(HiveSessionProperties.getHiveStorageFormat(session))).setLocation(partitionUpdate.getTargetPath().toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private PartitionStatistics createPartitionStatistics(ConnectorSession session, Map<String, Type> columnTypes, ComputedStatistics computedStatistics) {
        Map computedColumnStatistics = computedStatistics.getColumnStatistics();
        Block rowCountBlock = (Block)Optional.ofNullable(computedStatistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).orElseThrow(() -> new VerifyException("rowCount not present"));
        Verify.verify((!rowCountBlock.isNull(0) ? 1 : 0) != 0, (String)"rowCount must never be null", (Object[])new Object[0]);
        long rowCount = BigintType.BIGINT.getLong(rowCountBlock, 0);
        HiveBasicStatistics rowCountOnlyBasicStatistics = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return this.createPartitionStatistics(session, rowCountOnlyBasicStatistics, columnTypes, computedColumnStatistics);
    }

    private PartitionStatistics createPartitionStatistics(ConnectorSession session, HiveBasicStatistics basicStatistics, Map<String, Type> columnTypes, Map<ColumnStatisticMetadata, Block> computedColumnStatistics) {
        long rowCount = basicStatistics.getRowCount().orElseThrow(() -> new IllegalArgumentException("rowCount not present"));
        Map<String, HiveColumnStatistics> columnStatistics = Statistics.fromComputedStatistics(session, this.timeZone, computedColumnStatistics, columnTypes, rowCount);
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private static Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> statistics, List<String> partitionValues) {
        return Optional.ofNullable(statistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics).orElse((Map)ImmutableMap.of());
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        ImmutableMap properties = ImmutableMap.builder().put((Object)TABLE_COMMENT, (Object)"Presto View").put((Object)"presto_view", (Object)"true").put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build();
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(session.getUser()).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List<Column>)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List<Column>)ImmutableList.of()).setParameters((Map<String, String>)properties).setViewOriginalText(Optional.of(HiveUtil.encodeViewData(definition))).setViewExpandedText(Optional.of("/* Presto View */"));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        Optional<Table> existing = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !HiveUtil.isPrestoView(existing.get())) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceView(viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), false, new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of()));
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        try {
            this.metastore.dropTable(session, viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllViews(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).filter(HiveUtil::isPrestoView).map(view -> {
            ConnectorViewDefinition definition = HiveUtil.decodeViewData(view.getViewOriginalText().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view original text: " + viewName)));
            if (view.getOwner() != null && !definition.isRunAsInvoker()) {
                definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), Optional.of(view.getOwner()), false);
            }
            return definition;
        });
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.updateRowIdHandle();
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle deleteHandle) {
        HiveTableHandle handle = (HiveTableHandle)deleteHandle;
        Optional<Table> table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        if (table.get().getPartitionColumns().isEmpty()) {
            this.metastore.truncateUnpartitionedTable(session, handle.getSchemaName(), handle.getTableName());
        } else {
            for (HivePartition hivePartition : this.partitionManager.getOrLoadPartitions(this.metastore, handle)) {
                this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), HiveUtil.toPartitionValues(hivePartition.getPartitionId()));
            }
        }
        return OptionalLong.empty();
    }

    @VisibleForTesting
    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        HiveTableHandle hiveTable = (HiveTableHandle)table;
        ImmutableList partitionColumns = ImmutableList.copyOf(hiveTable.getPartitionColumns());
        List<HivePartition> partitions = this.partitionManager.getOrLoadPartitions(this.metastore, hiveTable);
        TupleDomain<ColumnHandle> predicate = HiveMetadata.createPredicate((List<ColumnHandle>)partitionColumns, partitions);
        Optional<Object> discretePredicates = Optional.empty();
        if (!partitionColumns.isEmpty()) {
            Iterable partitionDomains = Iterables.transform(partitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
            discretePredicates = Optional.of(new DiscretePredicates((List)partitionColumns, partitionDomains));
        }
        Optional<Object> tablePartitioning = Optional.empty();
        if (HiveSessionProperties.isBucketExecutionEnabled(session) && hiveTable.getBucketHandle().isPresent()) {
            tablePartitioning = hiveTable.getBucketHandle().map(bucketing -> new ConnectorTablePartitioning((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketing.getReadBucketCount(), (List)bucketing.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), OptionalInt.empty()), bucketing.getColumns().stream().map(ColumnHandle.class::cast).collect(Collectors.toList())));
        }
        return new ConnectorTableProperties(predicate, tablePartitioning, Optional.empty(), discretePredicates, (List)ImmutableList.of());
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((!handle.getAnalyzePartitionValues().isPresent() || constraint.getSummary().isAll() ? 1 : 0) != 0, (Object)"Analyze should not have a constraint");
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, handle, constraint);
        HiveTableHandle newHandle = this.partitionManager.applyPartitionResult(handle, partitionResult);
        if (handle.getPartitions().equals(newHandle.getPartitions()) && handle.getCompactEffectivePredicate().equals(newHandle.getCompactEffectivePredicate()) && handle.getBucketFilter().equals(newHandle.getBucketFilter())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, partitionResult.getUnenforcedConstraint()));
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        int smallerBucketCount;
        HivePartitioningHandle leftHandle = (HivePartitioningHandle)left;
        HivePartitioningHandle rightHandle = (HivePartitioningHandle)right;
        if (!leftHandle.getHiveTypes().equals(rightHandle.getHiveTypes())) {
            return Optional.empty();
        }
        if (leftHandle.getBucketCount() == rightHandle.getBucketCount()) {
            return Optional.of(leftHandle);
        }
        if (!HiveSessionProperties.isOptimizedMismatchedBucketCount(session)) {
            return Optional.empty();
        }
        int largerBucketCount = Math.max(leftHandle.getBucketCount(), rightHandle.getBucketCount());
        if (largerBucketCount % (smallerBucketCount = Math.min(leftHandle.getBucketCount(), rightHandle.getBucketCount())) != 0) {
            return Optional.empty();
        }
        if (Integer.bitCount(largerBucketCount / smallerBucketCount) != 1) {
            return Optional.empty();
        }
        OptionalInt maxCompatibleBucketCount = HiveMetadata.min(leftHandle.getMaxCompatibleBucketCount(), rightHandle.getMaxCompatibleBucketCount());
        if (maxCompatibleBucketCount.isPresent() && maxCompatibleBucketCount.getAsInt() < smallerBucketCount) {
            return Optional.empty();
        }
        return Optional.of(new HivePartitioningHandle(smallerBucketCount, leftHandle.getHiveTypes(), maxCompatibleBucketCount));
    }

    private static OptionalInt min(OptionalInt left, OptionalInt right) {
        if (!left.isPresent()) {
            return right;
        }
        if (!right.isPresent()) {
            return left;
        }
        return OptionalInt.of(Math.min(left.getAsInt(), right.getAsInt()));
    }

    public ConnectorTableHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorPartitioningHandle partitioningHandle) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        HivePartitioningHandle hivePartitioningHandle = (HivePartitioningHandle)partitioningHandle;
        Preconditions.checkArgument((boolean)hiveTable.getBucketHandle().isPresent(), (Object)"Hive connector only provides alternative layout for bucketed table");
        HiveBucketHandle bucketHandle = hiveTable.getBucketHandle().get();
        ImmutableList bucketTypes = (ImmutableList)bucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)hivePartitioningHandle.getHiveTypes().equals(bucketTypes), (String)"Types from the new PartitioningHandle (%s) does not match the TableHandle (%s)", hivePartitioningHandle.getHiveTypes(), (Object)bucketTypes);
        int largerBucketCount = Math.max(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        int smallerBucketCount = Math.min(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        Preconditions.checkArgument((largerBucketCount % smallerBucketCount == 0 && Integer.bitCount(largerBucketCount / smallerBucketCount) == 1 ? 1 : 0) != 0, (Object)"The requested partitioning is not a valid alternative for the table layout");
        return new HiveTableHandle(hiveTable.getSchemaName(), hiveTable.getTableName(), hiveTable.getPartitionColumns(), hiveTable.getPartitions(), hiveTable.getCompactEffectivePredicate(), hiveTable.getEnforcedConstraint(), Optional.of(new HiveBucketHandle(bucketHandle.getColumns(), bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount())), hiveTable.getBucketFilter(), hiveTable.getAnalyzePartitionValues());
    }

    @VisibleForTesting
    static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> HiveMetadata.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        ArrayList<Object> nonNullValues = new ArrayList<Object>();
        Type type = null;
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
            } else {
                nonNullValues.add(value.getValue());
            }
            if (type != null) continue;
            type = value.getType();
        }
        if (!nonNullValues.isEmpty()) {
            Domain domain = Domain.multipleValues(type, nonNullValues);
            if (hasNull) {
                return domain.union(Domain.onlyNull(type));
            }
            return domain;
        }
        return Domain.onlyNull(type);
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (!HiveBucketing.isHiveBucketingV1(table) && table.getStorage().getBucketProperty().isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table bucketing version not supported for writing");
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (!hiveBucketHandle.isPresent()) {
            return Optional.empty();
        }
        HiveBucketProperty bucketProperty = table.getStorage().getBucketProperty().orElseThrow(() -> new NoSuchElementException("Bucket property should be set"));
        if (!bucketProperty.getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(hiveBucketHandle.get().getTableBucketCount(), hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getHiveType).collect(Collectors.toList()), OptionalInt.of(hiveBucketHandle.get().getTableBucketCount()));
        List partitionColumns = hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getName).collect(Collectors.toList());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumns));
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateCsvColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return Optional.empty();
        }
        if (!bucketProperty.get().getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        List<String> bucketedBy = bucketProperty.get().getBucketedBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType(this.typeTranslator, column.getType())));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketProperty.get().getBucketCount(), bucketedBy.stream().map(hiveTypeMap::get).collect(Collectors.toList()), OptionalInt.of(bucketProperty.get().getBucketCount())), bucketedBy));
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        if (!HiveSessionProperties.isCollectColumnStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, false);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, true);
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(List<ColumnMetadata> columns, List<String> partitionedBy, boolean includeRowCount) {
        Set columnStatistics = (Set)columns.stream().filter(column -> !partitionedBy.contains(column.getName())).filter(column -> !column.isHidden()).map(this::getColumnStatisticMetadata).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = includeRowCount ? ImmutableSet.of((Object)TableStatisticType.ROW_COUNT) : ImmutableSet.of();
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, partitionedBy);
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(ColumnMetadata columnMetadata) {
        return this.getColumnStatisticMetadata(columnMetadata.getName(), this.metastore.getSupportedColumnStatistics(columnMetadata.getType()));
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(String columnName, Set<ColumnStatisticType> statisticTypes) {
        return (List)statisticTypes.stream().map(type -> new ColumnStatisticMetadata(columnName, type)).collect(ImmutableList.toImmutableList());
    }

    public void createRole(ConnectorSession session, String role, Optional<PrestoPrincipal> grantor) {
        this.accessControlMetadata.createRole(session, role, grantor.map(HivePrincipal::from));
    }

    public void dropRole(ConnectorSession session, String role) {
        this.accessControlMetadata.dropRole(session, role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return this.accessControlMetadata.listRoles(session);
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
        return ImmutableSet.copyOf(this.accessControlMetadata.listRoleGrants(session, HivePrincipal.from(principal)));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor) {
        this.accessControlMetadata.grantRoles(session, roles, HivePrincipal.from(grantees), withAdminOption, grantor.map(HivePrincipal::from));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor) {
        this.accessControlMetadata.revokeRoles(session, roles, HivePrincipal.from(grantees), adminOptionFor, grantor.map(HivePrincipal::from));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
        return this.accessControlMetadata.listApplicableRoles(session, HivePrincipal.from(principal));
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        return this.accessControlMetadata.listEnabledRoles(session);
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        return this.accessControlMetadata.listTablePrivileges(session, this.listTables(session, schemaTablePrefix));
    }

    private void verifyJvmTimeZone() {
        if (!this.allowCorruptWritesForTesting && !this.timeZone.equals((Object)DateTimeZone.getDefault())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TIMEZONE_MISMATCH, String.format("To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments.", this.timeZone.getID()));
        }
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageFormat storageFormat = table.getStorage().getStorageFormat();
        String outputFormat = storageFormat.getOutputFormat();
        String serde = storageFormat.getSerDe();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serde)) continue;
            return format;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serde));
    }

    private static void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
        List<String> bucketedBy;
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return;
        }
        Set allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
        if (!allColumns.containsAll(bucketedBy = bucketProperty.get().getBucketedBy())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(bucketedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        List sortedBy = (List)bucketProperty.get().getSortedBy().stream().map(SortingColumn::getColumnName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(sortedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    private static List<HiveColumnHandle> getColumnHandles(ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames, TypeTranslator typeTranslator) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateCsvColumns(tableMetadata);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            HiveColumnHandle.ColumnType columnType = partitionColumnNames.contains(column.getName()) ? HiveColumnHandle.ColumnType.PARTITION_KEY : (column.isHidden() ? HiveColumnHandle.ColumnType.SYNTHESIZED : HiveColumnHandle.ColumnType.REGULAR);
            columnHandles.add((Object)new HiveColumnHandle(column.getName(), HiveType.toHiveType(typeTranslator, column.getType()), column.getType().getTypeSignature(), ordinal, columnType, Optional.ofNullable(column.getComment())));
            ++ordinal;
        }
        return columnHandles.build();
    }

    private static void validateCsvColumns(ConnectorTableMetadata tableMetadata) {
        if (HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties()) != HiveStorageFormat.CSV) {
            return;
        }
        ImmutableSet partitionedBy = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        List unsupportedColumns = (List)tableMetadata.getColumns().stream().filter(arg_0 -> HiveMetadata.lambda$validateCsvColumns$62((Set)partitionedBy, arg_0)).filter(columnMetadata -> !columnMetadata.getType().equals(VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        if (!unsupportedColumns.isEmpty()) {
            String joinedUnsupportedColumns = unsupportedColumns.stream().map(columnMetadata -> String.format("%s %s", columnMetadata.getName(), columnMetadata.getType())).collect(Collectors.joining(", "));
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: " + joinedUnsupportedColumns);
        }
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List<Column> tableColumns = table.getDataColumns();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column field : Iterables.concat(tableColumns, table.getPartitionColumns())) {
            if (field.getComment().isPresent() && !field.getComment().get().equals("from deserializer")) {
                builder.put((Object)field.getName(), field.getComment());
                continue;
            }
            builder.put((Object)field.getName(), Optional.empty());
        }
        builder.put((Object)"$path", Optional.empty());
        if (table.getStorage().getBucketProperty().isPresent()) {
            builder.put((Object)"$bucket", Optional.empty());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$65(typeManager, (Map)columnComment, arg_0);
    }

    @Override
    public void rollback() {
        this.metastore.rollback();
    }

    @Override
    public void commit() {
        this.metastore.commit();
    }

    public static Optional<SchemaTableName> getSourceTableNameFromSystemTable(SchemaTableName tableName) {
        return Stream.of(SystemTableHandler.values()).filter(handler -> handler.matches(tableName)).map(handler -> handler.getSourceTableName(tableName)).findAny();
    }

    private static SystemTable createSystemTable(final ConnectorTableMetadata metadata, final Function<TupleDomain<Integer>, RecordCursor> cursor) {
        return new SystemTable(){

            public SystemTable.Distribution getDistribution() {
                return SystemTable.Distribution.SINGLE_COORDINATOR;
            }

            public ConnectorTableMetadata getTableMetadata() {
                return metadata;
            }

            public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
                return (RecordCursor)cursor.apply(constraint);
            }
        };
    }

    private static <T> Optional<T> firstNonNullable(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$65(TypeManager typeManager, Map columnComment, HiveColumnHandle handle) {
        return new ColumnMetadata(handle.getName(), typeManager.getType(handle.getTypeSignature()), (String)((Optional)columnComment.get(handle.getName())).orElse(null), HiveUtil.columnExtraInfo(handle.isPartitionKey()), handle.isHidden());
    }

    private static /* synthetic */ boolean lambda$validateCsvColumns$62(Set partitionedBy, ColumnMetadata columnMetadata) {
        return !partitionedBy.contains(columnMetadata.getName());
    }

    private static /* synthetic */ RecordCursor lambda$getPropertiesSystemTable$4(List types, Iterable propertyValues, TupleDomain constraint) {
        return new InMemoryRecordSet((Collection)types, propertyValues).cursor();
    }

    private static enum SystemTableHandler {
        PARTITIONS,
        PROPERTIES;

        private final String suffix = "$" + this.name().toLowerCase(Locale.ENGLISH);

        boolean matches(SchemaTableName table) {
            return table.getTableName().endsWith(this.suffix) && table.getTableName().length() > this.suffix.length();
        }

        SchemaTableName getSourceTableName(SchemaTableName table) {
            return new SchemaTableName(table.getSchemaName(), table.getTableName().substring(0, table.getTableName().length() - this.suffix.length()));
        }
    }
}

