/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.OpenCSVSerde;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.data.JsonSerDe;

public enum HiveStorageFormat {
    ORC(OrcSerde.class.getName(), OrcInputFormat.class.getName(), OrcOutputFormat.class.getName(), new DataSize(256.0, DataSize.Unit.MEGABYTE)),
    PARQUET(ParquetHiveSerDe.class.getName(), MapredParquetInputFormat.class.getName(), MapredParquetOutputFormat.class.getName(), new DataSize(128.0, DataSize.Unit.MEGABYTE)),
    AVRO(AvroSerDe.class.getName(), AvroContainerInputFormat.class.getName(), AvroContainerOutputFormat.class.getName(), new DataSize(64.0, DataSize.Unit.MEGABYTE)),
    RCBINARY(LazyBinaryColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    RCTEXT(ColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    SEQUENCEFILE(LazySimpleSerDe.class.getName(), SequenceFileInputFormat.class.getName(), HiveSequenceFileOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    JSON(JsonSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    TEXTFILE(LazySimpleSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    CSV(OpenCSVSerde.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE));

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;
    private final DataSize estimatedWriterSystemMemoryUsage;

    private HiveStorageFormat(String serde, String inputFormat, String outputFormat, DataSize estimatedWriterSystemMemoryUsage) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.estimatedWriterSystemMemoryUsage = Objects.requireNonNull(estimatedWriterSystemMemoryUsage, "estimatedWriterSystemMemoryUsage is null");
    }

    public String getSerDe() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public DataSize getEstimatedWriterSystemMemoryUsage() {
        return this.estimatedWriterSystemMemoryUsage;
    }

    public void validateColumns(List<HiveColumnHandle> handles) {
        if (this == AVRO) {
            for (HiveColumnHandle handle : handles) {
                if (handle.isPartitionKey()) continue;
                HiveStorageFormat.validateAvroType(handle.getHiveType().getTypeInfo(), handle.getName());
            }
        }
    }

    private static void validateAvroType(TypeInfo type, String columnName) {
        if (type.getCategory() == ObjectInspector.Category.MAP) {
            TypeInfo keyType = HiveStorageFormat.mapTypeInfo(type).getMapKeyTypeInfo();
            if (keyType.getCategory() != ObjectInspector.Category.PRIMITIVE || HiveStorageFormat.primitiveTypeInfo(keyType).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column %s has a non-varchar map key, which is not supported by Avro", columnName));
            }
        } else if (type.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory primitive = HiveStorageFormat.primitiveTypeInfo(type).getPrimitiveCategory();
            if (primitive == PrimitiveObjectInspector.PrimitiveCategory.BYTE) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column %s is tinyint, which is not supported by Avro. Use integer instead.", columnName));
            }
            if (primitive == PrimitiveObjectInspector.PrimitiveCategory.SHORT) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column %s is smallint, which is not supported by Avro. Use integer instead.", columnName));
            }
        }
    }

    private static PrimitiveTypeInfo primitiveTypeInfo(TypeInfo typeInfo) {
        return (PrimitiveTypeInfo)typeInfo;
    }

    private static MapTypeInfo mapTypeInfo(TypeInfo typeInfo) {
        return (MapTypeInfo)typeInfo;
    }
}

