/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<HiveColumnHandle> partitionColumns;
    private final Optional<List<HivePartition>> partitions;
    private final TupleDomain<HiveColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final Optional<List<List<String>>> analyzePartitionValues;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="compactEffectivePredicate") TupleDomain<HiveColumnHandle> compactEffectivePredicate, @JsonProperty(value="enforcedConstraint") TupleDomain<ColumnHandle> enforcedConstraint, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter, @JsonProperty(value="analyzePartitionValues") Optional<List<List<String>>> analyzePartitionValues) {
        this(schemaName, tableName, partitionColumns, Optional.empty(), compactEffectivePredicate, enforcedConstraint, bucketHandle, bucketFilter, analyzePartitionValues);
    }

    public HiveTableHandle(String schemaName, String tableName, List<HiveColumnHandle> partitionColumns, Optional<HiveBucketHandle> bucketHandle) {
        this(schemaName, tableName, partitionColumns, Optional.empty(), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty(), Optional.empty());
    }

    public HiveTableHandle(String schemaName, String tableName, List<HiveColumnHandle> partitionColumns, Optional<List<HivePartition>> partitions, TupleDomain<HiveColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> enforcedConstraint, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, Optional<List<List<String>>> analyzePartitionValues) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null").map(ImmutableList::copyOf);
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.analyzePartitionValues = Objects.requireNonNull(analyzePartitionValues, "analyzePartitionValues is null");
    }

    public HiveTableHandle withAnalyzePartitionValues(Optional<List<List<String>>> analyzePartitionValues) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.partitionColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, analyzePartitionValues);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        return this.enforcedConstraint;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    @JsonProperty
    public Optional<List<List<String>>> getAnalyzePartitionValues() {
        return this.analyzePartitionValues;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.schemaName).append(":").append(this.tableName);
        this.bucketHandle.ifPresent(bucket -> builder.append(" bucket=").append(bucket.getReadBucketCount()));
        return builder.toString();
    }
}

