/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.event.client.EventClient;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.HiveWriter;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.OrcFileWriterFactory;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.RecordFileWriter;
import io.prestosql.plugin.hive.SortingFileWriter;
import io.prestosql.plugin.hive.WriteCompletedEvent;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ReflectionUtil;

public class HiveWriterFactory {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final String schemaName;
    private final String tableName;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final Map<String, String> additionalTableParameters;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String queryId;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final PageSorter pageSorter;
    private final JobConf conf;
    private final Table table;
    private final DataSize sortBufferSize;
    private final int maxOpenSortFiles;
    private final boolean immutablePartitions;
    private final HiveSessionProperties.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final List<SortingColumn> sortedBy;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final Map<String, String> sessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final OrcFileWriterFactory orcFileWriterFactory;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, Map<String, String> additionalTableParameters, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String queryId, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, boolean immutablePartitions, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory) {
        Path writePath;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.additionalTableParameters = ImmutableMap.copyOf(Objects.requireNonNull(additionalTableParameters, "additionalTableParameters is null"));
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.sortBufferSize = Objects.requireNonNull(sortBufferSize, "sortBufferSize is null");
        this.maxOpenSortFiles = maxOpenSortFiles;
        this.immutablePartitions = immutablePartitions;
        this.insertExistingPartitionsBehavior = HiveSessionProperties.getInsertExistingPartitionsBehavior(session);
        if (immutablePartitions) {
            Preconditions.checkArgument((this.insertExistingPartitionsBehavior != HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND ? 1 : 0) != 0, (Object)"insertExistingPartitionsBehavior cannot be APPEND");
        }
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column : inputColumns) {
            HiveType hiveType = column.getHiveType();
            if (column.isPartitionKey()) {
                partitionColumnNames.add((Object)column.getName());
                partitionColumnTypes.add((Object)typeManager.getType(column.getTypeSignature()));
                continue;
            }
            dataColumns.add((Object)new DataColumn(column.getName(), hiveType));
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        if (isCreateTable) {
            this.table = null;
            LocationService.WriteInfo writeInfo = locationService.getQueryWriteInfo(locationHandle);
            Preconditions.checkArgument((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"CREATE TABLE write mode cannot be DIRECT_TO_TARGET_EXISTING_DIRECTORY");
            writePath = writeInfo.getWritePath();
        } else {
            Optional<Table> table = pageSinkMetadataProvider.getTable();
            if (!table.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table %s.%s was dropped during insert", schemaName, tableName));
            }
            this.table = table.get();
            writePath = locationService.getQueryWriteInfo(locationHandle).getWritePath();
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (Object)"bucketCount must be smaller than 100000");
        }
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.sessionProperties = (Map)hiveSessionProperties.getSessionProperties().stream().collect(ImmutableMap.toImmutableMap(PropertyMetadata::getName, entry -> session.getProperty(entry.getName(), entry.getJavaType()).toString()));
        Configuration conf = hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), writePath);
        this.conf = ConfigurationUtils.toJobConf(conf);
        try {
            hdfsEnvironment.getFileSystem(session.getUser(), writePath, conf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + writePath, (Throwable)e);
        }
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
    }

    public HiveWriter createWriter(Page partitionColumns, int position, OptionalInt bucketNumber) {
        StorageFormat outputStorageFormat;
        LocationService.WriteInfo writeInfo;
        Properties schema;
        PartitionUpdate.UpdateMode updateMode;
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0, (Object)"Bucket number provided by for table that is not bucketed");
        }
        String fileName = bucketNumber.isPresent() ? HiveWriterFactory.computeBucketedFileName(this.queryId, bucketNumber.getAsInt()) : this.queryId + "_" + UUID.randomUUID();
        List<String> partitionValues = HiveWriteUtils.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Partition> partition = Optional.empty();
        if (!partitionValues.isEmpty() && this.table != null) {
            partition = this.pageSinkMetadataProvider.getPartition(partitionValues);
        }
        if (!partition.isPresent()) {
            if (this.table == null) {
                updateMode = PartitionUpdate.UpdateMode.NEW;
                schema = new Properties();
                schema.setProperty("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.setProperty("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
                if (!partitionName.isPresent()) {
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                } else {
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    if (!writeInfo.getWriteMode().isWritePathSameAsTargetPath() && HiveWriteUtils.pathExists(new HdfsEnvironment.HdfsContext(this.session, this.schemaName, this.tableName), this.hdfsEnvironment, writeInfo.getTargetPath())) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, writeInfo.getTargetPath()));
                    }
                }
            } else {
                if (partitionName.isPresent()) {
                    updateMode = PartitionUpdate.UpdateMode.NEW;
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                } else {
                    switch (this.insertExistingPartitionsBehavior) {
                        case APPEND: {
                            Preconditions.checkState((!this.immutablePartitions ? 1 : 0) != 0);
                            updateMode = PartitionUpdate.UpdateMode.APPEND;
                            writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                            break;
                        }
                        case OVERWRITE: {
                            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
                            writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, true);
                            break;
                        }
                        case ERROR: {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_READ_ONLY, "Unpartitioned Hive tables are immutable");
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported insert existing table behavior: " + (Object)((Object)this.insertExistingPartitionsBehavior));
                        }
                    }
                }
                schema = MetastoreUtil.getHiveSchema(this.table);
            }
            outputStorageFormat = partitionName.isPresent() ? StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat) : StorageFormat.fromHiveStorageFormat(this.tableStorageFormat);
        } else if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND) {
            Preconditions.checkState((!this.immutablePartitions ? 1 : 0) != 0);
            updateMode = PartitionUpdate.UpdateMode.APPEND;
            List<Column> tableColumns = this.table.getDataColumns();
            List<Column> existingPartitionColumns = partition.get().getColumns();
            for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
                HiveType partitionType;
                HiveType tableType = tableColumns.get(i).getType();
                if (tableType.equals(partitionType = existingPartitionColumns.get(i).getType())) continue;
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("You are trying to write into an existing partition in a table. The table schema has changed since the creation of the partition. Inserting rows into such partition is not supported. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), this.tableName, tableType, partitionName, existingPartitionColumns.get(i).getName(), partitionType));
            }
            HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), partition.get());
            outputStorageFormat = partition.get().getStorage().getStorageFormat();
            schema = MetastoreUtil.getHiveSchema(partition.get(), this.table);
            writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
        } else if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE) {
            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
            outputStorageFormat = StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat);
            schema = MetastoreUtil.getHiveSchema(this.table);
            writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), (String)partitionName.get());
            Preconditions.checkState((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"Overwriting existing partition doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
        } else {
            if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.ERROR) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + (String)partitionName.get());
            }
            throw new IllegalArgumentException(String.format("Unsupported insert existing partitions behavior: %s", new Object[]{this.insertExistingPartitionsBehavior}));
        }
        schema.putAll(this.additionalTableParameters);
        this.validateSchema(partitionName, schema);
        String fileNameWithExtension = fileName + HiveWriterFactory.getFileExtension(this.conf, outputStorageFormat);
        Path path = new Path(writeInfo.getWritePath(), fileNameWithExtension);
        Object hiveFileWriter = null;
        for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
            Optional<HiveFileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.conf, this.session);
            if (!fileWriter.isPresent()) continue;
            hiveFileWriter = fileWriter.get();
            break;
        }
        if (hiveFileWriter == null) {
            hiveFileWriter = new RecordFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.partitionStorageFormat.getEstimatedWriterSystemMemoryUsage(), this.conf, this.typeManager, this.session);
        }
        String writerImplementation = hiveFileWriter.getClass().getName();
        Consumer<HiveWriter> onCommit = hiveWriter -> {
            Optional<Object> size;
            try {
                size = Optional.of(this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf).getFileStatus(path).getLen());
            }
            catch (IOException | RuntimeException e) {
                size = Optional.empty();
            }
            this.eventClient.post((Object[])new WriteCompletedEvent[]{new WriteCompletedEvent(this.session.getQueryId(), path.toString(), this.schemaName, this.tableName, partitionName.orElse(null), outputStorageFormat.getOutputFormat(), writerImplementation, this.nodeManager.getCurrentNode().getVersion(), this.nodeManager.getCurrentNode().getHost(), this.session.getIdentity().getPrincipal().map(Principal::getName).orElse(null), this.nodeManager.getEnvironment(), this.sessionProperties, size.orElse(null), hiveWriter.getRowCount())});
        };
        if (!this.sortedBy.isEmpty()) {
            FileSystem fileSystem;
            try {
                fileSystem = this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, (Throwable)e);
            }
            List types = (List)this.dataColumns.stream().map(column -> column.getHiveType().getType(this.typeManager)).collect(ImmutableList.toImmutableList());
            HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataColumns.size(); ++i) {
                columnIndexes.put(this.dataColumns.get(i).getName(), i);
            }
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (SortingColumn column2 : this.sortedBy) {
                Integer index = (Integer)columnIndexes.get(column2.getColumnName());
                if (index == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Sorting column '%s' does exist in table '%s.%s'", column2.getColumnName(), this.schemaName, this.tableName));
                }
                sortFields.add(index);
                sortOrders.add(column2.getOrder().getSortOrder());
            }
            hiveFileWriter = new SortingFileWriter(fileSystem, new Path(path.getParent(), ".tmp-sort." + path.getName()), (HiveFileWriter)hiveFileWriter, this.sortBufferSize, this.maxOpenSortFiles, types, sortFields, sortOrders, this.pageSorter, (fs, p) -> this.orcFileWriterFactory.createOrcDataSink(this.session, fs, p));
        }
        return new HiveWriter((HiveFileWriter)hiveFileWriter, partitionName, updateMode, fileNameWithExtension, writeInfo.getWritePath().toString(), writeInfo.getTargetPath().toString(), onCommit, this.hiveWriterStats);
    }

    private void validateSchema(Optional<String> partitionName, Properties schema) {
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<HiveType> fileColumnHiveTypes = HiveUtil.getColumnTypes(schema);
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet<String>(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s.%s does not have columns %s", schema, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName, this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType())) continue;
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName, columnName, fileColumnHiveType));
        }
    }

    public static String computeBucketedFileName(String queryId, int bucket) {
        String paddedBucket = Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
        return String.format("0%s_0_%s", paddedBucket, queryId);
    }

    public static String getFileExtension(JobConf conf, StorageFormat storageFormat) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT) || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return "";
        }
        String compressionCodecClass = conf.get("mapred.output.compression.codec");
        if (compressionCodecClass == null) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            Class<CompressionCodec> codecClass = conf.getClassByName(compressionCodecClass).asSubclass(CompressionCodec.class);
            return ((CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)conf)).getDefaultExtension();
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec not found: " + compressionCodecClass, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodecClass, (Throwable)e);
        }
    }

    private static class DataColumn {
        private final String name;
        private final HiveType hiveType;

        public DataColumn(String name, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }
}

