/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Splitter;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.RecordFileWriter;
import io.prestosql.spi.connector.ConnectorSession;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriteSupport;
import org.apache.hadoop.hive.ql.io.parquet.write.ParquetRecordWriterWrapper;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;

public final class ParquetRecordWriterUtil {
    private static final Field REAL_WRITER_FIELD;
    private static final Field INTERNAL_WRITER_FIELD;
    private static final Field FILE_WRITER_FIELD;

    private ParquetRecordWriterUtil() {
    }

    public static FileSinkOperator.RecordWriter createParquetWriter(final Path target, final JobConf conf, Properties properties, ConnectorSession session) throws IOException, ReflectiveOperationException {
        conf.setLong("parquet.block.size", HiveSessionProperties.getParquetWriterBlockSize(session).toBytes());
        conf.setLong("parquet.page.size", HiveSessionProperties.getParquetWriterPageSize(session).toBytes());
        final FileSinkOperator.RecordWriter recordWriter = ParquetRecordWriterUtil.createParquetWriter(target, conf, properties);
        Object realWriter = REAL_WRITER_FIELD.get(recordWriter);
        Object internalWriter = INTERNAL_WRITER_FIELD.get(realWriter);
        final ParquetFileWriter fileWriter = (ParquetFileWriter)FILE_WRITER_FIELD.get(internalWriter);
        return new RecordFileWriter.ExtendedRecordWriter(){
            private long length;

            @Override
            public long getWrittenBytes() {
                return this.length;
            }

            public void write(Writable value) throws IOException {
                recordWriter.write(value);
                this.length = fileWriter.getPos();
            }

            public void close(boolean abort) throws IOException {
                recordWriter.close(abort);
                if (!abort) {
                    this.length = target.getFileSystem((Configuration)conf).getFileStatus(target).getLen();
                }
            }
        };
    }

    private static FileSinkOperator.RecordWriter createParquetWriter(Path target, JobConf conf, Properties properties) throws IOException {
        if (conf.get("parquet.hive.schema") == null) {
            List columnNames = Splitter.on((char)',').splitToList((CharSequence)properties.getProperty("columns"));
            ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)properties.getProperty("columns.types"));
            MessageType schema = HiveSchemaConverter.convert((List)columnNames, (List)columnTypes);
            ParquetRecordWriterUtil.setParquetSchema((Configuration)conf, schema);
        }
        ParquetOutputFormat outputFormat = new ParquetOutputFormat((WriteSupport)new DataWritableWriteSupport());
        return new ParquetRecordWriterWrapper((OutputFormat)outputFormat, conf, target.toString(), (Progressable)Reporter.NULL, properties);
    }

    public static void setParquetSchema(Configuration conf, MessageType schema) {
        DataWritableWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
    }

    static {
        try {
            REAL_WRITER_FIELD = ParquetRecordWriterWrapper.class.getDeclaredField("realWriter");
            INTERNAL_WRITER_FIELD = ParquetRecordWriter.class.getDeclaredField("internalWriter");
            FILE_WRITER_FIELD = INTERNAL_WRITER_FIELD.getType().getDeclaredField("parquetFileWriter");
            REAL_WRITER_FIELD.setAccessible(true);
            INTERNAL_WRITER_FIELD.setAccessible(true);
            FILE_WRITER_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

