/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface HiveMetastore {
    public Optional<Database> getDatabase(String var1);

    public List<String> getAllDatabases();

    public Optional<Table> getTable(String var1, String var2);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public PartitionStatistics getTableStatistics(String var1, String var2);

    public Map<String, PartitionStatistics> getPartitionStatistics(String var1, String var2, Set<String> var3);

    public void updateTableStatistics(String var1, String var2, Function<PartitionStatistics, PartitionStatistics> var3);

    public void updatePartitionStatistics(String var1, String var2, String var3, Function<PartitionStatistics, PartitionStatistics> var4);

    public List<String> getAllTables(String var1);

    public List<String> getAllViews(String var1);

    public void createDatabase(Database var1);

    public void dropDatabase(String var1);

    public void renameDatabase(String var1, String var2);

    public void createTable(Table var1, PrincipalPrivileges var2);

    public void dropTable(String var1, String var2, boolean var3);

    public void replaceTable(String var1, String var2, Table var3, PrincipalPrivileges var4);

    public void renameTable(String var1, String var2, String var3, String var4);

    public void commentTable(String var1, String var2, Optional<String> var3);

    public void addColumn(String var1, String var2, String var3, HiveType var4, String var5);

    public void renameColumn(String var1, String var2, String var3, String var4);

    public void dropColumn(String var1, String var2, String var3);

    public Optional<Partition> getPartition(String var1, String var2, List<String> var3);

    public Optional<List<String>> getPartitionNames(String var1, String var2);

    public Optional<List<String>> getPartitionNamesByParts(String var1, String var2, List<String> var3);

    public Map<String, Optional<Partition>> getPartitionsByNames(String var1, String var2, List<String> var3);

    public void addPartitions(String var1, String var2, List<PartitionWithStatistics> var3);

    public void dropPartition(String var1, String var2, List<String> var3, boolean var4);

    public void alterPartition(String var1, String var2, PartitionWithStatistics var3);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public void revokeRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public Set<RoleGrant> listRoleGrants(HivePrincipal var1);

    public void grantTablePrivileges(String var1, String var2, HivePrincipal var3, Set<HivePrivilegeInfo> var4);

    public void revokeTablePrivileges(String var1, String var2, HivePrincipal var3, Set<HivePrivilegeInfo> var4);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, HivePrincipal var3);
}

