/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Partition {
    private final String databaseName;
    private final String tableName;
    private final List<String> values;
    private final Storage storage;
    private final List<Column> columns;
    private final Map<String, String> parameters;

    @JsonCreator
    public Partition(@JsonProperty(value="databaseName") String databaseName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="values") List<String> values, @JsonProperty(value="storage") Storage storage, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
        this.storage = Objects.requireNonNull(storage, "storage is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.databaseName, this.tableName);
    }

    @JsonProperty
    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty
    public Storage getStorage() {
        return this.storage;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).add("values", this.values).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.databaseName, partition.databaseName) && Objects.equals(this.tableName, partition.tableName) && Objects.equals(this.values, partition.values) && Objects.equals(this.storage, partition.storage) && Objects.equals(this.columns, partition.columns) && Objects.equals(this.parameters, partition.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName, this.values, this.storage, this.columns, this.parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Partition partition) {
        return new Builder(partition);
    }

    public static class Builder {
        private final Storage.Builder storageBuilder;
        private String databaseName;
        private String tableName;
        private List<String> values;
        private List<Column> columns;
        private Map<String, String> parameters = ImmutableMap.of();

        private Builder() {
            this.storageBuilder = Storage.builder();
        }

        private Builder(Partition partition) {
            this.storageBuilder = Storage.builder(partition.getStorage());
            this.databaseName = partition.getDatabaseName();
            this.tableName = partition.getTableName();
            this.values = partition.getValues();
            this.columns = partition.getColumns();
            this.parameters = partition.getParameters();
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setValues(List<String> values) {
            this.values = values;
            return this;
        }

        public Storage.Builder getStorageBuilder() {
            return this.storageBuilder;
        }

        public Builder withStorage(Consumer<Storage.Builder> consumer) {
            consumer.accept(this.storageBuilder);
            return this;
        }

        public Builder setColumns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Partition build() {
            return new Partition(this.databaseName, this.tableName, this.values, this.storageBuilder.build(), this.columns, this.parameters);
        }
    }
}

