/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UserTableKey {
    private final HivePrincipal principal;
    private final String database;
    private final String table;

    @JsonCreator
    public UserTableKey(@JsonProperty(value="principal") HivePrincipal principal, @JsonProperty(value="database") String database, @JsonProperty(value="table") String table) {
        this.principal = principal;
        this.database = Objects.requireNonNull(database, "database is null");
        this.table = Objects.requireNonNull(table, "table is null");
    }

    @JsonProperty
    public HivePrincipal getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    public boolean matches(String databaseName, String tableName) {
        return this.database.equals(databaseName) && this.table.equals(tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTableKey that = (UserTableKey)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals(this.table, that.table) && Objects.equals(this.database, that.database);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.table, this.database);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("principal", (Object)this.principal).add("table", (Object)this.table).add("database", (Object)this.database).toString();
    }
}

