/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.cache;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.hive.HiveCatalogName;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CachingHiveMetastoreModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        binder.bind(HiveMetastore.class).to(CachingHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
    }

    @Provides
    @Singleton
    @ForCachingHiveMetastore
    public Executor createCachingHiveMetastoreExecutor(HiveCatalogName catalogName, CachingHiveMetastoreConfig hiveConfig) {
        return new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metastore-" + catalogName + "-%s"))), hiveConfig.getMaxMetastoreRefreshThreads());
    }
}

