/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.PartitionError;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.SchemaAlreadyExistsException;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.glue.GlueExpressionUtil;
import io.prestosql.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.glue.converter.GlueInputConverter;
import io.prestosql.plugin.hive.metastore.glue.converter.GlueToPrestoConverter;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnNotFoundException;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;

public class GlueHiveMetastore
implements HiveMetastore {
    private static final Logger log = Logger.get(GlueHiveMetastore.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final String WILDCARD_EXPRESSION = "";
    private static final int BATCH_GET_PARTITION_MAX_PAGE_SIZE = 1000;
    private static final int BATCH_CREATE_PARTITION_MAX_PAGE_SIZE = 100;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final AWSGlueAsync glueClient;
    private final Optional<String> defaultDir;
    private final String catalogId;

    @Inject
    public GlueHiveMetastore(HdfsEnvironment hdfsEnvironment, GlueHiveMetastoreConfig glueConfig) {
        this(hdfsEnvironment, glueConfig, GlueHiveMetastore.createAsyncGlueClient(glueConfig));
    }

    public GlueHiveMetastore(HdfsEnvironment hdfsEnvironment, GlueHiveMetastoreConfig glueConfig, AWSGlueAsync glueClient) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = new HdfsEnvironment.HdfsContext(new ConnectorIdentity(DEFAULT_METASTORE_USER, Optional.empty(), Optional.empty()));
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.defaultDir = glueConfig.getDefaultWarehouseDir();
        this.catalogId = glueConfig.getCatalogId().orElse(null);
    }

    private static AWSGlueAsync createAsyncGlueClient(GlueHiveMetastoreConfig config) {
        Region currentRegion;
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getMaxGlueConnections());
        AWSGlueAsyncClientBuilder asyncGlueClientBuilder = (AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withClientConfiguration(clientConfig);
        if (config.getGlueRegion().isPresent()) {
            asyncGlueClientBuilder.setRegion(config.getGlueRegion().get());
        } else if (config.getPinGlueClientToCurrentRegion() && (currentRegion = Regions.getCurrentRegion()) != null) {
            asyncGlueClientBuilder.setRegion(currentRegion.getName());
        }
        asyncGlueClientBuilder.setCredentials(GlueHiveMetastore.getAwsCredentialsProvider(config));
        return (AWSGlueAsync)asyncGlueClientBuilder.build();
    }

    private static AWSCredentialsProvider getAwsCredentialsProvider(GlueHiveMetastoreConfig config) {
        if (config.getAwsAccessKey().isPresent() && config.getAwsSecretKey().isPresent()) {
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getAwsAccessKey().get(), config.getAwsSecretKey().get()));
        }
        if (config.getIamRole().isPresent()) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(config.getIamRole().get(), "presto-session").build();
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            GetDatabaseResult result = this.glueClient.getDatabase(new GetDatabaseRequest().withCatalogId(this.catalogId).withName(databaseName));
            return Optional.of(GlueToPrestoConverter.convertDatabase(result.getDatabase()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            ArrayList<String> databaseNames = new ArrayList<String>();
            String nextToken = null;
            do {
                GetDatabasesResult result = this.glueClient.getDatabases(new GetDatabasesRequest().withCatalogId(this.catalogId).withNextToken(nextToken));
                nextToken = result.getNextToken();
                result.getDatabaseList().forEach(database -> databaseNames.add(database.getName()));
            } while (nextToken != null);
            return databaseNames;
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            GetTableResult result = this.glueClient.getTable(new GetTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withName(tableName));
            return Optional.of(GlueToPrestoConverter.convertTable(result.getTable(), databaseName));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ImmutableSet.of();
    }

    private Table getTableOrElseThrow(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        return new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters()), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        this.getPartitionsByNames(databaseName, tableName, (List<String>)ImmutableList.copyOf(partitionNames)).forEach((partitionName, optionalPartition) -> {
            Partition partition = (Partition)optionalPartition.orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), HiveUtil.toPartitionValues(partitionName)));
            PartitionStatistics partitionStatistics = new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters()), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            result.put(partitionName, (Object)partitionStatistics);
        });
        return result.build();
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionStatistics currentStatistics = this.getTableStatistics(databaseName, tableName);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        if (!updatedStatistics.getColumnStatistics().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue metastore does not support column level statistics");
        }
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        try {
            TableInput tableInput = GlueInputConverter.convertTable(table);
            tableInput.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(table.getParameters(), updatedStatistics.getBasicStatistics()));
            this.glueClient.updateTable(new UpdateTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableInput(tableInput));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updatePartitionStatistics(String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionStatistics currentStatistics = this.getPartitionStatistics(databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
        if (currentStatistics == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partitionName);
        }
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        if (!updatedStatistics.getColumnStatistics().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue metastore does not support column level statistics");
        }
        List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
        Partition partition = this.getPartition(databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues));
        try {
            PartitionInput partitionInput = GlueInputConverter.convertPartition(partition);
            partitionInput.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(partition.getParameters(), updatedStatistics.getBasicStatistics()));
            this.glueClient.updatePartition(new UpdatePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionValueList(partition.getValues()).withPartitionInput(partitionInput));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            GetTablesResult result;
            ArrayList<String> tableNames = new ArrayList<String>();
            String nextToken = null;
            do {
                result = this.glueClient.getTables(new GetTablesRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withNextToken(nextToken));
                result.getTableList().forEach(table -> tableNames.add(table.getName()));
            } while ((nextToken = result.getNextToken()) != null);
            return tableNames;
        }
        catch (EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        try {
            GetTablesResult result;
            ArrayList<String> views = new ArrayList<String>();
            String nextToken = null;
            do {
                result = this.glueClient.getTables(new GetTablesRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withNextToken(nextToken));
                result.getTableList().stream().filter(table -> TableType.VIRTUAL_VIEW.name().equals(table.getTableType())).forEach(table -> views.add(table.getName()));
            } while ((nextToken = result.getNextToken()) != null);
            return views;
        }
        catch (EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createDatabase(Database database) {
        if (!database.getLocation().isPresent() && this.defaultDir.isPresent()) {
            String databaseLocation = new Path(this.defaultDir.get(), database.getDatabaseName()).toString();
            database = Database.builder(database).setLocation(Optional.of(databaseLocation)).build();
        }
        try {
            DatabaseInput databaseInput = GlueInputConverter.convertDatabase(database);
            this.glueClient.createDatabase(new CreateDatabaseRequest().withCatalogId(this.catalogId).withDatabaseInput(databaseInput));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (database.getLocation().isPresent()) {
            HiveWriteUtils.createDirectory(this.hdfsContext, this.hdfsEnvironment, new Path(database.getLocation().get()));
        }
    }

    @Override
    public void dropDatabase(String databaseName) {
        try {
            this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withCatalogId(this.catalogId).withName(databaseName));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            Database database = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
            DatabaseInput renamedDatabase = GlueInputConverter.convertDatabase(database).withName(newDatabaseName);
            this.glueClient.updateDatabase(new UpdateDatabaseRequest().withCatalogId(this.catalogId).withName(databaseName).withDatabaseInput(renamedDatabase));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput input = GlueInputConverter.convertTable(table);
            this.glueClient.createTable(new CreateTableRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableInput(input));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDatabaseName(), table.getTableName()));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(table.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        try {
            this.glueClient.deleteTable(new DeleteTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withName(tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String tableLocation = table.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)tableLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(tableLocation), true);
        }
    }

    private static boolean isManagedTable(Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    private static void deleteDir(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path, boolean recursive) {
        try {
            hdfsEnvironment.getFileSystem(context, path).delete(path, recursive);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete path: " + path.toString());
        }
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput newTableInput = GlueInputConverter.convertTable(newTable);
            this.glueClient.updateTable(new UpdateTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableInput(newTableInput));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not yet supported by Glue service");
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table comment is not yet supported by Glue service");
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Table oldTable = this.getTableOrElseThrow(databaseName, tableName);
        Table newTable = Table.builder(oldTable).addDataColumn(new Column(columnName, columnType, Optional.ofNullable(columnComment))).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Table oldTable = this.getTableOrElseThrow(databaseName, tableName);
        if (oldTable.getPartitionColumns().stream().anyMatch(c -> c.getName().equals(oldColumnName))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column column : oldTable.getDataColumns()) {
            if (column.getName().equals(oldColumnName)) {
                newDataColumns.add((Object)new Column(newColumnName, column.getType(), column.getComment()));
                continue;
            }
            newDataColumns.add((Object)column);
        }
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        Table oldTable = this.getTableOrElseThrow(databaseName, tableName);
        if (!oldTable.getColumn(columnName).isPresent()) {
            SchemaTableName name = new SchemaTableName(databaseName, tableName);
            throw new ColumnNotFoundException(name, columnName);
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        oldTable.getDataColumns().stream().filter(fieldSchema -> !fieldSchema.getName().equals(columnName)).forEach(arg_0 -> ((ImmutableList.Builder)newDataColumns).add(arg_0));
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        try {
            GetPartitionResult result = this.glueClient.getPartition(new GetPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionValues(partitionValues));
            return Optional.of(GlueToPrestoConverter.convertPartition(result.getPartition()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        List<Partition> partitions = this.getPartitions(databaseName, tableName, WILDCARD_EXPRESSION);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(table.getPartitionColumns(), partitions));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        String expression = GlueExpressionUtil.buildGlueExpression(table.getPartitionColumns(), parts);
        List<Partition> partitions = this.getPartitions(databaseName, tableName, expression);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(table.getPartitionColumns(), partitions));
    }

    private List<Partition> getPartitions(String databaseName, String tableName, String expression) {
        try {
            GetPartitionsResult result;
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            String nextToken = null;
            do {
                result = this.glueClient.getPartitions(new GetPartitionsRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withExpression(expression).withNextToken(nextToken));
                result.getPartitions().forEach(partition -> partitions.add(GlueToPrestoConverter.convertPartition(partition)));
            } while ((nextToken = result.getNextToken()) != null);
            return partitions;
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private static List<String> buildPartitionNames(List<Column> partitionColumns, List<Partition> partitions) {
        return partitions.stream().map(partition -> MetastoreUtil.makePartName(partitionColumns, partition.getValues())).collect(Collectors.toList());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        List<Partition> partitions = this.batchGetPartition(databaseName, tableName, partitionNames);
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = partitions.stream().collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put(entry.getKey(), Optional.ofNullable(partition));
        }
        return resultBuilder.build();
    }

    private List<Partition> batchGetPartition(String databaseName, String tableName, List<String> partitionNames) {
        try {
            List partitionValueLists = partitionNames.stream().map(partitionName -> new PartitionValueList().withValues(HiveUtil.toPartitionValues(partitionName))).collect(Collectors.toList());
            List batchedPartitionValueLists = Lists.partition(partitionValueLists, (int)1000);
            ArrayList<Future> batchGetPartitionFutures = new ArrayList<Future>();
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (List partitions : batchedPartitionValueLists) {
                batchGetPartitionFutures.add(this.glueClient.batchGetPartitionAsync(new BatchGetPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionsToGet((Collection)partitions)));
            }
            for (Future future : batchGetPartitionFutures) {
                ((BatchGetPartitionResult)future.get()).getPartitions().forEach(partition -> result.add(GlueToPrestoConverter.convertPartition(partition)));
            }
            return result;
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            List batchedPartitions = Lists.partition(partitions, (int)100);
            ArrayList<Future> futures = new ArrayList<Future>();
            for (List partitionBatch : batchedPartitions) {
                List partitionInputs = partitionBatch.stream().map(GlueInputConverter::convertPartition).collect(Collectors.toList());
                futures.add(this.glueClient.batchCreatePartitionAsync(new BatchCreatePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionInputList(partitionInputs)));
            }
            for (Future future : futures) {
                BatchCreatePartitionResult result = (BatchCreatePartitionResult)future.get();
                GlueHiveMetastore.propagatePartitionErrorToPrestoException(databaseName, tableName, result.getErrors());
            }
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    private static void propagatePartitionErrorToPrestoException(String databaseName, String tableName, List<PartitionError> partitionErrors) {
        if (partitionErrors != null && !partitionErrors.isEmpty()) {
            String glueExceptionCode;
            ErrorDetail errorDetail = partitionErrors.get(0).getErrorDetail();
            switch (glueExceptionCode = errorDetail.getErrorCode()) {
                case "AlreadyExistsException": {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, errorDetail.getErrorMessage());
                }
                case "EntityNotFoundException": {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), errorDetail.getErrorMessage());
                }
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, errorDetail.getErrorCode() + ": " + errorDetail.getErrorMessage());
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        Partition partition = this.getPartition(databaseName, tableName, parts).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts));
        try {
            this.glueClient.deletePartition(new DeletePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionValues(parts));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String partLocation = partition.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)partLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(partLocation), true);
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            PartitionInput newPartition = GlueInputConverter.convertPartition(partition);
            this.glueClient.updatePartition(new UpdatePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionInput(newPartition).withPartitionValueList(partition.getPartition().getValues()));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getPartition().getValues());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createRole is not supported by Glue");
    }

    @Override
    public void dropRole(String role) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropRole is not supported by Glue");
    }

    @Override
    public Set<String> listRoles() {
        return ImmutableSet.of((Object)PUBLIC_ROLE_NAME);
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, HivePrincipal grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantRoles is not supported by Glue");
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, HivePrincipal grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeRoles is not supported by Glue");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        if (principal.getType() == PrincipalType.USER) {
            return ImmutableSet.of((Object)new RoleGrant(principal.toPrestoPrincipal(), PUBLIC_ROLE_NAME, false));
        }
        return ImmutableSet.of();
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges is not supported by Glue");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges is not supported by Glue");
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, HivePrincipal principal) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listTablePrivileges is not supported by Glue");
    }
}

