/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.thrift.TException;

public class StaticMetastoreLocator
implements MetastoreLocator {
    private final List<HostAndPort> addresses;
    private final ThriftMetastoreClientFactory clientFactory;
    private final String metastoreUsername;

    @Inject
    public StaticMetastoreLocator(StaticMetastoreConfig config, ThriftMetastoreClientFactory clientFactory) {
        this(config.getMetastoreUris(), config.getMetastoreUsername(), clientFactory);
    }

    public StaticMetastoreLocator(List<URI> metastoreUris, String metastoreUsername, ThriftMetastoreClientFactory clientFactory) {
        Objects.requireNonNull(metastoreUris, "metastoreUris is null");
        Preconditions.checkArgument((!metastoreUris.isEmpty() ? 1 : 0) != 0, (Object)"metastoreUris must specify at least one URI");
        this.addresses = metastoreUris.stream().map(StaticMetastoreLocator::checkMetastoreUri).map(uri -> HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort())).collect(Collectors.toList());
        this.metastoreUsername = metastoreUsername;
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
    }

    @Override
    public ThriftMetastoreClient createMetastoreClient() throws TException {
        ArrayList<HostAndPort> metastores = new ArrayList<HostAndPort>(this.addresses);
        Collections.shuffle(metastores.subList(1, metastores.size()));
        TException lastException = null;
        for (HostAndPort metastore : metastores) {
            try {
                ThriftMetastoreClient client = this.clientFactory.create(metastore);
                if (!Strings.isNullOrEmpty((String)this.metastoreUsername)) {
                    client.setUGI(this.metastoreUsername);
                }
                return client;
            }
            catch (TException e) {
                lastException = e;
            }
        }
        throw new TException("Failed connecting to Hive metastore: " + this.addresses, (Throwable)lastException);
    }

    private static URI checkMetastoreUri(URI uri) {
        Objects.requireNonNull(uri, "metastoreUri is null");
        String scheme = uri.getScheme();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (String)"metastoreUri scheme is missing: %s", (Object)uri);
        Preconditions.checkArgument((boolean)scheme.equals("thrift"), (String)"metastoreUri scheme must be thrift: %s", (Object)uri);
        Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"metastoreUri host is missing: %s", (Object)uri);
        Preconditions.checkArgument((uri.getPort() != -1 ? 1 : 0) != 0, (String)"metastoreUri port is missing: %s", (Object)uri);
        return uri;
    }
}

