/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveViewNotSupportedException;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.SchemaAlreadyExistsException;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.plugin.hive.util.RetryDriver;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftHiveMetastore
implements ThriftMetastore {
    private final ThriftMetastoreStats stats = new ThriftMetastoreStats();
    private final MetastoreLocator clientProvider;
    private final double backoffScaleFactor;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final Duration maxRetryTime;
    private final int maxRetries;
    private volatile boolean metastoreKnownToSupportTableParamEqualsPredicate;
    private volatile boolean metastoreKnownToSupportTableParamLikePredicate;

    @Inject
    public ThriftHiveMetastore(MetastoreLocator metastoreLocator, ThriftHiveMetastoreConfig thriftConfig) {
        this.clientProvider = Objects.requireNonNull(metastoreLocator, "metastoreLocator is null");
        this.backoffScaleFactor = thriftConfig.getBackoffScaleFactor();
        this.minBackoffDelay = thriftConfig.getMinBackoffDelay();
        this.maxBackoffDelay = thriftConfig.getMaxBackoffDelay();
        this.maxRetryTime = thriftConfig.getMaxRetryTime();
        this.maxRetries = thriftConfig.getMaxRetries();
    }

    @Managed
    @Flatten
    public ThriftMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getAllDatabases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<Database> optional = Optional.of(client.getDatabase(databaseName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getAllTables(databaseName);
                    return list;
                }
            });
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<org.apache.hadoop.hive.metastore.api.Table> getTable(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    org.apache.hadoop.hive.metastore.api.Table table = client.getTable(databaseName, tableName);
                    if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) && !ThriftHiveMetastore.isPrestoView(table)) {
                        throw new HiveViewNotSupportedException(new SchemaTableName(databaseName, tableName));
                    }
                    Optional<org.apache.hadoop.hive.metastore.api.Table> optional = Optional.of(table);
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics(type);
    }

    private static boolean isPrestoView(org.apache.hadoop.hive.metastore.api.Table table) {
        return "true".equals(table.getParameters().get("presto_view"));
    }

    @Override
    public PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        HiveBasicStatistics basicStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
        Map<String, HiveColumnStatistics> columnStatistics = this.getTableColumnStatistics(databaseName, tableName, dataColumns, basicStatistics.getRowCount());
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, List<String> columns, OptionalLong rowCount) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTableColumnStatistics", this.stats.getGetTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Map<String, HiveColumnStatistics> map = this.groupStatisticsByColumn(client.getTableColumnStatistics(databaseName, tableName, columns), rowCount);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        List partitionColumns = (List)table.getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        Map partitionBasicStatistics = (Map)this.getPartitionsByNames(databaseName, tableName, (List<String>)ImmutableList.copyOf(partitionNames)).stream().collect(ImmutableMap.toImmutableMap(partition -> FileUtils.makePartName((List)partitionColumns, (List)partition.getValues()), partition -> ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters())));
        Map partitionRowCounts = (Map)partitionBasicStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((HiveBasicStatistics)entry.getValue()).getRowCount()));
        Map<String, Map<String, HiveColumnStatistics>> partitionColumnStatistics = this.getPartitionColumnStatistics(databaseName, tableName, partitionNames, dataColumns, partitionRowCounts);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionNames) {
            HiveBasicStatistics basicStatistics = partitionBasicStatistics.getOrDefault(partitionName, HiveBasicStatistics.createEmptyStatistics());
            Map<String, HiveColumnStatistics> columnStatistics = partitionColumnStatistics.getOrDefault(partitionName, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            result.put((Object)partitionName, (Object)new PartitionStatistics(basicStatistics, columnStatistics));
        }
        return result.build();
    }

    @Override
    public Optional<List<FieldSchema>> getFields(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(MetaException.class, UnknownTableException.class, UnknownDBException.class).stopOnIllegalExceptions().run("getFields", this.stats.getGetFields().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<ImmutableList> optional = Optional.of(ImmutableList.copyOf(client.getFields(databaseName, tableName)));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames, Map<String, OptionalLong> partitionRowCounts) {
        return (Map)this.getMetastorePartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames).entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((List)entry.getValue(), partitionRowCounts.getOrDefault(entry.getKey(), OptionalLong.empty()))));
    }

    private Map<String, List<ColumnStatisticsObj>> getMetastorePartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getPartitionColumnStatistics", this.stats.getGetPartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Map<String, List<ColumnStatisticsObj>> map = client.getPartitionColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)partitionNames), columnNames);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsObj> statistics, OptionalLong rowCount) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsObj::getColName, statisticsObj -> ThriftMetastoreUtil.fromMetastoreApiColumnStatistics(statisticsObj, rowCount)));
    }

    @Override
    public synchronized void updateTableStatistics(String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionStatistics currentStatistics = this.getTableStatistics(databaseName, tableName);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        org.apache.hadoop.hive.metastore.api.Table originalTable = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        org.apache.hadoop.hive.metastore.api.Table modifiedTable = originalTable.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedTable.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedTable.getParameters(), basicStatistics));
        this.alterTable(databaseName, tableName, modifiedTable);
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(modifiedTable);
        OptionalLong rowCount = basicStatistics.getRowCount();
        List metastoreColumnStatistics = (List)updatedStatistics.getColumnStatistics().entrySet().stream().map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), table.getColumn((String)entry.getKey()).get().getType(), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setTableColumnStatistics(databaseName, tableName, metastoreColumnStatistics);
        }
        Sets.SetView removedColumnStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedColumnStatistics.forEach(column -> this.deleteTableColumnStatistics(databaseName, tableName, (String)column));
    }

    private void setTableColumnStatistics(String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setTableColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.setTableColumnStatistics(databaseName, tableName, statistics);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deleteTableColumnStatistics(String databaseName, String tableName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deleteTableColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.deleteTableColumnStatistics(databaseName, tableName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public synchronized void updatePartitionStatistics(String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionStatistics currentStatistics = Objects.requireNonNull(this.getPartitionStatistics(databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName), "getPartitionStatistics() returned null");
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        List<Partition> partitions = this.getPartitionsByNames(databaseName, tableName, (List<String>)ImmutableList.of((Object)partitionName));
        if (partitions.size() != 1) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Metastore returned multiple partitions for name: " + partitionName);
        }
        Partition originalPartition = (Partition)Iterables.getOnlyElement(partitions);
        Partition modifiedPartition = originalPartition.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedPartition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedPartition.getParameters(), basicStatistics));
        this.alterPartitionWithoutStatistics(databaseName, tableName, modifiedPartition);
        Map columns = (Map)modifiedPartition.getSd().getCols().stream().collect(ImmutableMap.toImmutableMap(FieldSchema::getName, schema -> HiveType.valueOf(schema.getType())));
        this.setPartitionColumnStatistics(databaseName, tableName, partitionName, columns, updatedStatistics.getColumnStatistics(), basicStatistics.getRowCount());
        Sets.SetView removedStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedStatistics.forEach(column -> this.deletePartitionColumnStatistics(databaseName, tableName, partitionName, (String)column));
    }

    private void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, Map<String, HiveType> columns, Map<String, HiveColumnStatistics> columnStatistics, OptionalLong rowCount) {
        List metastoreColumnStatistics = (List)columnStatistics.entrySet().stream().filter(entry -> columns.containsKey(entry.getKey())).map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), (HiveType)columns.get(entry.getKey()), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setPartitionColumnStatistics(databaseName, tableName, partitionName, metastoreColumnStatistics);
        }
    }

    private void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setPartitionColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.setPartitionColumnStatistics(databaseName, tableName, partitionName, statistics);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deletePartitionColumnStatistics(String databaseName, String tableName, String partitionName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deletePartitionColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("createRole", this.stats.getCreateRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createRole(role, grantor);
                    Object var5_5 = null;
                    return var5_5;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("dropRole", this.stats.getDropRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropRole(role);
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<String> listRoles() {
        try {
            return (Set)this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoles", this.stats.getListRoles().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    ImmutableSet immutableSet = ImmutableSet.copyOf(client.getRoleNames());
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.grantRole(role, grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), grantor.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantor.getType()), withAdminOption);
            }
        }
    }

    private void grantRole(String role, String granteeName, PrincipalType granteeType, String grantorName, PrincipalType grantorType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("grantRole", this.stats.getGrantRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.grantRole(role, granteeName, granteeType, grantorName, grantorType, grantOption);
                    Object var9_9 = null;
                    return var9_9;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.revokeRole(role, grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), adminOptionFor);
            }
        }
    }

    private void revokeRole(String role, String granteeName, PrincipalType granteeType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("revokeRole", this.stats.getRevokeRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.revokeRole(role, granteeName, granteeType, grantOption);
                    Object var7_7 = null;
                    return var7_7;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        try {
            return this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoleGrants", this.stats.getListRoleGrants().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Set<RoleGrant> set = ThriftMetastoreUtil.fromRolePrincipalGrants(client.listRoleGrants(principal.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(principal.getType())));
                    return set;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> this.getPrestoViews(databaseName)));
        }
        catch (UnknownDBException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getPrestoViews(String databaseName) throws TException {
        String filterWithEquals = "hive_filter_field_params__presto_view = \"true\"";
        String filterWithLike = "hive_filter_field_params__presto_view LIKE \"true\"";
        if (this.metastoreKnownToSupportTableParamEqualsPredicate) {
            try (ThriftMetastoreClient client = this.createMetastoreClient();){
                List<String> list = client.getTableNamesByFilter(databaseName, filterWithEquals);
                return list;
            }
        }
        if (this.metastoreKnownToSupportTableParamLikePredicate) {
            try (ThriftMetastoreClient client = this.createMetastoreClient();){
                List<String> list = client.getTableNamesByFilter(databaseName, filterWithLike);
                return list;
            }
        }
        try (ThriftMetastoreClient client = this.createMetastoreClient();){
            List<String> views = client.getTableNamesByFilter(databaseName, filterWithEquals);
            this.metastoreKnownToSupportTableParamEqualsPredicate = true;
            List<String> list = views;
            return list;
        }
        catch (RuntimeException | TException firstException) {
            try (ThriftMetastoreClient client2 = this.createMetastoreClient();){
                List<String> views = client2.getTableNamesByFilter(databaseName, filterWithLike);
                this.metastoreKnownToSupportTableParamLikePredicate = true;
                List<String> list = views;
                return list;
            }
            catch (RuntimeException | TException secondException) {
                if (firstException == secondException) throw firstException;
                firstException.addSuppressed(secondException);
                throw firstException;
            }
        }
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class).stopOnIllegalExceptions().run("createDatabase", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createDatabase(database);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropDatabase(String databaseName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidOperationException.class).stopOnIllegalExceptions().run("dropDatabase", this.stats.getDropDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropDatabase(databaseName, false, false);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterDatabase(String databaseName, Database database) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterDatabase", this.stats.getAlterDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterDatabase(databaseName, database);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createTable(org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createTable(table);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropTable(databaseName, tableName, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterTable(String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTable", this.stats.getAlterTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.getTable(databaseName, tableName);
                    if (!source.isPresent()) {
                        throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                    }
                    client.alterTable(databaseName, tableName, table);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNames(databaseName, tableName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNamesFiltered(databaseName, tableName, parts));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        List partitions = (List)partitionsWithStatistics.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(ImmutableList.toImmutableList());
        this.addPartitionsWithoutStatistics(databaseName, tableName, partitions);
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            this.storePartitionColumnStatistics(databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        }
    }

    private void addPartitionsWithoutStatistics(String databaseName, String tableName, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class, PrestoException.class).stopOnIllegalExceptions().run("addPartitions", this.stats.getAddPartitions().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    int partitionsAdded = client.addPartitions(partitions);
                    if (partitionsAdded != partitions.size()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Hive metastore only added %s of %s partitions", partitionsAdded, partitions.size()));
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
            }));
        }
        catch (AlreadyExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("One or more partitions already exist for table '%s.%s'", databaseName, tableName), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("dropPartition", this.stats.getDropPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropPartition(databaseName, tableName, parts, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        this.alterPartitionWithoutStatistics(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics));
        this.storePartitionColumnStatistics(databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        this.dropExtraColumnStatisticsAfterAlterPartition(databaseName, tableName, partitionWithStatistics);
    }

    private void alterPartitionWithoutStatistics(String databaseName, String tableName, Partition partition) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterPartition(databaseName, tableName, partition);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void storePartitionColumnStatistics(String databaseName, String tableName, String partitionName, PartitionWithStatistics partitionWithStatistics) {
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        Map<String, HiveColumnStatistics> columnStatistics = statistics.getColumnStatistics();
        if (columnStatistics.isEmpty()) {
            return;
        }
        Map columnTypes = (Map)partitionWithStatistics.getPartition().getColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType));
        this.setPartitionColumnStatistics(databaseName, tableName, partitionName, columnTypes, columnStatistics, statistics.getBasicStatistics().getRowCount());
    }

    private void dropExtraColumnStatisticsAfterAlterPartition(String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        List dataColumns = (List)partitionWithStatistics.getPartition().getColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HashSet columnsWithMissingStatistics = new HashSet(dataColumns);
        columnsWithMissingStatistics.removeAll(partitionWithStatistics.getStatistics().getColumnStatistics().keySet());
        if (columnsWithMissingStatistics.isEmpty()) {
            return;
        }
        String partitionName = partitionWithStatistics.getPartitionName();
        List<ColumnStatisticsObj> statisticsToBeRemoved = this.getMetastorePartitionColumnStatistics(databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName), (List<String>)ImmutableList.copyOf(columnsWithMissingStatistics)).getOrDefault(partitionName, (List<ColumnStatisticsObj>)ImmutableList.of());
        for (ColumnStatisticsObj statistics : statisticsToBeRemoved) {
            this.deletePartitionColumnStatistics(databaseName, tableName, partitionName, statistics.getColName());
        }
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartition", this.stats.getGetPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<Partition> optional = Optional.of(client.getPartition(databaseName, tableName, partitionValues));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<Partition> list = client.getPartitionsByNames(databaseName, tableName, partitionNames);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> requestedPrivileges = privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("grantTablePrivileges", this.stats.getGrantTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Set<HivePrivilegeInfo> existingPrivileges = this.listTablePrivileges(databaseName, tableName, grantee);
                    HashSet<PrivilegeGrantInfo> privilegesToGrant = new HashSet<PrivilegeGrantInfo>(requestedPrivileges);
                    Iterator iterator = privilegesToGrant.iterator();
                    while (iterator.hasNext()) {
                        HivePrivilegeInfo requestedPrivilege = (HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege((PrivilegeGrantInfo)iterator.next(), Optional.empty()));
                        for (HivePrivilegeInfo existingPrivilege : existingPrivileges) {
                            if (requestedPrivilege.isContainedIn(existingPrivilege)) {
                                iterator.remove();
                                continue;
                            }
                            if (!existingPrivilege.isContainedIn(requestedPrivilege)) continue;
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Granting %s WITH GRANT OPTION is not supported while %s possesses %s", requestedPrivilege.getHivePrivilege().name(), grantee, requestedPrivilege.getHivePrivilege().name()));
                        }
                    }
                    if (privilegesToGrant.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.grantPrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToGrant));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> requestedPrivileges = privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("revokeTablePrivileges", this.stats.getRevokeTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Set existingHivePrivileges = this.listTablePrivileges(databaseName, tableName, grantee).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(Collectors.toSet());
                    Set<PrivilegeGrantInfo> privilegesToRevoke = requestedPrivileges.stream().filter(privilegeGrantInfo -> existingHivePrivileges.contains((Object)((HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege(privilegeGrantInfo, Optional.empty()))).getHivePrivilege())).collect(Collectors.toSet());
                    if (privilegesToRevoke.isEmpty()) {
                        Object var9_11 = null;
                        return var9_11;
                    }
                    metastoreClient.revokePrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToRevoke));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, HivePrincipal principal) {
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("listTablePrivileges", this.stats.getListTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<HiveObjectPrivilege> hiveObjectPrivilegeList;
                    org.apache.hadoop.hive.metastore.api.Table table = client.getTable(databaseName, tableName);
                    ImmutableSet.Builder privileges = ImmutableSet.builder();
                    if (principal == null) {
                        hiveObjectPrivilegeList = client.listPrivileges(null, null, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    } else {
                        if (principal.getType() == io.prestosql.spi.security.PrincipalType.USER && table.getOwner().equals(principal.getName())) {
                            privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, principal, principal));
                        }
                        hiveObjectPrivilegeList = client.listPrivileges(principal.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(principal.getType()), new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    }
                    for (HiveObjectPrivilege hiveObjectPrivilege : hiveObjectPrivilegeList) {
                        HivePrincipal grantee = new HivePrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(hiveObjectPrivilege.getPrincipalType()), hiveObjectPrivilege.getPrincipalName());
                        privileges.addAll(ThriftMetastoreUtil.parsePrivilege(hiveObjectPrivilege.getGrantInfo(), Optional.of(grantee)));
                    }
                    ImmutableSet immutableSet = privileges.build();
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private PrivilegeBag buildPrivilegeBag(String databaseName, String tableName, HivePrincipal grantee, Set<PrivilegeGrantInfo> privilegeGrantInfos) {
        ImmutableList.Builder privilegeBagBuilder = ImmutableList.builder();
        for (PrivilegeGrantInfo privilegeGrantInfo : privilegeGrantInfos) {
            privilegeBagBuilder.add((Object)new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null), grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), privilegeGrantInfo));
        }
        return new PrivilegeBag((List)privilegeBagBuilder.build());
    }

    private boolean containsAllPrivilege(Set<PrivilegeGrantInfo> requestedPrivileges) {
        return requestedPrivileges.stream().anyMatch(privilege -> privilege.getPrivilege().equalsIgnoreCase("all"));
    }

    private ThriftMetastoreClient createMetastoreClient() throws TException {
        return this.clientProvider.createMetastoreClient();
    }

    private RetryDriver retry() {
        return RetryDriver.retry().exponentialBackoff(this.minBackoffDelay, this.maxBackoffDelay, this.maxRetryTime, this.backoffScaleFactor).maxAttempts(this.maxRetries + 1).stopOn(PrestoException.class);
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

