/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public interface ThriftMetastore {
    public void createDatabase(Database var1);

    public void dropDatabase(String var1);

    public void alterDatabase(String var1, Database var2);

    public void createTable(Table var1);

    public void dropTable(String var1, String var2, boolean var3);

    public void alterTable(String var1, String var2, Table var3);

    public List<String> getAllDatabases();

    public List<String> getAllTables(String var1);

    public List<String> getAllViews(String var1);

    public Optional<Database> getDatabase(String var1);

    public void addPartitions(String var1, String var2, List<PartitionWithStatistics> var3);

    public void dropPartition(String var1, String var2, List<String> var3, boolean var4);

    public void alterPartition(String var1, String var2, PartitionWithStatistics var3);

    public Optional<List<String>> getPartitionNames(String var1, String var2);

    public Optional<List<String>> getPartitionNamesByParts(String var1, String var2, List<String> var3);

    public Optional<Partition> getPartition(String var1, String var2, List<String> var3);

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3);

    public Optional<Table> getTable(String var1, String var2);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public PartitionStatistics getTableStatistics(String var1, String var2);

    public Map<String, PartitionStatistics> getPartitionStatistics(String var1, String var2, Set<String> var3);

    public void updateTableStatistics(String var1, String var2, Function<PartitionStatistics, PartitionStatistics> var3);

    public void updatePartitionStatistics(String var1, String var2, String var3, Function<PartitionStatistics, PartitionStatistics> var4);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public void revokeRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public Set<RoleGrant> listRoleGrants(HivePrincipal var1);

    public void grantTablePrivileges(String var1, String var2, HivePrincipal var3, Set<HivePrivilegeInfo> var4);

    public void revokeTablePrivileges(String var1, String var2, HivePrincipal var3, Set<HivePrivilegeInfo> var4);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, HivePrincipal var3);

    default public Optional<List<FieldSchema>> getFields(String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        if (table.get().getSd() == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return Optional.of(table.get().getSd().getCols());
    }
}

