/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.prestosql.plugin.hive.authentication.HiveMetastoreAuthentication;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class Transport {
    public static TTransport create(HostAndPort address, Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, int timeoutMillis, HiveMetastoreAuthentication authentication) throws TTransportException {
        Objects.requireNonNull(address, "address is null");
        try {
            TTransport rawTransport = Transport.createRaw(address, sslContext, socksProxy, timeoutMillis);
            TTransport authenticatedTransport = authentication.authenticate(rawTransport, address.getHost());
            if (!authenticatedTransport.isOpen()) {
                authenticatedTransport.open();
            }
            return new TTransportWrapper(authenticatedTransport, address);
        }
        catch (TTransportException e) {
            throw Transport.rewriteException(e, address);
        }
    }

    private Transport() {
    }

    private static TTransport createRaw(HostAndPort address, Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, int timeoutMillis) throws TTransportException {
        Proxy proxy = socksProxy.map(socksAddress -> new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(socksAddress.getHost(), socksAddress.getPort()))).orElse(Proxy.NO_PROXY);
        Socket socket = new Socket(proxy);
        try {
            socket.connect(new InetSocketAddress(address.getHost(), address.getPort()), timeoutMillis);
            socket.setSoTimeout(timeoutMillis);
            if (sslContext.isPresent()) {
                HostAndPort sslConnectAddress = socksProxy.orElse(address);
                socket = sslContext.get().getSocketFactory().createSocket(socket, sslConnectAddress.getHost(), sslConnectAddress.getPort(), true);
            }
            return new TSocket(socket);
        }
        catch (Throwable t) {
            try {
                socket.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw new TTransportException(t);
        }
    }

    private static TTransportException rewriteException(TTransportException e, HostAndPort address) {
        String message = e.getMessage() != null ? String.format("%s: %s", address, e.getMessage()) : address.toString();
        return new TTransportException(e.getType(), message, (Throwable)e);
    }

    private static class TTransportWrapper
    extends TTransport {
        private final TTransport transport;
        private final HostAndPort address;

        TTransportWrapper(TTransport transport, HostAndPort address) {
            this.transport = Objects.requireNonNull(transport, "transport is null");
            this.address = Objects.requireNonNull(address, "address is null");
        }

        public boolean isOpen() {
            return this.transport.isOpen();
        }

        public boolean peek() {
            return this.transport.peek();
        }

        public byte[] getBuffer() {
            return this.transport.getBuffer();
        }

        public int getBufferPosition() {
            return this.transport.getBufferPosition();
        }

        public int getBytesRemainingInBuffer() {
            return this.transport.getBytesRemainingInBuffer();
        }

        public void consumeBuffer(int len) {
            this.transport.consumeBuffer(len);
        }

        public void close() {
            this.transport.close();
        }

        public void open() throws TTransportException {
            try {
                this.transport.open();
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        public int readAll(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.readAll(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        public int read(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.read(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        public void write(byte[] bytes) throws TTransportException {
            try {
                this.transport.write(bytes);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        public void write(byte[] bytes, int off, int len) throws TTransportException {
            try {
                this.transport.write(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }

        public void flush() throws TTransportException {
            try {
                this.transport.flush();
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.address);
            }
        }
    }
}

