/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.s3.ConfigurationInitializer;
import io.prestosql.plugin.hive.s3.HiveS3Config;
import io.prestosql.plugin.hive.s3.PrestoS3ConfigurationInitializer;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystem;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemStats;
import io.prestosql.plugin.hive.s3.S3FileSystemType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.weakref.jmx.guice.ExportBinder;

public class HiveS3Module
extends AbstractConfigurationAwareModule {
    public static final String EMR_FS_CLASS_NAME = "com.amazon.ws.emr.hadoop.fs.EmrFileSystem";

    protected void setup(Binder binder) {
        S3FileSystemType type = ((HiveConfig)this.buildConfigObject(HiveConfig.class)).getS3FileSystemType();
        if (type == S3FileSystemType.PRESTO) {
            Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(PrestoS3ConfigurationInitializer.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(HiveS3Config.class);
            binder.bind(PrestoS3FileSystemStats.class).toInstance((Object)PrestoS3FileSystem.getFileSystemStats());
            ExportBinder.newExporter((Binder)binder).export(PrestoS3FileSystemStats.class).as(generator -> generator.generatedNameOf(PrestoS3FileSystem.class));
        } else if (type == S3FileSystemType.EMRFS) {
            HiveS3Module.validateEmrFsClass();
            Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(EmrFsS3ConfigurationInitializer.class).in(Scopes.SINGLETON);
        } else {
            throw new RuntimeException("Unknown file system type: " + (Object)((Object)type));
        }
    }

    private static void validateEmrFsClass() {
        try {
            Class.forName(EMR_FS_CLASS_NAME, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("EMR File System class not found: com.amazon.ws.emr.hadoop.fs.EmrFileSystem", e);
        }
    }

    public static class EmrFsS3ConfigurationInitializer
    implements ConfigurationInitializer {
        @Override
        public void initializeConfiguration(Configuration config) {
            config.set("fs.s3.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3a.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3n.impl", HiveS3Module.EMR_FS_CLASS_NAME);
        }
    }
}

