/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.s3.HiveS3Config;
import io.prestosql.plugin.hive.s3.PrestoS3AclType;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemMetricCollector;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemStats;
import io.prestosql.plugin.hive.s3.PrestoS3SseType;
import io.prestosql.plugin.hive.util.RetryDriver;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class PrestoS3FileSystem
extends FileSystem {
    public static final String S3_USER_AGENT_SUFFIX = "presto";
    public static final String S3_USER_AGENT_PREFIX = "presto.s3.user-agent-prefix";
    public static final String S3_CREDENTIALS_PROVIDER = "presto.s3.credentials-provider";
    public static final String S3_SSE_TYPE = "presto.s3.sse.type";
    public static final String S3_SSE_ENABLED = "presto.s3.sse.enabled";
    public static final String S3_SSE_KMS_KEY_ID = "presto.s3.sse.kms-key-id";
    public static final String S3_KMS_KEY_ID = "presto.s3.kms-key-id";
    public static final String S3_ENCRYPTION_MATERIALS_PROVIDER = "presto.s3.encryption-materials-provider";
    public static final String S3_PIN_CLIENT_TO_CURRENT_REGION = "presto.s3.pin-client-to-current-region";
    public static final String S3_USE_INSTANCE_CREDENTIALS = "presto.s3.use-instance-credentials";
    public static final String S3_MULTIPART_MIN_PART_SIZE = "presto.s3.multipart.min-part-size";
    public static final String S3_MULTIPART_MIN_FILE_SIZE = "presto.s3.multipart.min-file-size";
    public static final String S3_STAGING_DIRECTORY = "presto.s3.staging-directory";
    public static final String S3_MAX_CONNECTIONS = "presto.s3.max-connections";
    public static final String S3_SOCKET_TIMEOUT = "presto.s3.socket-timeout";
    public static final String S3_CONNECT_TIMEOUT = "presto.s3.connect-timeout";
    public static final String S3_MAX_RETRY_TIME = "presto.s3.max-retry-time";
    public static final String S3_MAX_BACKOFF_TIME = "presto.s3.max-backoff-time";
    public static final String S3_MAX_CLIENT_RETRIES = "presto.s3.max-client-retries";
    public static final String S3_MAX_ERROR_RETRIES = "presto.s3.max-error-retries";
    public static final String S3_SSL_ENABLED = "presto.s3.ssl.enabled";
    public static final String S3_PATH_STYLE_ACCESS = "presto.s3.path-style-access";
    public static final String S3_SIGNER_TYPE = "presto.s3.signer-type";
    public static final String S3_SIGNER_CLASS = "presto.s3.signer-class";
    public static final String S3_ENDPOINT = "presto.s3.endpoint";
    public static final String S3_SECRET_KEY = "presto.s3.secret-key";
    public static final String S3_ACCESS_KEY = "presto.s3.access-key";
    public static final String S3_IAM_ROLE = "presto.s3.iam-role";
    public static final String S3_ACL_TYPE = "presto.s3.upload-acl-type";
    public static final String S3_SKIP_GLACIER_OBJECTS = "presto.s3.skip-glacier-objects";
    public static final String S3_REQUESTER_PAYS_ENABLED = "presto.s3.requester-pays.enabled";
    static final String S3_DIRECTORY_OBJECT_CONTENT_TYPE = "application/x-directory";
    private static final Logger log = Logger.get(PrestoS3FileSystem.class);
    private static final PrestoS3FileSystemStats STATS = new PrestoS3FileSystemStats();
    private static final RequestMetricCollector METRIC_COLLECTOR = new PrestoS3FileSystemMetricCollector(STATS);
    private static final String DIRECTORY_SUFFIX = "_$folder$";
    private static final DataSize BLOCK_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_SKIP_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final String PATH_SEPARATOR = "/";
    private static final Duration BACKOFF_MIN_SLEEP = new Duration(1.0, TimeUnit.SECONDS);
    private static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    private static final String S3_CUSTOM_SIGNER = "PrestoS3CustomSigner";
    private URI uri;
    private Path workingDirectory;
    private AmazonS3 s3;
    private AWSCredentialsProvider credentialsProvider;
    private File stagingDirectory;
    private int maxAttempts;
    private Duration maxBackoffTime;
    private Duration maxRetryTime;
    private boolean useInstanceCredentials;
    private String iamRole;
    private boolean pinS3ClientToCurrentRegion;
    private boolean sseEnabled;
    private PrestoS3SseType sseType;
    private String sseKmsKeyId;
    private boolean isPathStyleAccess;
    private long multiPartUploadMinFileSize;
    private long multiPartUploadMinPartSize;
    private PrestoS3AclType s3AclType;
    private boolean skipGlacierObjects;
    private boolean requesterPaysEnabled;

    public void initialize(URI uri, Configuration conf) throws IOException {
        Objects.requireNonNull(uri, "uri is null");
        Objects.requireNonNull(conf, "conf is null");
        super.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDirectory = new Path(PATH_SEPARATOR).makeQualified(this.uri, new Path(PATH_SEPARATOR));
        HiveS3Config defaults = new HiveS3Config();
        this.stagingDirectory = new File(conf.get(S3_STAGING_DIRECTORY, defaults.getS3StagingDirectory().toString()));
        this.maxAttempts = conf.getInt(S3_MAX_CLIENT_RETRIES, defaults.getS3MaxClientRetries()) + 1;
        this.maxBackoffTime = Duration.valueOf((String)conf.get(S3_MAX_BACKOFF_TIME, defaults.getS3MaxBackoffTime().toString()));
        this.maxRetryTime = Duration.valueOf((String)conf.get(S3_MAX_RETRY_TIME, defaults.getS3MaxRetryTime().toString()));
        int maxErrorRetries = conf.getInt(S3_MAX_ERROR_RETRIES, defaults.getS3MaxErrorRetries());
        boolean sslEnabled = conf.getBoolean(S3_SSL_ENABLED, defaults.isS3SslEnabled());
        Duration connectTimeout = Duration.valueOf((String)conf.get(S3_CONNECT_TIMEOUT, defaults.getS3ConnectTimeout().toString()));
        Duration socketTimeout = Duration.valueOf((String)conf.get(S3_SOCKET_TIMEOUT, defaults.getS3SocketTimeout().toString()));
        int maxConnections = conf.getInt(S3_MAX_CONNECTIONS, defaults.getS3MaxConnections());
        this.multiPartUploadMinFileSize = conf.getLong(S3_MULTIPART_MIN_FILE_SIZE, defaults.getS3MultipartMinFileSize().toBytes());
        this.multiPartUploadMinPartSize = conf.getLong(S3_MULTIPART_MIN_PART_SIZE, defaults.getS3MultipartMinPartSize().toBytes());
        this.isPathStyleAccess = conf.getBoolean(S3_PATH_STYLE_ACCESS, defaults.isS3PathStyleAccess());
        this.useInstanceCredentials = conf.getBoolean(S3_USE_INSTANCE_CREDENTIALS, defaults.isS3UseInstanceCredentials());
        this.iamRole = conf.get(S3_IAM_ROLE, defaults.getS3IamRole());
        Verify.verify((!this.useInstanceCredentials || this.iamRole == null ? 1 : 0) != 0, (String)"Invalid configuration: either use instance credentials or specify an iam role", (Object[])new Object[0]);
        this.pinS3ClientToCurrentRegion = conf.getBoolean(S3_PIN_CLIENT_TO_CURRENT_REGION, defaults.isPinS3ClientToCurrentRegion());
        Verify.verify((!this.pinS3ClientToCurrentRegion || conf.get(S3_ENDPOINT) == null ? 1 : 0) != 0, (String)"Invalid configuration: either endpoint can be set or S3 client can be pinned to the current region", (Object[])new Object[0]);
        this.sseEnabled = conf.getBoolean(S3_SSE_ENABLED, defaults.isS3SseEnabled());
        this.sseType = PrestoS3SseType.valueOf(conf.get(S3_SSE_TYPE, defaults.getS3SseType().name()));
        this.sseKmsKeyId = conf.get(S3_SSE_KMS_KEY_ID, defaults.getS3SseKmsKeyId());
        this.s3AclType = PrestoS3AclType.valueOf(conf.get(S3_ACL_TYPE, defaults.getS3AclType().name()));
        String userAgentPrefix = conf.get(S3_USER_AGENT_PREFIX, defaults.getS3UserAgentPrefix());
        this.skipGlacierObjects = conf.getBoolean(S3_SKIP_GLACIER_OBJECTS, defaults.isSkipGlacierObjects());
        this.requesterPaysEnabled = conf.getBoolean(S3_REQUESTER_PAYS_ENABLED, defaults.isRequesterPaysEnabled());
        ClientConfiguration configuration = new ClientConfiguration().withMaxErrorRetry(maxErrorRetries).withProtocol(sslEnabled ? Protocol.HTTPS : Protocol.HTTP).withConnectionTimeout(Math.toIntExact(connectTimeout.toMillis())).withSocketTimeout(Math.toIntExact(socketTimeout.toMillis())).withMaxConnections(maxConnections).withUserAgentPrefix(userAgentPrefix).withUserAgentSuffix(S3_USER_AGENT_SUFFIX);
        this.credentialsProvider = this.createAwsCredentialsProvider(uri, conf);
        this.s3 = this.createAmazonS3Client(conf, configuration);
    }

    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> super.close());
            if (this.credentialsProvider instanceof Closeable) {
                closer.register((Closeable)this.credentialsProvider);
            }
            closer.register(() -> ((AmazonS3)this.s3).shutdown());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path path) {
        this.workingDirectory = path;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        STATS.newListStatusCall();
        ArrayList<Object> list = new ArrayList<Object>();
        RemoteIterator<LocatedFileStatus> iterator = this.listLocatedStatus(path);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return (FileStatus[])Iterables.toArray(list, LocatedFileStatus.class);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path path) {
        STATS.newListLocatedStatusCall();
        return new RemoteIterator<LocatedFileStatus>(){
            private final Iterator<LocatedFileStatus> iterator;
            {
                this.iterator = PrestoS3FileSystem.this.listPrefix(path);
            }

            public boolean hasNext() throws IOException {
                try {
                    return this.iterator.hasNext();
                }
                catch (AmazonClientException e) {
                    throw new IOException(e);
                }
            }

            public LocatedFileStatus next() throws IOException {
                try {
                    return this.iterator.next();
                }
                catch (AmazonClientException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        if (path.getName().isEmpty()) {
            if (this.getS3ObjectMetadata(path) != null) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        ObjectMetadata metadata = this.getS3ObjectMetadata(path);
        if (metadata == null) {
            Iterator<LocatedFileStatus> iterator = this.listPrefix(path);
            if (iterator.hasNext()) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        return new FileStatus(PrestoS3FileSystem.getObjectSize(path, metadata), S3_DIRECTORY_OBJECT_CONTENT_TYPE.equals(metadata.getContentType()), 1, BLOCK_SIZE.toBytes(), PrestoS3FileSystem.lastModifiedTime(metadata), this.qualifiedPath(path));
    }

    private static long getObjectSize(Path path, ObjectMetadata metadata) throws IOException {
        Map userMetadata = metadata.getUserMetadata();
        String length = (String)userMetadata.get("x-amz-unencrypted-content-length");
        if (userMetadata.containsKey("x-amz-server-side-encryption") && length == null) {
            throw new IOException(String.format("%s header is not set on an encrypted object: %s", "x-amz-unencrypted-content-length", path));
        }
        return length != null ? Long.parseLong(length) : metadata.getContentLength();
    }

    public FSDataInputStream open(Path path, int bufferSize) {
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new PrestoS3InputStream(this.s3, PrestoS3FileSystem.getBucketName(this.uri), path, this.requesterPaysEnabled, this.maxAttempts, this.maxBackoffTime, this.maxRetryTime), bufferSize));
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (!this.stagingDirectory.exists()) {
            Files.createDirectories(this.stagingDirectory.toPath(), new FileAttribute[0]);
        }
        if (!this.stagingDirectory.isDirectory()) {
            throw new IOException("Configured staging path is not a directory: " + this.stagingDirectory);
        }
        File tempFile = Files.createTempFile(this.stagingDirectory.toPath(), "presto-s3-", ".tmp", new FileAttribute[0]).toFile();
        String key = PrestoS3FileSystem.keyFromPath(this.qualifiedPath(path));
        return new FSDataOutputStream((OutputStream)new PrestoS3OutputStream(this.s3, PrestoS3FileSystem.getBucketName(this.uri), key, tempFile, this.sseEnabled, this.sseType, this.sseKmsKeyId, this.multiPartUploadMinFileSize, this.multiPartUploadMinPartSize, this.s3AclType, this.requesterPaysEnabled), this.statistics);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcDirectory;
        try {
            srcDirectory = this.directory(src);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            if (!this.directory(dst)) {
                return false;
            }
            dst = new Path(dst, src.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (PrestoS3FileSystem.keysEqual(src, dst)) {
            return false;
        }
        if (srcDirectory) {
            for (FileStatus file : this.listStatus(src)) {
                this.rename(file.getPath(), new Path(dst, file.getPath().getName()));
            }
            this.deleteObject(PrestoS3FileSystem.keyFromPath(src) + DIRECTORY_SUFFIX);
        } else {
            this.s3.copyObject(new CopyObjectRequest(PrestoS3FileSystem.getBucketName(this.uri), PrestoS3FileSystem.keyFromPath(src), PrestoS3FileSystem.getBucketName(this.uri), PrestoS3FileSystem.keyFromPath(dst)).withRequesterPays(this.requesterPaysEnabled));
            this.delete(src, true);
        }
        return true;
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            if (!this.directory(path)) {
                return this.deleteObject(PrestoS3FileSystem.keyFromPath(path));
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!recursive) {
            throw new IOException("Directory " + path + " is not empty");
        }
        for (FileStatus file : this.listStatus(path)) {
            this.delete(file.getPath(), true);
        }
        this.deleteObject(PrestoS3FileSystem.keyFromPath(path) + DIRECTORY_SUFFIX);
        return true;
    }

    private boolean directory(Path path) throws IOException {
        return this.getFileStatus(path).isDirectory();
    }

    private boolean deleteObject(String key) {
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(PrestoS3FileSystem.getBucketName(this.uri), key);
            if (this.requesterPaysEnabled) {
                deleteObjectRequest.putCustomRequestHeader("x-amz-request-payer", "requester");
            }
            this.s3.deleteObject(deleteObjectRequest);
            return true;
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        return true;
    }

    private Iterator<LocatedFileStatus> listPrefix(Path path) {
        String key = PrestoS3FileSystem.keyFromPath(path);
        if (!key.isEmpty()) {
            key = key + PATH_SEPARATOR;
        }
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(PrestoS3FileSystem.getBucketName(this.uri)).withPrefix(key).withDelimiter(PATH_SEPARATOR).withRequesterPays(this.requesterPaysEnabled);
        STATS.newListObjectsCall();
        AbstractSequentialIterator<ObjectListing> listings = new AbstractSequentialIterator<ObjectListing>(this.s3.listObjects(request)){

            protected ObjectListing computeNext(ObjectListing previous) {
                if (!previous.isTruncated()) {
                    return null;
                }
                return PrestoS3FileSystem.this.s3.listNextBatchOfObjects(previous);
            }
        };
        return Iterators.concat((Iterator)Iterators.transform((Iterator)listings, this::statusFromListing));
    }

    private Iterator<LocatedFileStatus> statusFromListing(ObjectListing listing) {
        return Iterators.concat(this.statusFromPrefixes(listing.getCommonPrefixes()), this.statusFromObjects(listing.getObjectSummaries()));
    }

    private Iterator<LocatedFileStatus> statusFromPrefixes(List<String> prefixes) {
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>();
        for (String prefix : prefixes) {
            Path path = this.qualifiedPath(new Path(PATH_SEPARATOR + prefix));
            FileStatus status = new FileStatus(0L, true, 1, 0L, 0L, path);
            list.add(this.createLocatedFileStatus(status));
        }
        return list.iterator();
    }

    private Iterator<LocatedFileStatus> statusFromObjects(List<S3ObjectSummary> objects) {
        return objects.stream().filter(object -> !object.getKey().endsWith(PATH_SEPARATOR)).filter(object -> !this.skipGlacierObjects || !PrestoS3FileSystem.isGlacierObject(object)).map(object -> new FileStatus(object.getSize(), false, 1, BLOCK_SIZE.toBytes(), object.getLastModified().getTime(), this.qualifiedPath(new Path(PATH_SEPARATOR + object.getKey())))).map(this::createLocatedFileStatus).iterator();
    }

    private static boolean isGlacierObject(S3ObjectSummary object) {
        return StorageClass.Glacier.toString().equals(object.getStorageClass());
    }

    @VisibleForTesting
    ObjectMetadata getS3ObjectMetadata(Path path) throws IOException {
        String key;
        String bucketName = PrestoS3FileSystem.getBucketName(this.uri);
        ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(path, bucketName, key = PrestoS3FileSystem.keyFromPath(path));
        if (s3ObjectMetadata == null && !key.isEmpty()) {
            return this.getS3ObjectMetadata(path, bucketName, key + PATH_SEPARATOR);
        }
        return s3ObjectMetadata;
    }

    private ObjectMetadata getS3ObjectMetadata(Path path, String bucketName, String key) throws IOException {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetMetadataRetry).run("getS3ObjectMetadata", () -> {
                try {
                    STATS.newMetadataCall();
                    return this.s3.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key).withRequesterPays(this.requesterPaysEnabled));
                }
                catch (RuntimeException e) {
                    STATS.newGetMetadataError();
                    if (e instanceof AmazonS3Exception) {
                        switch (((AmazonS3Exception)e).getStatusCode()) {
                            case 404: {
                                return null;
                            }
                            case 400: 
                            case 403: {
                                throw new UnrecoverableS3OperationException(path, (Throwable)e);
                            }
                        }
                    }
                    throw e;
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Path qualifiedPath(Path path) {
        return path.makeQualified(this.uri, this.getWorkingDirectory());
    }

    private LocatedFileStatus createLocatedFileStatus(FileStatus status) {
        try {
            BlockLocation[] fakeLocation = this.getFileBlockLocations(status, 0L, status.getLen());
            return new LocatedFileStatus(status, fakeLocation);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static long lastModifiedTime(ObjectMetadata metadata) {
        Date date = metadata.getLastModified();
        return date != null ? date.getTime() : 0L;
    }

    private static boolean keysEqual(Path p1, Path p2) {
        return PrestoS3FileSystem.keyFromPath(p1).equals(PrestoS3FileSystem.keyFromPath(p2));
    }

    public static String keyFromPath(Path path) {
        Preconditions.checkArgument((boolean)path.isAbsolute(), (String)"Path is not absolute: %s", (Object)path);
        String key = Strings.nullToEmpty((String)path.toUri().getPath());
        if (key.startsWith(PATH_SEPARATOR)) {
            key = key.substring(PATH_SEPARATOR.length());
        }
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key;
    }

    private AmazonS3 createAmazonS3Client(Configuration hadoopConfig, ClientConfiguration clientConfig) {
        String endpoint;
        Region region;
        String signerClass;
        Optional<EncryptionMaterialsProvider> encryptionMaterialsProvider = PrestoS3FileSystem.createEncryptionMaterialsProvider(hadoopConfig);
        String signerType = hadoopConfig.get(S3_SIGNER_TYPE);
        if (signerType != null) {
            clientConfig.withSignerOverride(signerType);
        }
        if ((signerClass = hadoopConfig.get(S3_SIGNER_CLASS)) != null) {
            Class<Signer> klass;
            try {
                klass = Class.forName(signerClass).asSubclass(Signer.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Signer class not found: " + signerClass, e);
            }
            SignerFactory.registerSigner((String)S3_CUSTOM_SIGNER, klass);
            clientConfig.setSignerOverride(S3_CUSTOM_SIGNER);
        }
        AmazonS3Builder clientBuilder = encryptionMaterialsProvider.isPresent() ? (AmazonS3Builder)((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClient.encryptionBuilder().withCredentials(this.credentialsProvider)).withEncryptionMaterials(encryptionMaterialsProvider.get()).withClientConfiguration(clientConfig)).withMetricsCollector(METRIC_COLLECTOR) : (AmazonS3Builder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(this.credentialsProvider)).withClientConfiguration(clientConfig)).withMetricsCollector(METRIC_COLLECTOR);
        boolean regionOrEndpointSet = false;
        if (this.pinS3ClientToCurrentRegion && (region = Regions.getCurrentRegion()) != null) {
            clientBuilder.setRegion(region.getName());
            regionOrEndpointSet = true;
        }
        if ((endpoint = hadoopConfig.get(S3_ENDPOINT)) != null) {
            clientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
            regionOrEndpointSet = true;
        }
        if (this.isPathStyleAccess) {
            clientBuilder.enablePathStyleAccess();
        }
        if (!regionOrEndpointSet) {
            clientBuilder.withRegion(Regions.US_EAST_1);
            clientBuilder.setForceGlobalBucketAccessEnabled(Boolean.valueOf(true));
        }
        return (AmazonS3)clientBuilder.build();
    }

    private static Optional<EncryptionMaterialsProvider> createEncryptionMaterialsProvider(Configuration hadoopConfig) {
        String kmsKeyId = hadoopConfig.get(S3_KMS_KEY_ID);
        if (kmsKeyId != null) {
            return Optional.of(new KMSEncryptionMaterialsProvider(kmsKeyId));
        }
        String empClassName = hadoopConfig.get(S3_ENCRYPTION_MATERIALS_PROVIDER);
        if (empClassName == null) {
            return Optional.empty();
        }
        try {
            Object instance = Class.forName(empClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof EncryptionMaterialsProvider)) {
                throw new RuntimeException("Invalid encryption materials provider class: " + instance.getClass().getName());
            }
            EncryptionMaterialsProvider emp = (EncryptionMaterialsProvider)instance;
            if (emp instanceof Configurable) {
                ((Configurable)emp).setConf(hadoopConfig);
            }
            return Optional.of(emp);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load or create S3 encryption materials provider: " + empClassName, e);
        }
    }

    private AWSCredentialsProvider createAwsCredentialsProvider(URI uri, Configuration conf) {
        Optional<AWSCredentials> credentials = PrestoS3FileSystem.getAwsCredentials(uri, conf);
        if (credentials.isPresent()) {
            return new AWSStaticCredentialsProvider(credentials.get());
        }
        if (this.useInstanceCredentials) {
            return InstanceProfileCredentialsProvider.getInstance();
        }
        if (this.iamRole != null) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(this.iamRole, "presto-session").build();
        }
        String providerClass = conf.get(S3_CREDENTIALS_PROVIDER);
        if (!Strings.isNullOrEmpty((String)providerClass)) {
            return PrestoS3FileSystem.getCustomAWSCredentialsProvider(uri, conf, providerClass);
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(URI uri, Configuration conf, String providerClass) {
        try {
            log.debug("Using AWS credential provider %s for URI %s", new Object[]{providerClass, uri});
            return conf.getClassByName(providerClass).asSubclass(AWSCredentialsProvider.class).getConstructor(URI.class, Configuration.class).newInstance(uri, conf);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s for URI %s", providerClass, uri), e);
        }
    }

    private static Optional<AWSCredentials> getAwsCredentials(URI uri, Configuration conf) {
        String accessKey = conf.get(S3_ACCESS_KEY);
        String secretKey = conf.get(S3_SECRET_KEY);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index < 0) {
                accessKey = userInfo;
            } else {
                accessKey = userInfo.substring(0, index);
                secretKey = userInfo.substring(index + 1);
            }
        }
        if (Strings.isNullOrEmpty((String)accessKey) || Strings.isNullOrEmpty((String)secretKey)) {
            return Optional.empty();
        }
        return Optional.of(new BasicAWSCredentials(accessKey, secretKey));
    }

    @VisibleForTesting
    AmazonS3 getS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    void setS3Client(AmazonS3 client) {
        this.s3 = client;
    }

    public static String getBucketName(URI uri) {
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        if (uri.getUserInfo() == null) {
            return uri.getAuthority();
        }
        throw new IllegalArgumentException("Unable to determine S3 bucket from URI.");
    }

    public static PrestoS3FileSystemStats getFileSystemStats() {
        return STATS;
    }

    private static class PrestoS3OutputStream
    extends FilterOutputStream {
        private final TransferManager transferManager;
        private final String host;
        private final String key;
        private final File tempFile;
        private final boolean sseEnabled;
        private final PrestoS3SseType sseType;
        private final String sseKmsKeyId;
        private final CannedAccessControlList aclType;
        private final boolean requesterPaysEnabled;
        private boolean closed;

        public PrestoS3OutputStream(AmazonS3 s3, String host, String key, File tempFile, boolean sseEnabled, PrestoS3SseType sseType, String sseKmsKeyId, long multiPartUploadMinFileSize, long multiPartUploadMinPartSize, PrestoS3AclType aclType, boolean requesterPaysEnabled) throws IOException {
            super(new BufferedOutputStream(new FileOutputStream(Objects.requireNonNull(tempFile, "tempFile is null"))));
            this.transferManager = TransferManagerBuilder.standard().withS3Client(Objects.requireNonNull(s3, "s3 is null")).withMinimumUploadPartSize(Long.valueOf(multiPartUploadMinPartSize)).withMultipartUploadThreshold(Long.valueOf(multiPartUploadMinFileSize)).build();
            Objects.requireNonNull(aclType, "aclType is null");
            this.aclType = aclType.getCannedACL();
            this.host = Objects.requireNonNull(host, "host is null");
            this.key = Objects.requireNonNull(key, "key is null");
            this.tempFile = tempFile;
            this.sseEnabled = sseEnabled;
            this.sseType = Objects.requireNonNull(sseType, "sseType is null");
            this.sseKmsKeyId = sseKmsKeyId;
            this.requesterPaysEnabled = requesterPaysEnabled;
            log.debug("OutputStream for key '%s' using file: %s", new Object[]{key, tempFile});
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            block4: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                    this.uploadObject();
                    if (this.tempFile.delete()) break block4;
                }
                catch (Throwable throwable) {
                    if (!this.tempFile.delete()) {
                        log.warn("Could not delete temporary file: %s", new Object[]{this.tempFile});
                    }
                    this.transferManager.shutdownNow(false);
                    throw throwable;
                }
                log.warn("Could not delete temporary file: %s", new Object[]{this.tempFile});
            }
            this.transferManager.shutdownNow(false);
        }

        private void uploadObject() throws IOException {
            try {
                log.debug("Starting upload for host: %s, key: %s, file: %s, size: %s", new Object[]{this.host, this.key, this.tempFile, this.tempFile.length()});
                STATS.uploadStarted();
                PutObjectRequest request = new PutObjectRequest(this.host, this.key, this.tempFile).withRequesterPays(this.requesterPaysEnabled);
                if (this.sseEnabled) {
                    switch (this.sseType) {
                        case KMS: {
                            if (this.sseKmsKeyId != null) {
                                request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseKmsKeyId));
                                break;
                            }
                            request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams());
                            break;
                        }
                        case S3: {
                            ObjectMetadata metadata = new ObjectMetadata();
                            metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                            request.setMetadata(metadata);
                        }
                    }
                }
                request.withCannedAcl(this.aclType);
                Upload upload = this.transferManager.upload(request);
                if (log.isDebugEnabled()) {
                    upload.addProgressListener(this.createProgressListener((Transfer)upload));
                }
                upload.waitForCompletion();
                STATS.uploadSuccessful();
                log.debug("Completed upload for host: %s, key: %s", new Object[]{this.host, this.key});
            }
            catch (AmazonClientException e) {
                STATS.uploadFailed();
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                STATS.uploadFailed();
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        private ProgressListener createProgressListener(final Transfer transfer) {
            return new ProgressListener(){
                private ProgressEventType previousType;
                private double previousTransferred;

                public synchronized void progressChanged(ProgressEvent progressEvent) {
                    double transferred;
                    ProgressEventType eventType = progressEvent.getEventType();
                    if (this.previousType != eventType) {
                        log.debug("Upload progress event (%s/%s): %s", new Object[]{host, key, eventType});
                        this.previousType = eventType;
                    }
                    if ((transferred = transfer.getProgress().getPercentTransferred()) >= this.previousTransferred + 10.0) {
                        log.debug("Upload percentage (%s/%s): %.0f%%", new Object[]{host, key, transferred});
                        this.previousTransferred = transferred;
                    }
                }
            };
        }
    }

    private static class PrestoS3InputStream
    extends FSInputStream {
        private final AmazonS3 s3;
        private final String host;
        private final Path path;
        private final boolean requesterPaysEnabled;
        private final int maxAttempts;
        private final Duration maxBackoffTime;
        private final Duration maxRetryTime;
        private final AtomicBoolean closed = new AtomicBoolean();
        private InputStream in;
        private long streamPosition;
        private long nextReadPosition;

        public PrestoS3InputStream(AmazonS3 s3, String host, Path path, boolean requesterPaysEnabled, int maxAttempts, Duration maxBackoffTime, Duration maxRetryTime) {
            this.s3 = Objects.requireNonNull(s3, "s3 is null");
            this.host = Objects.requireNonNull(host, "host is null");
            this.path = Objects.requireNonNull(path, "path is null");
            this.requesterPaysEnabled = requesterPaysEnabled;
            Preconditions.checkArgument((maxAttempts >= 0 ? 1 : 0) != 0, (Object)"maxAttempts cannot be negative");
            this.maxAttempts = maxAttempts;
            this.maxBackoffTime = Objects.requireNonNull(maxBackoffTime, "maxBackoffTime is null");
            this.maxRetryTime = Objects.requireNonNull(maxRetryTime, "maxRetryTime is null");
        }

        public void close() {
            this.closed.set(true);
            this.closeStream();
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.checkClosed();
            if (position < 0L) {
                throw new EOFException("Cannot seek to a negative offset");
            }
            Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
            if (length == 0) {
                return 0;
            }
            try {
                return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class, EOFException.class).onRetry(STATS::newGetObjectRetry).run("getS3Object", () -> {
                    S3ObjectInputStream stream;
                    try {
                        GetObjectRequest request = new GetObjectRequest(this.host, PrestoS3FileSystem.keyFromPath(this.path)).withRange(position, position + (long)length - 1L).withRequesterPays(this.requesterPaysEnabled);
                        stream = this.s3.getObject(request).getObjectContent();
                    }
                    catch (RuntimeException e) {
                        STATS.newGetObjectError();
                        if (e instanceof AmazonS3Exception) {
                            switch (((AmazonS3Exception)e).getStatusCode()) {
                                case 416: {
                                    throw new EOFException("Attempted to seek or read past the end of the file");
                                }
                                case 400: 
                                case 403: 
                                case 404: {
                                    throw new UnrecoverableS3OperationException(this.path, (Throwable)e);
                                }
                            }
                        }
                        throw e;
                    }
                    STATS.connectionOpened();
                    try {
                        int read;
                        int n;
                        for (read = 0; read < length; read += n) {
                            n = stream.read(buffer, offset + read, length - read);
                            if (n > 0) continue;
                            if (read > 0) {
                                Integer n2 = read;
                                return n2;
                            }
                            Integer n3 = -1;
                            return n3;
                        }
                        Integer n4 = read;
                        return n4;
                    }
                    catch (Throwable t) {
                        STATS.newReadError(t);
                        PrestoS3InputStream.abortStream((InputStream)stream);
                        throw t;
                    }
                    finally {
                        STATS.connectionReleased();
                        stream.close();
                    }
                });
            }
            catch (Exception e) {
                throw PrestoS3InputStream.propagate(e);
            }
        }

        public void seek(long pos) throws IOException {
            this.checkClosed();
            if (pos < 0L) {
                throw new EOFException("Cannot seek to a negative offset");
            }
            this.nextReadPosition = pos;
        }

        public long getPos() {
            return this.nextReadPosition;
        }

        public int read() {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            this.checkClosed();
            try {
                int bytesRead = RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class, AbortedException.class).onRetry(STATS::newReadRetry).run("readStream", () -> {
                    this.seekStream();
                    try {
                        return this.in.read(buffer, offset, length);
                    }
                    catch (Exception e) {
                        STATS.newReadError(e);
                        this.closeStream();
                        throw e;
                    }
                });
                if (bytesRead != -1) {
                    this.streamPosition += (long)bytesRead;
                    this.nextReadPosition += (long)bytesRead;
                }
                return bytesRead;
            }
            catch (Exception e) {
                throw PrestoS3InputStream.propagate(e);
            }
        }

        public boolean seekToNewSource(long targetPos) {
            return false;
        }

        private void seekStream() throws IOException {
            long skip;
            if (this.in != null && this.nextReadPosition == this.streamPosition) {
                return;
            }
            if (this.in != null && this.nextReadPosition > this.streamPosition && (skip = this.nextReadPosition - this.streamPosition) <= Math.max((long)this.in.available(), MAX_SKIP_SIZE.toBytes())) {
                try {
                    if (this.in.skip(skip) == skip) {
                        this.streamPosition = this.nextReadPosition;
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.streamPosition = this.nextReadPosition;
            this.closeStream();
            this.openStream();
        }

        private void openStream() throws IOException {
            if (this.in == null) {
                this.in = this.openStream(this.path, this.nextReadPosition);
                this.streamPosition = this.nextReadPosition;
                STATS.connectionOpened();
            }
        }

        private InputStream openStream(Path path, long start) throws IOException {
            try {
                return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetObjectRetry).run("getS3Object", () -> {
                    try {
                        GetObjectRequest request = new GetObjectRequest(this.host, PrestoS3FileSystem.keyFromPath(path)).withRange(start).withRequesterPays(this.requesterPaysEnabled);
                        return this.s3.getObject(request).getObjectContent();
                    }
                    catch (RuntimeException e) {
                        STATS.newGetObjectError();
                        if (e instanceof AmazonS3Exception) {
                            switch (((AmazonS3Exception)e).getStatusCode()) {
                                case 416: {
                                    return new ByteArrayInputStream(new byte[0]);
                                }
                                case 400: 
                                case 403: 
                                case 404: {
                                    throw new UnrecoverableS3OperationException(path, (Throwable)e);
                                }
                            }
                        }
                        throw e;
                    }
                });
            }
            catch (Exception e) {
                throw PrestoS3InputStream.propagate(e);
            }
        }

        private void closeStream() {
            if (this.in != null) {
                PrestoS3InputStream.abortStream(this.in);
                this.in = null;
                STATS.connectionReleased();
            }
        }

        private void checkClosed() throws IOException {
            if (this.closed.get()) {
                throw new IOException("Stream is closed!");
            }
        }

        private static void abortStream(InputStream in) {
            try {
                if (in instanceof S3ObjectInputStream) {
                    ((S3ObjectInputStream)in).abort();
                } else {
                    in.close();
                }
            }
            catch (AbortedException | IOException throwable) {
                // empty catch block
            }
        }

        private static RuntimeException propagate(Exception e) throws IOException {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    static class UnrecoverableS3OperationException
    extends IOException {
        public UnrecoverableS3OperationException(Path path, Throwable cause) {
            super(String.format("%s (Path: %s)", cause, path), cause);
        }
    }
}

