/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigurationModule;
import io.prestosql.plugin.base.security.FileBasedAccessControlModule;
import io.prestosql.plugin.base.security.ReadOnlySecurityModule;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.plugin.hive.security.AccessControlMetadataFactory;
import io.prestosql.plugin.hive.security.LegacySecurityModule;
import io.prestosql.plugin.hive.security.SecurityConfig;
import io.prestosql.plugin.hive.security.SqlStandardSecurityModule;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindSecurityModule("legacy", (Module)ConfigurationModule.installModules((Module[])new Module[]{new LegacySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule("file", (Module)ConfigurationModule.installModules((Module[])new Module[]{new FileBasedAccessControlModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule("read-only", (Module)ConfigurationModule.installModules((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule("sql-standard", new SqlStandardSecurityModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            binder.bind(AccessControlMetadataFactory.class).toInstance(metastore -> new AccessControlMetadata(){});
        }
    }
}

