/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import io.prestosql.plugin.base.security.ForwardingConnectorAccessControl;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SystemTableAwareAccessControl
extends ForwardingConnectorAccessControl {
    private final ConnectorAccessControl delegate;

    public SystemTableAwareAccessControl(ConnectorAccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    protected ConnectorAccessControl delegate() {
        return this.delegate;
    }

    public void checkCanShowColumnsMetadata(ConnectorSecurityContext context, SchemaTableName tableName) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanShowColumnsMetadata(context, sourceTableName.get());
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denyShowColumnsMetadata((String)tableName.toString());
            }
        }
        this.delegate.checkCanShowColumnsMetadata(context, tableName);
    }

    public List<ColumnMetadata> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, List<ColumnMetadata> columns) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            return this.filterColumns(context, sourceTableName.get(), columns);
        }
        return this.delegate.filterColumns(context, tableName, columns);
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanSelectFromColumns(context, sourceTableName.get(), columnNames);
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denySelectTable((String)tableName.toString());
            }
        }
        this.delegate.checkCanSelectFromColumns(context, tableName, columnNames);
    }
}

