/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.AbstractIterator;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TempFileReader
extends AbstractIterator<Page> {
    private final int columnCount;
    private final OrcRecordReader reader;

    public TempFileReader(List<Type> types, OrcDataSource dataSource) {
        Objects.requireNonNull(types, "types is null");
        this.columnCount = types.size();
        try {
            OrcReader orcReader = new OrcReader(dataSource, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE));
            HashMap<Integer, Type> includedColumns = new HashMap<Integer, Type>();
            for (int i = 0; i < types.size(); ++i) {
                includedColumns.put(i, types.get(i));
            }
            this.reader = orcReader.createRecordReader(includedColumns, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data");
        }
    }

    protected Page computeNext() {
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int batchSize = this.reader.nextBatch();
            if (batchSize <= 0) {
                return (Page)this.endOfData();
            }
            Block[] blocks = new Block[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                blocks[i] = this.reader.readBlock(i).getLoadedBlock();
            }
            return new Page(batchSize, blocks);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data");
        }
    }
}

