/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.com.codahale.metrics.jvm;

import io.prestosql.hive.$internal.com.codahale.metrics.JmxAttributeGauge;
import io.prestosql.hive.$internal.com.codahale.metrics.Metric;
import io.prestosql.hive.$internal.com.codahale.metrics.MetricRegistry;
import io.prestosql.hive.$internal.com.codahale.metrics.MetricSet;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class BufferPoolMetricSet
implements MetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferPoolMetricSet.class);
    private static final String[] ATTRIBUTES = new String[]{"Count", "MemoryUsed", "TotalCapacity"};
    private static final String[] NAMES = new String[]{"count", "used", "capacity"};
    private static final String[] POOLS = new String[]{"direct", "mapped"};
    private final MBeanServer mBeanServer;

    public BufferPoolMetricSet(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, JmxAttributeGauge> gauges = new HashMap<String, JmxAttributeGauge>();
        for (String pool : POOLS) {
            for (int i = 0; i < ATTRIBUTES.length; ++i) {
                String attribute = ATTRIBUTES[i];
                String name = NAMES[i];
                try {
                    ObjectName on = new ObjectName("java.nio:type=BufferPool,name=" + pool);
                    this.mBeanServer.getMBeanInfo(on);
                    gauges.put(MetricRegistry.name(pool, name), new JmxAttributeGauge(this.mBeanServer, on, attribute));
                    continue;
                }
                catch (JMException ignored) {
                    LOGGER.debug("Unable to load buffer pool MBeans, possibly running on Java 6");
                }
            }
        }
        return Collections.unmodifiableMap(gauges);
    }
}

