/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles;

import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.HashCommon;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles.AbstractDouble2ObjectFunction;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.doubles.DoubleSet;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.objects.ObjectCollection;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.objects.ObjectIterator;
import io.prestosql.hive.$internal.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDouble2ObjectMap<V>
extends AbstractDouble2ObjectFunction<V>
implements Double2ObjectMap<V>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2ObjectMap() {
    }

    @Override
    public boolean containsValue(Object v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(double k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Double, ? extends V> m) {
        int n = m.size();
        Iterator<Map.Entry<Double, V>> i = m.entrySet().iterator();
        if (m instanceof Double2ObjectMap) {
            while (n-- != 0) {
                Double2ObjectMap.Entry e = (Double2ObjectMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<Double, V> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k) {
                return AbstractDouble2ObjectMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractDouble2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2ObjectMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new AbstractDoubleIterator(){
                    final ObjectIterator<Map.Entry<Double, V>> i;
                    {
                        this.i = AbstractDouble2ObjectMap.this.entrySet().iterator();
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2ObjectMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ObjectCollection<V> values() {
        return new AbstractObjectCollection<V>(){

            @Override
            public boolean contains(Object k) {
                return AbstractDouble2ObjectMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractDouble2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2ObjectMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new AbstractObjectIterator<V>(){
                    final ObjectIterator<Map.Entry<Double, V>> i;
                    {
                        this.i = AbstractDouble2ObjectMap.this.entrySet().iterator();
                    }

                    @Override
                    @Deprecated
                    public V next() {
                        return ((Double2ObjectMap.Entry)this.i.next()).getValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Double, V>> entrySet() {
        return this.double2ObjectEntrySet();
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Map.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2ObjectMap.Entry e = (Double2ObjectMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry<V>
    implements Double2ObjectMap.Entry<V> {
        protected double key;
        protected V value;

        public BasicEntry(Double key, V value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @Deprecated
        public Double getKey() {
            return this.key;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Double)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)e.getKey()) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

