/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.exception;

import io.prestosql.hive.$internal.jodd.exception.ExceptionUtil;
import java.io.PrintStream;
import java.io.PrintWriter;

public class UncheckedException
extends RuntimeException {
    protected final Throwable cause;
    protected static final String CAUSE_DIV = "---[cause]------------------------------------------------------------------------";
    protected final boolean showCauseDetails;

    public UncheckedException(Throwable t) {
        super(t.getMessage());
        this.cause = t;
        this.showCauseDetails = true;
    }

    public UncheckedException(Throwable t, boolean showCauseDetails) {
        super(t.getMessage());
        this.cause = t;
        this.showCauseDetails = showCauseDetails;
    }

    public UncheckedException() {
        this.cause = null;
        this.showCauseDetails = false;
    }

    public UncheckedException(String message) {
        super(message);
        this.cause = null;
        this.showCauseDetails = false;
    }

    public UncheckedException(String message, Throwable t) {
        super(message, t);
        this.cause = t;
        this.showCauseDetails = true;
    }

    public UncheckedException(String message, Throwable t, boolean showCauseDetails) {
        super(message, t);
        this.cause = t;
        this.showCauseDetails = showCauseDetails;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.cause != null && this.showCauseDetails) {
                Throwable rootCause = ExceptionUtil.getRootCause(this.cause);
                ps.println(CAUSE_DIV);
                rootCause.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.cause != null && this.showCauseDetails) {
                Throwable rootCause = ExceptionUtil.getRootCause(this.cause);
                pw.println(CAUSE_DIV);
                rootCause.printStackTrace(pw);
            }
        }
    }

    public String getMessage() {
        return ExceptionUtil.buildMessage(super.getMessage(), this.cause);
    }

    public static RuntimeException wrapChecked(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new UncheckedException(t);
    }

    public static RuntimeException wrap(Throwable t) {
        return new UncheckedException(t);
    }

    public static RuntimeException wrap(Throwable t, String message) {
        return new UncheckedException(message, t);
    }

    public void rethrow() throws Throwable {
        if (this.cause == null) {
            return;
        }
        throw this.cause;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

