/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;
import io.prestosql.hive.$internal.jodd.util.CsvUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter<T>
implements TypeConverter<T[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;
    protected final Class<T> targetComponentType;

    public ArrayConverter(TypeConverterManagerBean typeConverterManagerBean, Class<T> targetComponentType) {
        this.typeConverterManagerBean = typeConverterManagerBean;
        this.targetComponentType = targetComponentType;
    }

    @Override
    public T[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected T convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, this.targetComponentType);
    }

    protected T[] createArray(int length) {
        return (Object[])Array.newInstance(this.targetComponentType, length);
    }

    protected T[] convertToSingleElementArray(Object value) {
        T[] singleElementArray = this.createArray(1);
        singleElementArray[0] = this.convertType(value);
        return singleElementArray;
    }

    protected T[] convertValueToArray(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            T[] target = this.createArray(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            T[] target = this.createArray(collection.size());
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList<T> list = new ArrayList<T>();
            for (Object element : iterable) {
                list.add(this.convertType(element));
            }
            T[] target = this.createArray(list.size());
            return list.toArray(target);
        }
        if (value instanceof CharSequence) {
            String[] strings = CsvUtil.toStringArray(value.toString());
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected T[] convertArrayToArray(Object value) {
        T[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == this.targetComponentType) {
            return (Object[])value;
        }
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = this.createArray(array.length);
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected T[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        T[] result;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        result = null;
                                        if (primitiveComponentType != Integer.TYPE) break block8;
                                        int[] array = (int[])value;
                                        result = this.createArray(array.length);
                                        for (int i = 0; i < array.length; ++i) {
                                            result[i] = this.convertType(array[i]);
                                        }
                                        break block9;
                                    }
                                    if (primitiveComponentType != Long.TYPE) break block10;
                                    long[] array = (long[])value;
                                    result = this.createArray(array.length);
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = this.convertType(array[i]);
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Float.TYPE) break block11;
                                float[] array = (float[])value;
                                result = this.createArray(array.length);
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = this.convertType(Float.valueOf(array[i]));
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Double.TYPE) break block12;
                            double[] array = (double[])value;
                            result = this.createArray(array.length);
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = this.convertType(array[i]);
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Short.TYPE) break block13;
                        short[] array = (short[])value;
                        result = this.createArray(array.length);
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = this.convertType(array[i]);
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block14;
                    byte[] array = (byte[])value;
                    result = this.createArray(array.length);
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = this.convertType(array[i]);
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block15;
                char[] array = (char[])value;
                result = this.createArray(array.length);
                for (int i = 0; i < array.length; ++i) {
                    result[i] = this.convertType(Character.valueOf(array[i]));
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = this.createArray(array.length);
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }
}

