/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.io.FileUtil;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConversionException;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.util.ArraysUtil;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConverter
implements TypeConverter<File> {
    protected TypeConverter<File>[] addonFileConverters;

    public void registerAddonConverter(TypeConverter<File> fileTypeConverter) {
        if (this.addonFileConverters == null) {
            this.addonFileConverters = new TypeConverter[0];
        }
        ArraysUtil.append(this.addonFileConverters, fileTypeConverter);
    }

    @Override
    public File convert(Object value) {
        Class<?> type;
        if (value == null) {
            return null;
        }
        if (value instanceof File) {
            return (File)value;
        }
        if (this.addonFileConverters != null) {
            for (TypeConverter<File> addonFileConverter : this.addonFileConverters) {
                File file = addonFileConverter.convert(value);
                if (file == null) continue;
                return file;
            }
        }
        if ((type = value.getClass()) == byte[].class) {
            try {
                File tempFile = FileUtil.createTempFile();
                FileUtil.writeBytes(tempFile, (byte[])value);
                return tempFile;
            }
            catch (IOException ioex) {
                throw new TypeConversionException(ioex);
            }
        }
        if (type == String.class) {
            try {
                File tempFile = FileUtil.createTempFile();
                FileUtil.writeString(tempFile, value.toString());
                return tempFile;
            }
            catch (IOException ioex) {
                throw new TypeConversionException(ioex);
            }
        }
        throw new TypeConversionException(value);
    }
}

