/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.datetime.DateTimeStamp;
import io.prestosql.hive.$internal.jodd.datetime.JDateTime;
import io.prestosql.hive.$internal.jodd.datetime.JulianDateStamp;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConversionException;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.util.StringUtil;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDateTimeConverter
implements TypeConverter<JDateTime> {
    @Override
    public JDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JDateTime) {
            return (JDateTime)value;
        }
        if (value instanceof Calendar) {
            return new JDateTime((Calendar)value);
        }
        if (value instanceof Date) {
            return new JDateTime((Date)value);
        }
        if (value instanceof Number) {
            return new JDateTime(((Number)value).longValue());
        }
        if (value instanceof JulianDateStamp) {
            return new JDateTime((JulianDateStamp)value);
        }
        if (value instanceof DateTimeStamp) {
            return new JDateTime((DateTimeStamp)value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return new JDateTime(stringValue, "YYYY-MM-DD hh:mm:ss.mss");
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new JDateTime(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

