/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.util.buffer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastBuffer<E>
implements RandomAccess,
Iterable<E> {
    private E[][] buffers = new Object[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private E[] currentBuffer;
    private int offset;
    private int size;
    private final int minChunkLen;

    public FastBuffer() {
        this.minChunkLen = 1024;
    }

    public FastBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.minChunkLen = size;
    }

    private void needNewBuffer(int newSize) {
        int delta = newSize - this.size;
        int newBufferSize = Math.max(this.minChunkLen, delta);
        ++this.currentBufferIndex;
        this.currentBuffer = new Object[newBufferSize];
        this.offset = 0;
        if (this.currentBufferIndex >= this.buffers.length) {
            int newLen = this.buffers.length << 1;
            Object[][] newBuffers = new Object[newLen][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        this.buffers[this.currentBufferIndex] = this.currentBuffer;
        ++this.buffersCount;
    }

    public FastBuffer<E> append(E[] array, int off, int len) {
        int part;
        int end = off + len;
        if (off < 0 || len < 0 || end > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newSize = this.size + len;
        int remaining = len;
        if (this.currentBuffer != null) {
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            remaining -= part;
            this.offset += part;
            this.size += part;
        }
        if (remaining > 0) {
            this.needNewBuffer(newSize);
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.size += part;
        }
        return this;
    }

    public FastBuffer<E> append(E[] array) {
        return this.append(array, 0, array.length);
    }

    public FastBuffer<E> append(E element) {
        if (this.currentBuffer == null || this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.size + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.size;
        return this;
    }

    public FastBuffer<E> append(FastBuffer<E> buff) {
        if (buff.size == 0) {
            return this;
        }
        for (int i = 0; i < buff.currentBufferIndex; ++i) {
            this.append((E)buff.buffers[i]);
        }
        this.append(buff.currentBuffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public E[] array(int index) {
        return this.buffers[index];
    }

    public void clear() {
        this.size = 0;
        this.offset = 0;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
        this.buffersCount = 0;
    }

    public E[] toArray() {
        int pos = 0;
        Object[] array = new Object[this.size];
        if (this.currentBufferIndex == -1) {
            return array;
        }
        for (int i = 0; i < this.currentBufferIndex; ++i) {
            int len = this.buffers[i].length;
            System.arraycopy(this.buffers[i], 0, array, pos, len);
            pos += len;
        }
        System.arraycopy(this.buffers[this.currentBufferIndex], 0, array, pos, this.offset);
        return array;
    }

    public E[] toArray(int start, int len) {
        int remaining = len;
        int pos = 0;
        Object[] array = new Object[len];
        if (len == 0) {
            return array;
        }
        int i = 0;
        while (start >= this.buffers[i].length) {
            start -= this.buffers[i].length;
            ++i;
        }
        while (i < this.buffersCount) {
            E[] buf = this.buffers[i];
            int c = Math.min(buf.length - start, remaining);
            System.arraycopy(buf, start, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
            start = 0;
            ++i;
        }
        return array;
    }

    public E get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        E[] b;
        while (index >= (b = this.buffers[ndx]).length) {
            ++ndx;
            index -= b.length;
        }
        return b[index];
    }

    public void add(E element) {
        this.append(element);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int iteratorIndex;
            int iteratorBufferIndex;
            int iteratorOffset;

            @Override
            public boolean hasNext() {
                return this.iteratorIndex < FastBuffer.this.size;
            }

            @Override
            public E next() {
                if (this.iteratorIndex >= FastBuffer.this.size) {
                    throw new NoSuchElementException();
                }
                Object[] buf = FastBuffer.this.buffers[this.iteratorBufferIndex];
                Object result = buf[this.iteratorOffset];
                ++this.iteratorIndex;
                ++this.iteratorOffset;
                if (this.iteratorOffset >= buf.length) {
                    this.iteratorOffset = 0;
                    ++this.iteratorBufferIndex;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

