/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.util.collection;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoddArrayList<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable {
    private static final int DEFAULT_CAPACITY = 16;
    private static final Object[] EMPTY_BUFFER = new Object[0];
    protected Object[] buffer;
    protected int size;
    protected int start;
    protected int end;
    protected int pivotIndex;
    protected PIVOT_TYPE pivotType = PIVOT_TYPE.FIRST_QUARTER;
    protected int minimalGrowSize = 10;
    protected int maxFreeSpaceBeforeNormalize = 32;

    public JoddArrayList(int initialCapacity) {
        this.init(initialCapacity);
    }

    public JoddArrayList(int initialCapacity, PIVOT_TYPE pivot_type, int minimalGrowSize, int maxFreeSpaceBeforeNormalize) {
        this.init(initialCapacity);
        this.pivotType = pivot_type;
        this.minimalGrowSize = minimalGrowSize;
        this.maxFreeSpaceBeforeNormalize = maxFreeSpaceBeforeNormalize;
    }

    public JoddArrayList() {
        this.init(16);
    }

    public JoddArrayList(Collection<? extends E> collection) {
        this.buffer = collection.toArray();
        this.size = this.buffer.length;
        if (this.buffer.getClass() != Object[].class) {
            Object[] copy = new Object[this.size];
            System.arraycopy(this.buffer, 0, copy, 0, this.size);
            this.buffer = copy;
        }
        this.start = 0;
        this.end = this.size;
        this.pivotIndex = this.pivotType.calculate(this.size);
    }

    public JoddArrayList(E ... array) {
        this.buffer = (Object[])array.clone();
        this.size = this.buffer.length;
        this.start = 0;
        this.end = this.size;
        this.pivotIndex = this.pivotType.calculate(this.size);
    }

    protected void init(int capacity) {
        this.pivotIndex = capacity;
        this.buffer = EMPTY_BUFFER;
        this.size = 0;
        this.start = 0;
        this.end = 0;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.buffer.length) {
            Object[] newBuffer = new Object[this.size];
            System.arraycopy(this.buffer, this.start, newBuffer, 0, this.size);
            this.buffer = newBuffer;
            this.start = 0;
            this.end = this.size = this.buffer.length;
            this.pivotIndex = this.pivotType.calculate(this.size);
        }
    }

    protected void normalize() {
        int newPivotIndex = this.pivotType.calculate(this.buffer.length);
        int newStart = newPivotIndex - this.pivotType.calculate(this.size);
        int newEnd = newStart + this.size;
        System.arraycopy(this.buffer, this.start, this.buffer, newStart, this.size);
        if (newStart > this.start) {
            for (int i = this.start; i < newStart; ++i) {
                this.buffer[i] = null;
            }
        } else {
            for (int i = Math.max(this.start, newEnd); i < this.end; ++i) {
                this.buffer[i] = null;
            }
        }
        this.start = newStart;
        this.end = newEnd;
        this.pivotIndex = newPivotIndex;
    }

    protected void ensureCapacity(int index, int elementsToAdd) {
        if (this.buffer == EMPTY_BUFFER) {
            this.buffer = elementsToAdd <= this.pivotIndex ? new Object[this.pivotIndex] : new Object[elementsToAdd];
            this.end = this.start = (this.pivotIndex = this.pivotType.calculate(this.buffer.length));
            this.size = 0;
            return;
        }
        ++this.modCount;
        int realIndex = this.start + index;
        if (realIndex <= this.pivotIndex && realIndex < this.end - 1) {
            int gap = this.start;
            if (gap < elementsToAdd) {
                int newGap;
                if (this.buffer.length - this.size - elementsToAdd > this.maxFreeSpaceBeforeNormalize) {
                    this.normalize();
                    return;
                }
                int currentSize = this.pivotIndex;
                int newSize = currentSize + (currentSize >> 1);
                int delta = newSize - currentSize;
                if (delta < this.minimalGrowSize) {
                    delta = this.minimalGrowSize;
                }
                if ((newGap = gap + delta) < elementsToAdd) {
                    delta = elementsToAdd - gap;
                }
                int totalSize = this.buffer.length + delta;
                Object[] newBuffer = new Object[totalSize];
                System.arraycopy(this.buffer, this.start, newBuffer, newGap, this.size);
                this.start += delta;
                this.end += delta;
                this.pivotIndex += delta;
                this.buffer = newBuffer;
            }
        } else {
            int gap = this.buffer.length - this.end;
            if (gap < elementsToAdd) {
                int newGap;
                if (this.buffer.length - this.size - elementsToAdd > this.maxFreeSpaceBeforeNormalize) {
                    this.normalize();
                    return;
                }
                int currentSize = this.buffer.length - this.pivotIndex;
                int newSize = currentSize + (currentSize >> 1);
                int delta = newSize - currentSize;
                if (delta < this.minimalGrowSize) {
                    delta = this.minimalGrowSize;
                }
                if ((newGap = gap + delta) < elementsToAdd) {
                    delta = elementsToAdd - gap;
                }
                int totalSize = this.buffer.length + delta;
                Object[] newBuffer = new Object[totalSize];
                System.arraycopy(this.buffer, this.start, newBuffer, this.start, this.size);
                this.buffer = newBuffer;
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = this.start; i < this.end; ++i) {
                if (this.buffer[i] != null) continue;
                return i - this.start;
            }
        } else {
            for (int i = this.start; i < this.end; ++i) {
                if (!o.equals(this.buffer[i])) continue;
                return i - this.start;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.end - 1; i >= this.start; --i) {
                if (this.buffer[i] != null) continue;
                return i - this.start;
            }
        } else {
            for (int i = this.end - 1; i >= this.start; --i) {
                if (!o.equals(this.buffer[i])) continue;
                return i - this.start;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            JoddArrayList v = (JoddArrayList)super.clone();
            v.buffer = this.buffer == EMPTY_BUFFER ? this.buffer : (Object[])this.buffer.clone();
            v.modCount = 0;
            v.start = this.start;
            v.end = this.end;
            v.size = this.size;
            v.pivotIndex = this.pivotIndex;
            v.pivotType = this.pivotType;
            v.minimalGrowSize = this.minimalGrowSize;
            v.maxFreeSpaceBeforeNormalize = this.maxFreeSpaceBeforeNormalize;
            return v;
        }
        catch (CloneNotSupportedException ignore) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] copy = new Object[this.size];
        System.arraycopy(this.buffer, this.start, copy, 0, this.size);
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.size) {
            Class<?> arrayType = array.getClass();
            Object[] copy = arrayType == Object[].class ? new Object[this.size] : (Object[])Array.newInstance(arrayType.getComponentType(), this.size);
            System.arraycopy(this.buffer, this.start, copy, 0, this.size);
            return copy;
        }
        System.arraycopy(this.buffer, this.start, array, 0, this.size);
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return (E)this.buffer[this.start + index];
    }

    @Override
    public E getFirst() {
        return this.get(0);
    }

    @Override
    public E getLast() {
        return this.get(this.size - 1);
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        Object oldValue = this.buffer[index += this.start];
        this.buffer[index] = element;
        return (E)oldValue;
    }

    @Override
    public boolean add(E e) {
        int index = this.size++;
        this.ensureCapacity(index, 1);
        this.buffer[this.end] = e;
        ++this.end;
        return true;
    }

    public boolean addFirst(E e) {
        int index = 0;
        this.ensureCapacity(index, 1);
        if (this.size > 0) {
            --this.start;
        } else {
            ++this.end;
        }
        this.buffer[this.start] = e;
        ++this.size;
        return true;
    }

    public boolean addLast(E e) {
        return this.add(e);
    }

    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        if (index == this.size) {
            this.add(element);
            return;
        }
        this.rangeCheck(index);
        this.ensureCapacity(index, 1);
        int realIndex = this.start + index;
        if (realIndex <= this.pivotIndex && realIndex < this.end - 1) {
            System.arraycopy(this.buffer, this.start, this.buffer, this.start - 1, realIndex - this.start);
            --this.start;
            --realIndex;
        } else {
            System.arraycopy(this.buffer, realIndex, this.buffer, realIndex + 1, this.end - realIndex);
            ++this.end;
        }
        this.buffer[realIndex] = element;
        ++this.size;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Object[] array = collection.toArray();
        return this.doAddAll(array);
    }

    public boolean addAll(E ... array) {
        if (array.length == 0) {
            return false;
        }
        return this.doAddAll(array);
    }

    protected boolean doAddAll(Object[] array) {
        int numNew = array.length;
        this.ensureCapacity(this.end, numNew);
        System.arraycopy(array, 0, this.buffer, this.end, numNew);
        this.size += numNew;
        this.end += numNew;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        this.rangeCheck(index);
        Object[] array = collection.toArray();
        return this.doAddAll(index, array);
    }

    public boolean addAll(int index, E ... array) {
        this.rangeCheck(index);
        return this.doAddAll(index, array);
    }

    protected boolean doAddAll(int index, Object[] array) {
        int numNew = array.length;
        this.ensureCapacity(index, numNew);
        int realIndex = this.start + index;
        if (realIndex <= this.pivotIndex) {
            int numMoved = index;
            if (numMoved > 0) {
                System.arraycopy(this.buffer, this.start, this.buffer, this.start - numNew, numMoved);
            }
            System.arraycopy(array, 0, this.buffer, realIndex -= numNew, numNew);
            this.start -= numNew;
        } else {
            int numMoved = this.end - realIndex;
            if (numMoved > 0) {
                System.arraycopy(this.buffer, realIndex, this.buffer, realIndex + numNew, numMoved);
            }
            System.arraycopy(array, 0, this.buffer, realIndex, numNew);
            this.end += numNew;
        }
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = this.start; i < this.end; ++i) {
            this.buffer[i] = null;
        }
        this.end = this.start = (this.pivotIndex = this.pivotType.calculate(this.buffer.length));
        this.size = 0;
    }

    @Override
    public E removeFirst() {
        return this.remove(0);
    }

    @Override
    public E removeLast() {
        return this.remove(this.size - 1);
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        return this.doRemove(index);
    }

    protected E doRemove(int index) {
        int realIndex = this.start + index;
        Object oldValue = this.buffer[realIndex];
        if (realIndex <= this.pivotIndex && realIndex < this.end - 1) {
            int numMoved = index;
            if (numMoved > 0) {
                System.arraycopy(this.buffer, this.start, this.buffer, this.start + 1, numMoved);
            }
            this.buffer[this.start] = null;
            ++this.start;
            --this.size;
            if (this.start > this.pivotIndex) {
                this.pivotIndex = this.start;
            }
        } else {
            int numMoved = this.end - realIndex - 1;
            if (numMoved > 0) {
                System.arraycopy(this.buffer, realIndex + 1, this.buffer, realIndex, numMoved);
            }
            --this.end;
            --this.size;
            this.buffer[this.end] = null;
            if (this.end <= this.pivotIndex) {
                this.pivotIndex = this.end - 1;
                if (this.pivotIndex < this.start) {
                    this.pivotIndex = this.start;
                }
            }
        }
        return (E)oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int index = this.start; index < this.end; ++index) {
                if (this.buffer[index] != null) continue;
                this.doRemove(index - this.start);
                return true;
            }
        } else {
            for (int index = this.start; index < this.end; ++index) {
                if (!o.equals(this.buffer[index])) continue;
                this.doRemove(index - this.start);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.buffer, this.start + toIndex, this.buffer, this.start + fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        for (int i = this.start + newSize; i < this.start + this.size; ++i) {
            this.buffer[i] = null;
        }
        this.size = newSize;
        this.end = this.start + this.size;
        this.pivotIndex = this.start + this.pivotType.calculate(this.size);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean batchRemove(Collection<?> collection, boolean complement) {
        boolean modified;
        int w;
        block8: {
            int r;
            w = 0;
            modified = false;
            try {
                for (r = 0; r < this.size; ++r) {
                    Object element = this.buffer[this.start + r];
                    if (collection.contains(element) != complement) continue;
                    this.buffer[this.start + w++] = this.buffer[this.start + r];
                }
                Object var8_7 = null;
                if (r == this.size) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (r != this.size) {
                    System.arraycopy(this.buffer, this.start + r, this.buffer, this.start + w, this.size - r);
                    w += this.size - r;
                }
                if (w != this.size) {
                    for (int i = w; i < this.size; ++i) {
                        this.buffer[this.start + i] = null;
                    }
                    this.modCount += this.size - w;
                    this.size = w;
                    modified = true;
                    this.end = this.start + this.size;
                    this.pivotIndex = this.start + this.pivotType.calculate(this.size);
                }
                throw throwable;
            }
            System.arraycopy(this.buffer, this.start + r, this.buffer, this.start + w, this.size - r);
            w += this.size - r;
        }
        if (w != this.size) {
            for (int i = w; i < this.size; ++i) {
                this.buffer[this.start + i] = null;
            }
            this.modCount += this.size - w;
            this.size = w;
            modified = true;
            this.end = this.start + this.size;
            this.pivotIndex = this.start + this.pivotType.calculate(this.size);
        }
        return modified;
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.rangeCheck(index);
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (this.buffer != EMPTY_BUFFER) {
            for (int i = this.start; i < this.end; ++i) {
                if (i != this.start) {
                    sb.append(',');
                }
                sb.append(this.buffer[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    static /* synthetic */ int access$200(JoddArrayList x0) {
        return x0.modCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            if (i >= JoddArrayList.this.size) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return JoddArrayList.this.buffer[JoddArrayList.this.start + i];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                JoddArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ignore) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                JoddArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = JoddArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ignore) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = JoddArrayList.access$200(JoddArrayList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != JoddArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= JoddArrayList.this.size) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return JoddArrayList.this.buffer[JoddArrayList.this.start + i];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                JoddArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = JoddArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (JoddArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PIVOT_TYPE {
        FIRST_QUARTER{

            public int calculate(int value) {
                return value >> 2;
            }
        }
        ,
        HALF{

            public int calculate(int value) {
                return value >> 1;
            }
        }
        ,
        LAST_QUARTER{

            public int calculate(int value) {
                return value - (value >> 2);
            }
        };


        public abstract int calculate(int var1);
    }
}

