/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.parquet.org.apache.thrift.transport;

import io.prestosql.hive.$internal.parquet.org.apache.thrift.transport.AutoExpandingBuffer;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.transport.TTransport;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.transport.TTransportException;

public final class AutoExpandingBufferWriteTransport
extends TTransport {
    private final AutoExpandingBuffer buf;
    private int pos;

    public AutoExpandingBufferWriteTransport(int initialCapacity, double growthCoefficient) {
        this.buf = new AutoExpandingBuffer(initialCapacity, growthCoefficient);
        this.pos = 0;
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] toWrite, int off, int len) throws TTransportException {
        this.buf.resizeIfNecessary(this.pos + len);
        System.arraycopy(toWrite, off, this.buf.array(), this.pos, len);
        this.pos += len;
    }

    public AutoExpandingBuffer getBuf() {
        return this.buf;
    }

    public int getPos() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }
}

