/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.common.type.TimestampTZ;

public class TimestampTZUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTZ.class);
    private static final LocalTime DEFAULT_LOCAL_TIME = LocalTime.of(0, 0);
    private static final Pattern SINGLE_DIGIT_PATTERN = Pattern.compile("[\\+-]\\d:\\d\\d");
    private static final ThreadLocal<DateFormat> CONVERT_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    static final DateTimeFormatter FORMATTER;

    public static TimestampTZ parse(String s) {
        return TimestampTZUtil.parse(s, null);
    }

    public static TimestampTZ parse(String s, ZoneId defaultTimeZone) {
        ZonedDateTime zonedDateTime;
        s = TimestampTZUtil.handleSingleDigitHourOffset(s);
        try {
            zonedDateTime = ZonedDateTime.parse(s, FORMATTER);
        }
        catch (DateTimeParseException e) {
            ZoneId zoneId;
            LocalTime localTime;
            TemporalAccessor accessor = FORMATTER.parse(s);
            LocalDate localDate = LocalDate.from(accessor);
            try {
                localTime = LocalTime.from(accessor);
            }
            catch (DateTimeException e1) {
                localTime = DEFAULT_LOCAL_TIME;
            }
            try {
                zoneId = ZoneId.from(accessor);
            }
            catch (DateTimeException e2) {
                if (defaultTimeZone == null) {
                    throw new DateTimeException("Time Zone not available");
                }
                zoneId = defaultTimeZone;
            }
            zonedDateTime = ZonedDateTime.of(localDate, localTime, zoneId);
        }
        if (defaultTimeZone == null) {
            return new TimestampTZ(zonedDateTime);
        }
        return new TimestampTZ(zonedDateTime.withZoneSameInstant(defaultTimeZone));
    }

    private static String handleSingleDigitHourOffset(String s) {
        Matcher matcher = SINGLE_DIGIT_PATTERN.matcher(s);
        if (matcher.find()) {
            int index = matcher.start() + 1;
            s = s.substring(0, index) + "0" + s.substring(index, s.length());
        }
        return s;
    }

    public static TimestampTZ parseOrNull(String s, ZoneId defaultTimeZone) {
        try {
            return TimestampTZUtil.parse(s, defaultTimeZone);
        }
        catch (DateTimeParseException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid string " + s + " for TIMESTAMP WITH TIME ZONE", e);
            }
            return null;
        }
    }

    public static TimestampTZ convert(Date date, ZoneId defaultTimeZone) {
        String s = date instanceof Timestamp ? date.toString() : CONVERT_FORMATTER.get().format(date);
        return TimestampTZUtil.parse(s, defaultTimeZone);
    }

    public static ZoneId parseTimeZone(String timeZoneStr) {
        if (timeZoneStr == null || timeZoneStr.trim().isEmpty() || timeZoneStr.trim().toLowerCase().equals("local")) {
            return ZoneId.systemDefault();
        }
        try {
            return ZoneId.of(timeZoneStr);
        }
        catch (DateTimeException e1) {
            throw new RuntimeException("Invalid time zone displacement value", e1);
        }
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        builder.optionalStart().appendLiteral(" ").append(DateTimeFormatter.ofPattern("HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd();
        builder.optionalStart().appendLiteral(" ").optionalEnd();
        builder.optionalStart().appendZoneText(TextStyle.NARROW).optionalEnd();
        FORMATTER = builder.toFormatter();
    }
}

