/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSDatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSFunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSPartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSTableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;

class DatabaseEventsIterator
implements Iterator<BootstrapEvent> {
    private static Logger LOG = LoggerFactory.getLogger(DatabaseEventsIterator.class);
    private RemoteIterator<LocatedFileStatus> remoteIterator;
    private final Path dbLevelPath;
    private HiveConf hiveConf;
    ReplicationState replicationState;
    private Path next = null;
    private Path previous = null;
    private boolean databaseEventProcessed = false;

    DatabaseEventsIterator(Path dbLevelPath, HiveConf hiveConf) throws IOException {
        this.dbLevelPath = dbLevelPath;
        this.hiveConf = hiveConf;
        FileSystem fileSystem = dbLevelPath.getFileSystem((Configuration)hiveConf);
        if (!fileSystem.exists(new Path(dbLevelPath + "/" + "_metadata"))) {
            this.databaseEventProcessed = true;
        }
        this.remoteIterator = fileSystem.listFiles(dbLevelPath, true);
    }

    public Path dbLevelPath() {
        return this.dbLevelPath;
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.databaseEventProcessed) {
                this.next = this.dbLevelPath;
                return true;
            }
            if (this.replicationState == null && this.next == null) {
                while (this.remoteIterator.hasNext()) {
                    String replacedString;
                    List filteredNames;
                    LocatedFileStatus next = (LocatedFileStatus)this.remoteIterator.next();
                    if (!next.getPath().toString().endsWith("_metadata") || (filteredNames = Arrays.stream((replacedString = next.getPath().toString().replace(this.dbLevelPath.toString(), "")).split("/")).filter(StringUtils::isNotBlank).collect(Collectors.toList())).size() == 1) continue;
                    this.next = next.getPath().getParent();
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("could not traverse the file via remote iterator " + this.dbLevelPath, e);
        }
    }

    @Override
    public BootstrapEvent next() {
        if (!this.databaseEventProcessed) {
            FSDatabaseEvent event = new FSDatabaseEvent(this.hiveConf, this.next.toString());
            this.databaseEventProcessed = true;
            return this.postProcessing(event);
        }
        if (this.replicationState != null) {
            return this.eventForReplicationState();
        }
        String currentPath = this.next.toString();
        if (currentPath.contains("_functions")) {
            LOG.debug("functions directory: {}", (Object)this.next.toString());
            return this.postProcessing(new FSFunctionEvent(this.next));
        }
        return this.postProcessing(new FSTableEvent(this.hiveConf, this.next.toString()));
    }

    private BootstrapEvent postProcessing(BootstrapEvent bootstrapEvent) {
        this.previous = this.next;
        this.next = null;
        LOG.debug("processing " + this.previous);
        return bootstrapEvent;
    }

    private BootstrapEvent eventForReplicationState() {
        if (this.replicationState.partitionState != null) {
            FSPartitionEvent bootstrapEvent = new FSPartitionEvent(this.hiveConf, this.previous.toString(), this.replicationState);
            this.replicationState = null;
            return bootstrapEvent;
        }
        if (this.replicationState.lastTableReplicated != null) {
            FSTableEvent event = new FSTableEvent(this.hiveConf, this.previous.toString());
            this.replicationState = null;
            return event;
        }
        throw new IllegalStateException("for replicationState " + this.replicationState.toString());
    }
}

