/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import io.prestosql.hive.$internal.org.json.JSONObject;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddForeignKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddNotNullConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddPrimaryKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddUniqueConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class LoadConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(LoadFunction.class);
    private Context context;
    private final ConstraintEvent event;
    private final String dbNameToLoadIn;
    private final TaskTracker tracker;

    public LoadConstraint(Context context, ConstraintEvent event, String dbNameToLoadIn, TaskTracker existingTracker) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
    }

    public TaskTracker tasks() throws IOException, SemanticException {
        URI fromURI = EximUtil.getValidatedURI(this.context.hiveConf, BaseSemanticAnalyzer.stripQuotes(this.event.rootDir().toUri().toString()));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        try {
            FileSystem fs = FileSystem.get((URI)fromPath.toUri(), (Configuration)this.context.hiveConf);
            JSONObject json = new JSONObject(EximUtil.readAsString(fs, fromPath));
            String pksString = json.getString("pks");
            String fksString = json.getString("fks");
            String uksString = json.getString("uks");
            String nnsString = json.getString("nns");
            ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
            if (pksString != null && !pksString.isEmpty()) {
                AddPrimaryKeyHandler pkHandler = new AddPrimaryKeyHandler();
                DumpMetaData pkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_PRIMARYKEY, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                pkDumpMetaData.setPayload(pksString);
                tasks.addAll(pkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, pkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            if (uksString != null && !uksString.isEmpty()) {
                AddUniqueConstraintHandler ukHandler = new AddUniqueConstraintHandler();
                DumpMetaData ukDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_UNIQUECONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                ukDumpMetaData.setPayload(uksString);
                tasks.addAll(ukHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, ukDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            if (nnsString != null && !nnsString.isEmpty()) {
                AddNotNullConstraintHandler nnHandler = new AddNotNullConstraintHandler();
                DumpMetaData nnDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_NOTNULLCONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                nnDumpMetaData.setPayload(nnsString);
                tasks.addAll(nnHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, nnDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            if (fksString != null && !fksString.isEmpty()) {
                AddForeignKeyHandler fkHandler = new AddForeignKeyHandler();
                DumpMetaData fkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_FOREIGNKEY, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                fkDumpMetaData.setPayload(fksString);
                tasks.addAll(fkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, fkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            tasks.forEach(this.tracker::addTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
    }
}

