/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.PathUtils;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.datanucleus.util.StringUtils;

public class LoadPartitions {
    private static Logger LOG = LoggerFactory.getLogger(LoadPartitions.class);
    private final Context context;
    private final ReplLogger replLogger;
    private final TableContext tableContext;
    private final TableEvent event;
    private final TaskTracker tracker;
    private final AddPartitionDesc lastReplicatedPartition;
    private final ImportTableDesc tableDesc;
    private Table table;

    public LoadPartitions(Context context, ReplLogger replLogger, TaskTracker tableTracker, TableEvent event, String dbNameToLoadIn, TableContext tableContext) throws HiveException, IOException {
        this(context, replLogger, tableContext, tableTracker, event, dbNameToLoadIn, null);
    }

    public LoadPartitions(Context context, ReplLogger replLogger, TableContext tableContext, TaskTracker limiter, TableEvent event, String dbNameToLoadIn, AddPartitionDesc lastReplicatedPartition) throws HiveException, IOException {
        this.tracker = new TaskTracker(limiter);
        this.event = event;
        this.context = context;
        this.replLogger = replLogger;
        this.lastReplicatedPartition = lastReplicatedPartition;
        this.tableContext = tableContext;
        this.tableDesc = tableContext.overrideProperties(event.tableDesc(dbNameToLoadIn));
        this.table = ImportSemanticAnalyzer.tableIfExists(this.tableDesc, context.hiveDb);
    }

    private String location() throws MetaException, HiveException {
        Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
        if (!this.tableContext.waitOnPrecursor()) {
            return this.context.warehouse.getDefaultTablePath(parentDb, this.tableDesc.getTableName()).toString();
        }
        Path tablePath = new Path(this.context.warehouse.getDefaultDatabasePath(this.tableDesc.getDatabaseName()), MetaStoreUtils.encodeTableName(this.tableDesc.getTableName().toLowerCase()));
        return this.context.warehouse.getDnsPath(tablePath).toString();
    }

    private void createTableReplLogTask() throws SemanticException {
        ReplStateLogWork replLogWork = new ReplStateLogWork(this.replLogger, this.tableDesc.getTableName(), this.tableDesc.tableType());
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork, this.context.hiveConf);
        if (this.tracker.tasks().isEmpty()) {
            this.tracker.addTask(replLogTask);
        } else {
            DAGTraversal.traverse(this.tracker.tasks(), new AddDependencyToLeaves(replLogTask));
            ArrayList<Task<? extends Serializable>> visited = new ArrayList<Task<? extends Serializable>>();
            this.tracker.updateTaskCount(replLogTask, visited);
        }
    }

    public TaskTracker tasks() throws SemanticException {
        try {
            if (this.tableDesc.getLocation() == null) {
                this.tableDesc.setLocation(this.location());
            }
            if (this.table == null) {
                this.table = this.tableDesc.toTable(this.context.hiveConf);
                if (ImportSemanticAnalyzer.isPartitioned(this.tableDesc)) {
                    this.updateReplicationState(this.initialReplicationState());
                    if (!this.forNewTable().hasReplicationState()) {
                        this.createTableReplLogTask();
                    }
                    return this.tracker;
                }
            } else if (this.table.isPartitioned()) {
                List<AddPartitionDesc> partitionDescs = this.event.partitionDescriptions(this.tableDesc);
                if (!this.event.replicationSpec().isMetadataOnly() && !partitionDescs.isEmpty()) {
                    this.updateReplicationState(this.initialReplicationState());
                    if (!this.forExistingTable(this.lastReplicatedPartition).hasReplicationState()) {
                        this.createTableReplLogTask();
                    }
                    return this.tracker;
                }
            }
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void updateReplicationState(ReplicationState replicationState) throws SemanticException {
        if (!this.tracker.canAddMoreTasks()) {
            this.tracker.setReplicationState(replicationState);
        }
    }

    private ReplicationState initialReplicationState() throws SemanticException {
        return new ReplicationState(new ReplicationState.PartitionState(this.tableDesc.getTableName(), this.lastReplicatedPartition));
    }

    private TaskTracker forNewTable() throws Exception {
        Iterator<AddPartitionDesc> iterator = this.event.partitionDescriptions(this.tableDesc).iterator();
        while (iterator.hasNext() && this.tracker.canAddMoreTasks()) {
            AddPartitionDesc currentPartitionDesc = iterator.next();
            this.addPartition(iterator.hasNext(), currentPartitionDesc);
        }
        return this.tracker;
    }

    private void addPartition(boolean hasMorePartitions, AddPartitionDesc addPartitionDesc) throws Exception {
        this.tracker.addTask(this.tasksForAddPartition(this.table, addPartitionDesc));
        if (hasMorePartitions && !this.tracker.canAddMoreTasks()) {
            ReplicationState currentReplicationState = new ReplicationState(new ReplicationState.PartitionState(this.table.getTableName(), addPartitionDesc));
            this.updateReplicationState(currentReplicationState);
        }
    }

    private Task<? extends Serializable> tasksForAddPartition(Table table, AddPartitionDesc addPartitionDesc) throws MetaException, IOException, HiveException {
        AddPartitionDesc.OnePartitionDesc partSpec = addPartitionDesc.getPartition(0);
        Path sourceWarehousePartitionLocation = new Path(partSpec.getLocation());
        Path replicaWarehousePartitionLocation = this.locationOnReplicaWarehouse(table, partSpec);
        partSpec.setLocation(replicaWarehousePartitionLocation.toString());
        LOG.debug("adding dependent CopyWork/AddPart/MoveWork for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + " with source location: " + partSpec.getLocation());
        Path tmpPath = PathUtils.getExternalTmpPath(replicaWarehousePartitionLocation, this.context.pathInfo);
        Task<?> copyTask = ReplCopyTask.getLoadCopyTask(this.event.replicationSpec(), sourceWarehousePartitionLocation, tmpPath, this.context.hiveConf);
        Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), addPartitionDesc), this.context.hiveConf);
        Task<?> movePartitionTask = this.movePartitionTask(table, partSpec, tmpPath);
        copyTask.addDependentTask(addPartTask);
        addPartTask.addDependentTask(movePartitionTask);
        return copyTask;
    }

    private Task<?> movePartitionTask(Table table, AddPartitionDesc.OnePartitionDesc partSpec, Path tmpPath) {
        MoveWork moveWork = new MoveWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), null, null, false);
        if (AcidUtils.isTransactionalTable(table)) {
            LoadMultiFilesDesc loadFilesWork = new LoadMultiFilesDesc(Collections.singletonList(tmpPath), Collections.singletonList(new Path(partSpec.getLocation())), true, null, null);
            moveWork.setMultiFilesDesc(loadFilesWork);
        } else {
            LoadTableDesc loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), partSpec.getPartSpec(), this.event.replicationSpec().isReplace() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, (Long)0L);
            loadTableWork.setInheritTableSpecs(false);
            moveWork.setLoadTableWork(loadTableWork);
        }
        return TaskFactory.get(moveWork, this.context.hiveConf);
    }

    private Path locationOnReplicaWarehouse(Table table, AddPartitionDesc.OnePartitionDesc partSpec) throws MetaException, HiveException, IOException {
        String child = Warehouse.makePartPath(partSpec.getPartSpec());
        if (this.tableDesc.getLocation() == null) {
            if (table.getDataLocation() == null) {
                Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
                return new Path(this.context.warehouse.getDefaultTablePath(parentDb, this.tableDesc.getTableName()), child);
            }
            return new Path(table.getDataLocation().toString(), child);
        }
        return new Path(this.tableDesc.getLocation(), child);
    }

    private Task<? extends Serializable> alterSinglePartition(AddPartitionDesc desc, ReplicationSpec replicationSpec, Partition ptn) {
        desc.setReplaceMode(true);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            desc.setReplicationSpec(replicationSpec);
        }
        desc.getPartition(0).setLocation(ptn.getLocation());
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), desc), this.context.hiveConf);
    }

    private TaskTracker forExistingTable(AddPartitionDesc lastPartitionReplicated) throws Exception {
        AddPartitionDesc addPartitionDesc;
        boolean encounteredTheLastReplicatedPartition = lastPartitionReplicated == null;
        Map<String, String> lastReplicatedPartSpec = null;
        if (!encounteredTheLastReplicatedPartition) {
            lastReplicatedPartSpec = lastPartitionReplicated.getPartition(0).getPartSpec();
            LOG.info("Start processing from partition info spec : {}", (Object)StringUtils.mapToString(lastReplicatedPartSpec));
        }
        ReplicationSpec replicationSpec = this.event.replicationSpec();
        Iterator<AddPartitionDesc> partitionIterator = this.event.partitionDescriptions(this.tableDesc).iterator();
        while (!encounteredTheLastReplicatedPartition && partitionIterator.hasNext()) {
            addPartitionDesc = partitionIterator.next();
            Map<String, String> currentSpec = addPartitionDesc.getPartition(0).getPartSpec();
            encounteredTheLastReplicatedPartition = lastReplicatedPartSpec.equals(currentSpec);
        }
        while (partitionIterator.hasNext() && this.tracker.canAddMoreTasks()) {
            addPartitionDesc = partitionIterator.next();
            Map<String, String> partSpec = addPartitionDesc.getPartition(0).getPartSpec();
            Partition ptn = this.context.hiveDb.getPartition(this.table, partSpec, false);
            if (ptn == null) {
                if (replicationSpec.isMetadataOnly()) continue;
                this.addPartition(partitionIterator.hasNext(), addPartitionDesc);
                continue;
            }
            if (!replicationSpec.allowReplacementInto(ptn.getParameters())) continue;
            if (replicationSpec.isMetadataOnly()) {
                this.tracker.addTask(this.alterSinglePartition(addPartitionDesc, replicationSpec, ptn));
                if (this.tracker.canAddMoreTasks()) continue;
                this.tracker.setReplicationState(new ReplicationState(new ReplicationState.PartitionState(this.table.getTableName(), addPartitionDesc)));
                continue;
            }
            this.addPartition(partitionIterator.hasNext(), addPartitionDesc);
        }
        return this.tracker;
    }
}

