/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.com.google.common.collect.Maps;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.TaskInfo;

public class JobMetricsListener
extends SparkListener {
    private static final Logger LOG = LoggerFactory.getLogger(JobMetricsListener.class);
    private final Map<Integer, int[]> jobIdToStageId = Maps.newHashMap();
    private final Map<Integer, Integer> stageIdToJobId = Maps.newHashMap();
    private final Map<Integer, Map<Integer, List<Map.Entry<TaskMetrics, TaskInfo>>>> allJobMetrics = Maps.newHashMap();

    public synchronized void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        int stageId = taskEnd.stageId();
        Integer jobId = this.stageIdToJobId.get(stageId);
        if (jobId == null) {
            LOG.warn("Can not find job id for stage[" + stageId + "].");
        } else {
            Map jobMetrics = this.allJobMetrics.computeIfAbsent(jobId, k -> Maps.newHashMap());
            List stageMetrics = jobMetrics.computeIfAbsent(stageId, k -> Lists.newLinkedList());
            stageMetrics.add(new AbstractMap.SimpleEntry<TaskMetrics, TaskInfo>(taskEnd.taskMetrics(), taskEnd.taskInfo()));
        }
    }

    public synchronized void onJobStart(SparkListenerJobStart jobStart) {
        int jobId = jobStart.jobId();
        int size = jobStart.stageIds().size();
        int[] intStageIds = new int[size];
        for (int i = 0; i < size; ++i) {
            Integer stageId = (Integer)jobStart.stageIds().apply(i);
            intStageIds[i] = stageId;
            this.stageIdToJobId.put(stageId, jobId);
        }
        this.jobIdToStageId.put(jobId, intStageIds);
    }

    public synchronized Map<Integer, List<Map.Entry<TaskMetrics, TaskInfo>>> getJobMetric(int jobId) {
        return this.allJobMetrics.get(jobId);
    }

    public synchronized void cleanup(int jobId) {
        this.allJobMetrics.remove(jobId);
        this.jobIdToStageId.remove(jobId);
        Iterator<Map.Entry<Integer, Integer>> iterator = this.stageIdToJobId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> entry = iterator.next();
            if (entry.getValue() != jobId) continue;
            iterator.remove();
        }
    }
}

