/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.sql.Timestamp;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class DynamicValueVectorExpression
extends VectorExpression {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicValueVectorExpression.class);
    private static final long serialVersionUID = 1L;
    private final DynamicValue dynamicValue;
    private final TypeInfo typeInfo;
    private final ColumnVector.Type type;
    private transient boolean initialized = false;
    protected long longValue = 0L;
    private double doubleValue = 0.0;
    private byte[] bytesValue = null;
    private HiveDecimal decimalValue = null;
    private Timestamp timestampValue = null;
    private HiveIntervalDayTime intervalDayTimeValue = null;
    private boolean isNullValue = false;
    private int bytesValueLength = 0;

    public DynamicValueVectorExpression() {
        this.type = null;
        this.dynamicValue = null;
        this.typeInfo = null;
    }

    public DynamicValueVectorExpression(int outputColumnNum, TypeInfo typeInfo, DynamicValue dynamicValue) throws HiveException {
        super(outputColumnNum);
        this.type = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        this.dynamicValue = dynamicValue;
        this.typeInfo = typeInfo;
    }

    private void evaluateLong(VectorizedRowBatch vrg) {
        LongColumnVector cv = (LongColumnVector)vrg.cols[this.outputColumnNum];
        cv.isRepeating = true;
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.vector[0] = this.longValue;
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateDouble(VectorizedRowBatch vrg) {
        DoubleColumnVector cv = (DoubleColumnVector)vrg.cols[this.outputColumnNum];
        cv.isRepeating = true;
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.vector[0] = this.doubleValue;
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateBytes(VectorizedRowBatch vrg) {
        BytesColumnVector cv = (BytesColumnVector)vrg.cols[this.outputColumnNum];
        cv.isRepeating = true;
        cv.initBuffer();
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.setVal(0, this.bytesValue, 0, this.bytesValueLength);
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateDecimal(VectorizedRowBatch vrg) {
        DecimalColumnVector dcv = (DecimalColumnVector)vrg.cols[this.outputColumnNum];
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.decimalValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateTimestamp(VectorizedRowBatch vrg) {
        TimestampColumnVector dcv = (TimestampColumnVector)vrg.cols[this.outputColumnNum];
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.timestampValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateIntervalDayTime(VectorizedRowBatch vrg) {
        IntervalDayTimeColumnVector dcv = (IntervalDayTimeColumnVector)vrg.cols[this.outputColumnNum];
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.intervalDayTimeValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void initValue() {
        Object val = this.dynamicValue.getValue();
        if (val == null) {
            this.isNullValue = true;
        } else {
            PrimitiveObjectInspector poi = this.dynamicValue.getObjectInspector();
            switch (poi.getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    this.longValue = PrimitiveObjectInspectorUtils.getLong(val, poi);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    this.doubleValue = PrimitiveObjectInspectorUtils.getDouble(val, poi);
                    break;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    byte[] bytesVal = PrimitiveObjectInspectorUtils.getString(val, poi).getBytes();
                    this.setBytesValue(bytesVal);
                    break;
                }
                case BINARY: {
                    byte[] bytesVal = PrimitiveObjectInspectorUtils.getBinary(val, poi).copyBytes();
                    this.setBytesValue(bytesVal);
                    break;
                }
                case DECIMAL: {
                    this.decimalValue = PrimitiveObjectInspectorUtils.getHiveDecimal(val, poi);
                    break;
                }
                case DATE: {
                    this.longValue = DateWritable.dateToDays(PrimitiveObjectInspectorUtils.getDate(val, poi));
                }
                case TIMESTAMP: {
                    this.timestampValue = PrimitiveObjectInspectorUtils.getTimestamp(val, poi);
                    break;
                }
                case INTERVAL_YEAR_MONTH: {
                    this.longValue = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(val, poi).getTotalMonths();
                    break;
                }
                case INTERVAL_DAY_TIME: {
                    this.intervalDayTimeValue = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(val, poi);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported type " + (Object)((Object)poi.getPrimitiveCategory()));
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.dynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch vrg) {
        if (!this.initialized) {
            this.initValue();
        }
        switch (this.type) {
            case LONG: {
                this.evaluateLong(vrg);
                break;
            }
            case DOUBLE: {
                this.evaluateDouble(vrg);
                break;
            }
            case BYTES: {
                this.evaluateBytes(vrg);
                break;
            }
            case DECIMAL: {
                this.evaluateDecimal(vrg);
                break;
            }
            case TIMESTAMP: {
                this.evaluateTimestamp(vrg);
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.evaluateIntervalDayTime(vrg);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type " + (Object)((Object)this.type));
            }
        }
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public byte[] getBytesValue() {
        return this.bytesValue;
    }

    public void setBytesValue(byte[] bytesValue) {
        this.bytesValue = (byte[])bytesValue.clone();
        this.bytesValueLength = bytesValue.length;
    }

    public void setDecimalValue(HiveDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public HiveDecimal getDecimalValue() {
        return this.decimalValue;
    }

    public void setTimestampValue(Timestamp timestampValue) {
        this.timestampValue = timestampValue;
    }

    public Timestamp getTimestampValue() {
        return this.timestampValue;
    }

    public void setIntervalDayTimeValue(HiveIntervalDayTime intervalDayTimeValue) {
        this.intervalDayTimeValue = intervalDayTimeValue;
    }

    public HiveIntervalDayTime getIntervalDayTimeValue() {
        return this.intervalDayTimeValue;
    }

    public String getTypeString() {
        return this.outputTypeInfo.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }

    @Override
    public String vectorExpressionParameters() {
        return null;
    }
}

