/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.text.ParseException;
import java.util.Calendar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class VectorUDFTimestampFieldString
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected final int fieldStart;
    protected final int fieldLength;
    private static final String patternMin = "0000-00-00 00:00:00.000000000";
    private static final String patternMax = "9999-19-99 29:59:59.999999999";
    protected final transient Calendar calendar = Calendar.getInstance();

    public VectorUDFTimestampFieldString(int colNum, int outputColumnNum, int fieldStart, int fieldLength) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.fieldStart = fieldStart;
        this.fieldLength = fieldLength;
    }

    public VectorUDFTimestampFieldString() {
        this.fieldStart = -1;
        this.fieldLength = -1;
    }

    public void initCalendar() {
    }

    @Override
    public void transientInit() throws HiveException {
        super.transientInit();
        this.initCalendar();
    }

    private long getField(byte[] bytes, int start, int length) throws ParseException {
        for (int i = 0; i < length; ++i) {
            char ch = (char)bytes[start + i];
            if (ch >= patternMin.charAt(i) && ch <= patternMax.charAt(i)) continue;
            throw new ParseException("A timestamp string should match 'yyyy-MM-dd HH:mm:ss.fffffffff' pattern.", i);
        }
        return this.doGetField(bytes, start, length);
    }

    protected long doGetField(byte[] bytes, int start, int length) throws ParseException {
        int field = 0;
        if (length < this.fieldLength) {
            throw new ParseException("A timestamp string should be longer.", 0);
        }
        for (int i = this.fieldStart; i < this.fieldStart + this.fieldLength; ++i) {
            byte ch = bytes[start + i];
            field = 10 * field + (ch - 48);
        }
        return field;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        boolean selectedInUse;
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        BytesColumnVector inputCol = (BytesColumnVector)batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean bl = selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = false;
        if (inputCol.isRepeating) {
            if (inputCol.noNulls || !inputCol.isNull[0]) {
                try {
                    outV.isNull[0] = false;
                    outV.vector[0] = this.getField(inputCol.vector[0], inputCol.start[0], inputCol.length[0]);
                }
                catch (ParseException e) {
                    outV.noNulls = false;
                    outV.isNull[0] = true;
                }
            } else {
                outV.isNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (inputCol.noNulls) {
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    try {
                        outV.vector[i] = this.getField(inputCol.vector[i], inputCol.start[i], inputCol.length[i]);
                        outV.isNull[i] = false;
                        continue;
                    }
                    catch (ParseException e) {
                        outV.noNulls = false;
                        outV.isNull[i] = true;
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        outV.vector[i] = this.getField(inputCol.vector[i], inputCol.start[i], inputCol.length[i]);
                        outV.isNull[i] = false;
                        continue;
                    }
                    catch (ParseException e) {
                        outV.noNulls = false;
                        outV.isNull[i] = true;
                    }
                }
            }
        } else {
            outV.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    try {
                        outV.vector[i] = this.getField(inputCol.vector[i], inputCol.start[i], inputCol.length[i]);
                        continue;
                    }
                    catch (ParseException e) {
                        outV.isNull[i] = true;
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outV.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    try {
                        outV.vector[i] = this.getField(inputCol.vector[i], inputCol.start[i], inputCol.length[i]);
                        continue;
                    }
                    catch (ParseException e) {
                        outV.isNull[i] = true;
                    }
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        if (this.fieldStart == -1) {
            return this.getColumnParamString(0, this.colNum);
        }
        return this.getColumnParamString(0, this.colNum) + ", fieldStart " + this.fieldStart + ", fieldLength " + this.fieldLength;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

