/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import io.prestosql.hive.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleFirstValue
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDoubleFirstValue.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean haveFirstValue;
    protected boolean isGroupResultNull;
    protected double firstValue;

    public VectorPTFEvaluatorDoubleFirstValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        if (!this.haveFirstValue) {
            int size = batch.size;
            if (size == 0) {
                return;
            }
            DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
            if (doubleColVector.isRepeating) {
                if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                    this.firstValue = doubleColVector.vector[0];
                    this.isGroupResultNull = false;
                }
            } else if (doubleColVector.noNulls) {
                this.firstValue = doubleColVector.vector[0];
                this.isGroupResultNull = false;
            } else if (!doubleColVector.isNull[0]) {
                this.firstValue = doubleColVector.vector[0];
                this.isGroupResultNull = false;
            }
            this.haveFirstValue = true;
        }
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        outputColVector.isRepeating = true;
        if (this.isGroupResultNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[0] = true;
        } else {
            outputColVector.isNull[0] = false;
            outputColVector.vector[0] = this.firstValue;
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public void resetEvaluator() {
        this.haveFirstValue = false;
        this.isGroupResultNull = true;
        this.firstValue = 0.0;
    }
}

