/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import io.prestosql.hive.$internal.com.google.protobuf.MessageLite;
import io.prestosql.hive.$internal.com.google.protobuf.Parser;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.hooks.ProtoMessageWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class ProtoMessageReader<T extends MessageLite>
implements Closeable {
    private final Path filePath;
    private final SequenceFile.Reader reader;
    private final ProtoMessageWritable<T> writable;

    ProtoMessageReader(Configuration conf, Path filePath, Parser<T> parser) throws IOException {
        this.filePath = filePath;
        this.reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)filePath)});
        this.writable = new ProtoMessageWritable<T>(parser);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void setOffset(long offset) throws IOException {
        this.reader.seek(offset);
    }

    public long getOffset() throws IOException {
        return this.reader.getPosition();
    }

    public T readEvent() throws IOException {
        if (!this.reader.next((Writable)NullWritable.get(), this.writable)) {
            return null;
        }
        return this.writable.getMessage();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

