/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import io.prestosql.hive.$internal.org.apache.commons.lang.ObjectUtils;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.OutputFormat;
import org.datanucleus.util.StringUtils;

public class ImportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private boolean tableExists = false;

    public ImportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    public boolean existsTable() {
        return this.tableExists;
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        try {
            Tree fromTree = ast.getChild(0);
            boolean isLocationSet = false;
            boolean isExternalSet = false;
            boolean isPartSpecSet = false;
            String parsedLocation = null;
            String parsedTableName = null;
            String parsedDbName = null;
            LinkedHashMap<String, String> parsedPartSpec = new LinkedHashMap<String, String>();
            boolean waitOnPrecursor = false;
            block8: for (int i = 1; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                switch (child.getToken().getType()) {
                    case 125: {
                        isExternalSet = true;
                        continue block8;
                    }
                    case 1047: {
                        isLocationSet = true;
                        parsedLocation = EximUtil.relativeToAbsolutePath(this.conf, ImportSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                        continue block8;
                    }
                    case 1036: {
                        ASTNode tableNameNode = (ASTNode)child.getChild(0);
                        Map.Entry<String, String> dbTablePair = ImportSemanticAnalyzer.getDbTableNamePair(tableNameNode);
                        parsedDbName = dbTablePair.getKey();
                        parsedTableName = dbTablePair.getValue();
                        if (child.getChildCount() != 2) continue block8;
                        ASTNode partspec = (ASTNode)child.getChild(1);
                        isPartSpecSet = true;
                        this.parsePartitionSpec(child, parsedPartSpec);
                    }
                }
            }
            if (StringUtils.isEmpty(parsedDbName)) {
                parsedDbName = SessionState.get().getCurrentDatabase();
            }
            this.tableExists = ImportSemanticAnalyzer.prepareImport(true, isLocationSet, isExternalSet, isPartSpecSet, waitOnPrecursor, parsedLocation, parsedTableName, parsedDbName, parsedPartSpec, fromTree.getText(), new EximUtil.SemanticAnalyzerWrapperContext(this.conf, this.db, this.inputs, this.outputs, this.rootTasks, this.LOG, this.ctx), null, this.getTxnMgr());
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.IMPORT_SEMANTIC_ERROR.getMsg(), e);
        }
    }

    private void parsePartitionSpec(ASTNode tableNode, LinkedHashMap<String, String> partSpec) throws SemanticException {
        if (tableNode.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableNode.getChild(1);
            for (int j = 0; j < partspec.getChildCount(); ++j) {
                ASTNode partspec_val = (ASTNode)partspec.getChild(j);
                String val = null;
                String colName = ImportSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                if (partspec_val.getChildCount() < 2) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                }
                val = ImportSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(colName, val);
            }
        }
    }

    public static boolean prepareImport(boolean isImportCmd, boolean isLocationSet, boolean isExternalSet, boolean isPartSpecSet, boolean waitOnPrecursor, String parsedLocation, String parsedTableName, String overrideDBName, LinkedHashMap<String, String> parsedPartSpec, String fromLocn, EximUtil.SemanticAnalyzerWrapperContext x, UpdatedMetaDataTracker updatedMetadata, HiveTxnManager txnMgr) throws IOException, MetaException, HiveException, URISyntaxException {
        ImportTableDesc tblDesc;
        MetaData rv;
        URI fromURI = EximUtil.getValidatedURI(x.getConf(), ImportSemanticAnalyzer.stripQuotes(fromLocn));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)x.getConf());
        x.getInputs().add(ImportSemanticAnalyzer.toReadEntity(fromPath, x.getConf()));
        try {
            rv = EximUtil.readMetaData(fs, new Path(fromPath, "_metadata"));
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
        if (rv.getTable() == null) {
            return false;
        }
        ReplicationSpec replicationSpec = rv.getReplicationSpec();
        if (replicationSpec.isNoop()) {
            x.getLOG().debug("Current update with ID:{} is noop", (Object)replicationSpec.getCurrentReplicationState());
            return false;
        }
        if (isImportCmd) {
            replicationSpec.setReplSpecType(ReplicationSpec.Type.IMPORT);
        }
        String dbname = rv.getTable().getDbName();
        if (overrideDBName != null && !overrideDBName.isEmpty()) {
            dbname = overrideDBName;
        }
        try {
            tblDesc = ImportSemanticAnalyzer.getBaseCreateTableDescFromTable(dbname, rv.getTable());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            tblDesc.setReplicationSpec(replicationSpec);
            StatsSetupConst.setBasicStatsState(tblDesc.getTblProps(), "false");
        }
        if (isExternalSet) {
            if (AcidUtils.isInsertOnlyTable(tblDesc.getTblProps())) {
                throw new SemanticException("Cannot import an MM table as external");
            }
            tblDesc.setExternal(isExternalSet);
        }
        if (isLocationSet) {
            tblDesc.setLocation(parsedLocation);
            x.getInputs().add(ImportSemanticAnalyzer.toReadEntity(new Path(parsedLocation), x.getConf()));
        }
        if (parsedTableName != null && !parsedTableName.isEmpty()) {
            tblDesc.setTableName(parsedTableName);
        }
        ArrayList<AddPartitionDesc> partitionDescs = new ArrayList<AddPartitionDesc>();
        Iterable<org.apache.hadoop.hive.metastore.api.Partition> partitions = rv.getPartitions();
        for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
            AddPartitionDesc partsDesc = ImportSemanticAnalyzer.getBaseAddPartitionDescFromPartition(fromPath, dbname, tblDesc, partition);
            if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
                StatsSetupConst.setBasicStatsState(partsDesc.getPartition(0).getPartParams(), "false");
            }
            partitionDescs.add(partsDesc);
        }
        if (isPartSpecSet) {
            boolean found = false;
            ListIterator partnIter = partitionDescs.listIterator();
            while (partnIter.hasNext()) {
                AddPartitionDesc addPartitionDesc = (AddPartitionDesc)partnIter.next();
                if (!found && addPartitionDesc.getPartition(0).getPartSpec().equals(parsedPartSpec)) {
                    found = true;
                    continue;
                }
                partnIter.remove();
            }
            if (!found) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Specified partition not found in import directory"));
            }
        }
        if (tblDesc.getTableName() == null) {
            throw new SemanticException(ErrorMsg.NEED_TABLE_SPECIFICATION.getMsg());
        }
        x.getConf().set("import.destination.table", tblDesc.getTableName());
        for (AddPartitionDesc addPartitionDesc : partitionDescs) {
            addPartitionDesc.setTableName(tblDesc.getTableName());
        }
        Warehouse wh = new Warehouse(x.getConf());
        Table table = ImportSemanticAnalyzer.tableIfExists(tblDesc, x.getHive());
        boolean tableExists = false;
        if (table != null) {
            ImportSemanticAnalyzer.checkTable(table, tblDesc, replicationSpec, x.getConf());
            x.getLOG().debug("table " + tblDesc.getTableName() + " exists: metadata checked");
            tableExists = true;
        }
        Long writeId = 0L;
        int stmtId = 0;
        if (!replicationSpec.isInReplicationScope() && (tableExists && AcidUtils.isTransactionalTable(table) || !tableExists && AcidUtils.isTablePropertyTransactional(tblDesc.getTblProps())) && x.getCtx().getExplainConfig() == null) {
            writeId = txnMgr.getTableWriteId(tblDesc.getDatabaseName(), tblDesc.getTableName());
            stmtId = txnMgr.getStmtIdAndIncrement();
        }
        if (!replicationSpec.isInReplicationScope()) {
            ImportSemanticAnalyzer.createRegularImportTasks(tblDesc, partitionDescs, isPartSpecSet, replicationSpec, table, fromURI, fs, wh, x, writeId, stmtId);
        } else {
            ImportSemanticAnalyzer.createReplImportTasks(tblDesc, partitionDescs, replicationSpec, waitOnPrecursor, table, fromURI, fs, wh, x, writeId, stmtId, updatedMetadata);
        }
        return tableExists;
    }

    private static AddPartitionDesc getBaseAddPartitionDescFromPartition(Path fromPath, String dbname, ImportTableDesc tblDesc, org.apache.hadoop.hive.metastore.api.Partition partition) throws MetaException, SemanticException {
        AddPartitionDesc partsDesc = new AddPartitionDesc(dbname, tblDesc.getTableName(), EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues()), partition.getSd().getLocation(), partition.getParameters());
        AddPartitionDesc.OnePartitionDesc partDesc = partsDesc.getPartition(0);
        partDesc.setInputFormat(partition.getSd().getInputFormat());
        partDesc.setOutputFormat(partition.getSd().getOutputFormat());
        partDesc.setNumBuckets(partition.getSd().getNumBuckets());
        partDesc.setCols(partition.getSd().getCols());
        partDesc.setSerializationLib(partition.getSd().getSerdeInfo().getSerializationLib());
        partDesc.setSerdeParams(partition.getSd().getSerdeInfo().getParameters());
        partDesc.setBucketCols(partition.getSd().getBucketCols());
        partDesc.setSortCols(partition.getSd().getSortCols());
        partDesc.setLocation(new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), partition.getValues())).toString());
        return partsDesc;
    }

    private static ImportTableDesc getBaseCreateTableDescFromTable(String dbName, org.apache.hadoop.hive.metastore.api.Table tblObj) throws Exception {
        Table table = new Table(tblObj);
        ImportTableDesc tblDesc = new ImportTableDesc(dbName, table);
        return tblDesc;
    }

    private static Task<?> loadTable(URI fromURI, Table table, boolean replace, Path tgtPath, ReplicationSpec replicationSpec, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId, boolean isSourceMm) {
        LoadTableDesc.LoadFileType lft;
        assert (table != null);
        assert (table.getParameters() != null);
        Path dataPath = new Path(fromURI.toString(), "data");
        Path destPath = null;
        Path loadPath = null;
        if (AcidUtils.isTransactionalTable(table)) {
            String mmSubdir = replace ? AcidUtils.baseDir(writeId) : AcidUtils.deltaSubdir(writeId, writeId, stmtId);
            destPath = new Path(tgtPath, mmSubdir);
            loadPath = tgtPath;
            lft = LoadTableDesc.LoadFileType.KEEP_EXISTING;
        } else {
            destPath = loadPath = x.getCtx().getExternalTmpPath(tgtPath);
            LoadTableDesc.LoadFileType loadFileType = lft = replace ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING;
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("adding import work for table with source location: " + dataPath + "; table: " + tgtPath + "; copy destination " + destPath + "; mm " + writeId + " for " + table.getTableName() + ": " + (AcidUtils.isFullAcidTable(table) ? "acid" : (AcidUtils.isInsertOnlyTable(table) ? "mm" : "flat")));
        }
        Task<Object> copyTask = null;
        if (replicationSpec.isInReplicationScope()) {
            copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, dataPath, destPath, x.getConf());
        } else {
            CopyWork cw = new CopyWork(dataPath, destPath, false);
            cw.setSkipSourceMmDirs(isSourceMm);
            copyTask = TaskFactory.get(cw);
        }
        LoadTableDesc loadTableWork = new LoadTableDesc(loadPath, Utilities.getTableDesc(table), new TreeMap<String, String>(), lft, writeId);
        loadTableWork.setStmtId(stmtId);
        MoveWork mv = new MoveWork(x.getInputs(), x.getOutputs(), loadTableWork, null, false);
        Task<MoveWork> loadTableTask = TaskFactory.get(mv, x.getConf());
        copyTask.addDependentTask(loadTableTask);
        x.getTasks().add(copyTask);
        return loadTableTask;
    }

    private static Task<?> createTableTask(ImportTableDesc tableDesc, EximUtil.SemanticAnalyzerWrapperContext x) {
        return tableDesc.getCreateTableTask(x.getInputs(), x.getOutputs(), x.getConf());
    }

    private static Task<?> dropTableTask(Table table, EximUtil.SemanticAnalyzerWrapperContext x, ReplicationSpec replicationSpec) {
        DropTableDesc dropTblDesc = new DropTableDesc(table.getTableName(), table.getTableType(), true, false, replicationSpec);
        return TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), dropTblDesc), x.getConf());
    }

    private static Task<? extends Serializable> alterTableTask(ImportTableDesc tableDesc, EximUtil.SemanticAnalyzerWrapperContext x, ReplicationSpec replicationSpec) {
        tableDesc.setReplaceMode(true);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            tableDesc.setReplicationSpec(replicationSpec);
        }
        return tableDesc.getCreateTableTask(x.getInputs(), x.getOutputs(), x.getConf());
    }

    private static Task<? extends Serializable> alterSinglePartition(URI fromURI, FileSystem fs, ImportTableDesc tblDesc, Table table, Warehouse wh, AddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, Partition ptn, EximUtil.SemanticAnalyzerWrapperContext x) throws MetaException, IOException, HiveException {
        addPartitionDesc.setReplaceMode(true);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            addPartitionDesc.setReplicationSpec(replicationSpec);
        }
        AddPartitionDesc.OnePartitionDesc partSpec = addPartitionDesc.getPartition(0);
        if (ptn == null) {
            ImportSemanticAnalyzer.fixLocationInPartSpec(fs, tblDesc, table, wh, replicationSpec, partSpec, x);
        } else {
            partSpec.setLocation(ptn.getLocation());
        }
        return TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc), x.getConf());
    }

    private static Task<?> addSinglePartition(URI fromURI, FileSystem fs, ImportTableDesc tblDesc, Table table, Warehouse wh, AddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId, boolean isSourceMm) throws MetaException, IOException, HiveException {
        Path moveTaskSrc;
        AddPartitionDesc.OnePartitionDesc partSpec = addPartitionDesc.getPartition(0);
        if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
            x.getLOG().debug("Importing in-place: adding AddPart for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()));
            Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc), x.getConf());
            return addPartTask;
        }
        String srcLocation = partSpec.getLocation();
        ImportSemanticAnalyzer.fixLocationInPartSpec(fs, tblDesc, table, wh, replicationSpec, partSpec, x);
        x.getLOG().debug("adding dependent CopyWork/AddPart/MoveWork for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + " with source location: " + srcLocation);
        Path tgtLocation = new Path(partSpec.getLocation());
        Path destPath = !AcidUtils.isTransactionalTable(table.getParameters()) ? x.getCtx().getExternalTmpPath(tgtLocation) : new Path(tgtLocation, AcidUtils.deltaSubdir(writeId, writeId, stmtId));
        Path path = moveTaskSrc = !AcidUtils.isTransactionalTable(table.getParameters()) ? destPath : tgtLocation;
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("adding import work for partition with source location: " + srcLocation + "; target: " + tgtLocation + "; copy dest " + destPath + "; mm " + writeId + " for " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + ": " + (AcidUtils.isFullAcidTable(table) ? "acid" : (AcidUtils.isInsertOnlyTable(table) ? "mm" : "flat")));
        }
        Task<Object> copyTask = null;
        if (replicationSpec.isInReplicationScope()) {
            copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, new Path(srcLocation), destPath, x.getConf());
        } else {
            CopyWork cw = new CopyWork(new Path(srcLocation), destPath, false);
            cw.setSkipSourceMmDirs(isSourceMm);
            copyTask = TaskFactory.get(cw);
        }
        Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc), x.getConf());
        LoadTableDesc loadTableWork = new LoadTableDesc(moveTaskSrc, Utilities.getTableDesc(table), partSpec.getPartSpec(), replicationSpec.isReplace() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, writeId);
        loadTableWork.setStmtId(stmtId);
        loadTableWork.setInheritTableSpecs(false);
        Task<MoveWork> loadPartTask = TaskFactory.get(new MoveWork(x.getInputs(), x.getOutputs(), loadTableWork, null, false), x.getConf());
        copyTask.addDependentTask(loadPartTask);
        addPartTask.addDependentTask(loadPartTask);
        x.getTasks().add(copyTask);
        return addPartTask;
    }

    private static void fixLocationInPartSpec(FileSystem fs, ImportTableDesc tblDesc, Table table, Warehouse wh, ReplicationSpec replicationSpec, AddPartitionDesc.OnePartitionDesc partSpec, EximUtil.SemanticAnalyzerWrapperContext x) throws MetaException, HiveException, IOException {
        Path tgtPath = null;
        if (tblDesc.getLocation() == null) {
            if (table.getDataLocation() != null) {
                tgtPath = new Path(table.getDataLocation().toString(), Warehouse.makePartPath(partSpec.getPartSpec()));
            } else {
                Database parentDb = x.getHive().getDatabase(tblDesc.getDatabaseName());
                tgtPath = new Path(wh.getDefaultTablePath(parentDb, tblDesc.getTableName()), Warehouse.makePartPath(partSpec.getPartSpec()));
            }
        } else {
            tgtPath = new Path(tblDesc.getLocation(), Warehouse.makePartPath(partSpec.getPartSpec()));
        }
        FileSystem tgtFs = FileSystem.get((URI)tgtPath.toUri(), (Configuration)x.getConf());
        ImportSemanticAnalyzer.checkTargetLocationEmpty(tgtFs, tgtPath, replicationSpec, x.getLOG());
        partSpec.setLocation(tgtPath.toString());
    }

    public static void checkTargetLocationEmpty(FileSystem fs, Path targetPath, ReplicationSpec replicationSpec, Logger logger) throws IOException, SemanticException {
        FileStatus[] status;
        if (replicationSpec.isInReplicationScope()) {
            return;
        }
        logger.debug("checking emptiness of " + targetPath.toString());
        if (fs.exists(targetPath) && (status = fs.listStatus(targetPath, FileUtils.HIDDEN_FILES_PATH_FILTER)).length > 0) {
            logger.debug("Files inc. " + status[0].getPath().toString() + " found in path : " + targetPath.toString());
            throw new SemanticException(ErrorMsg.TABLE_DATA_EXISTS.getMsg());
        }
    }

    public static String partSpecToString(Map<String, String> partSpec) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            if (!firstTime) {
                sb.append(',');
            }
            firstTime = false;
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static void checkTable(Table table, ImportTableDesc tableDesc, ReplicationSpec replicationSpec, HiveConf conf) throws SemanticException, URISyntaxException {
        String importedSerde;
        Map<String, String> importedTableParams;
        if (replicationSpec.isInReplicationScope()) {
            return;
        }
        if (table.getParameters().containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString()) && conf.getBoolVar(HiveConf.ConfVars.HIVE_EXIM_RESTRICT_IMPORTS_INTO_REPLICATED_TABLES)) {
            throw new SemanticException(ErrorMsg.IMPORT_INTO_STRICT_REPL_TABLE.getMsg("Table " + table.getTableName() + " has repl.last.id parameter set."));
        }
        EximUtil.validateTable(table);
        if (!(!tableDesc.isExternal() || table.isPartitioned() && table.getTableType().equals((Object)TableType.EXTERNAL_TABLE))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" External table cannot overwrite existing table. Drop existing table first."));
        }
        if (tableDesc.getLocation() != null && !table.isPartitioned() && !table.getDataLocation().equals((Object)new Path(tableDesc.getLocation()))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Location does not match"));
        }
        List<FieldSchema> existingTableCols = table.getCols();
        List<FieldSchema> importedTableCols = tableDesc.getCols();
        if (!EximUtil.schemaCompare(importedTableCols, existingTableCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Column Schema does not match"));
        }
        List<FieldSchema> existingTablePartCols = table.getPartCols();
        List<FieldSchema> importedTablePartCols = tableDesc.getPartCols();
        if (!EximUtil.schemaCompare(importedTablePartCols, existingTablePartCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Partition Schema does not match"));
        }
        Map<String, String> existingTableParams = table.getParameters();
        String error = ImportSemanticAnalyzer.checkParams(existingTableParams, importedTableParams = tableDesc.getTblProps(), new String[]{"howl.isd", "howl.osd"});
        if (error != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table parameters do not match: " + error));
        }
        String existingifc = table.getInputFormatClass().getName();
        String importedifc = tableDesc.getInputFormat();
        String existingofc = table.getOutputFormatClass().getName();
        String importedofc = tableDesc.getOutputFormat();
        try {
            Class<?> origin = Class.forName(importedofc, true, Utilities.getSessionSpecifiedClassLoader());
            Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
            if (replaced == null) {
                throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
            }
            importedofc = replaced.getCanonicalName();
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
        }
        if (!existingifc.equals(importedifc) || !existingofc.equals(importedofc)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table inputformat/outputformats do not match"));
        }
        String existingSerde = table.getSerializationLib();
        if (!existingSerde.equals(importedSerde = tableDesc.getSerName())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde class does not match"));
        }
        String existingSerdeFormat = table.getSerdeParam("serialization.format");
        String importedSerdeFormat = tableDesc.getSerdeProps().get("serialization.format");
        String string = importedSerdeFormat = importedSerdeFormat == null ? "1" : importedSerdeFormat;
        if (!ObjectUtils.equals(existingSerdeFormat, importedSerdeFormat)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde format does not match"));
        }
        if (!ObjectUtils.equals(table.getBucketCols(), tableDesc.getBucketCols())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table bucketing spec does not match"));
        }
        List<Order> existingOrder = table.getSortCols();
        List<Order> importedOrder = tableDesc.getSortCols();
        if (existingOrder != null) {
            if (importedOrder != null) {
                final class OrderComparator
                implements Comparator<Order> {
                    OrderComparator() {
                    }

                    @Override
                    public int compare(Order o1, Order o2) {
                        if (o1.getOrder() < o2.getOrder()) {
                            return -1;
                        }
                        if (o1.getOrder() == o2.getOrder()) {
                            return 0;
                        }
                        return 1;
                    }
                }
                Collections.sort(existingOrder, new OrderComparator());
                Collections.sort(importedOrder, new OrderComparator());
                if (!existingOrder.equals(importedOrder)) {
                    throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
                }
            }
        } else if (importedOrder != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
        }
    }

    private static String checkParams(Map<String, String> map1, Map<String, String> map2, String[] keys) {
        block6: {
            block5: {
                if (map1 == null) break block5;
                if (map2 != null) {
                    for (String key : keys) {
                        String v2;
                        String v1 = map1.get(key);
                        if (ObjectUtils.equals(v1, v2 = map2.get(key))) continue;
                        return "Mismatch for " + key;
                    }
                } else {
                    for (String key : keys) {
                        if (map1.get(key) == null) continue;
                        return "Mismatch for " + key;
                    }
                }
                break block6;
            }
            if (map2 == null) break block6;
            for (String key : keys) {
                if (map2.get(key) == null) continue;
                return "Mismatch for " + key;
            }
        }
        return null;
    }

    private static void createRegularImportTasks(ImportTableDesc tblDesc, List<AddPartitionDesc> partitionDescs, boolean isPartSpecSet, ReplicationSpec replicationSpec, Table table, URI fromURI, FileSystem fs, Warehouse wh, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId) throws HiveException, IOException, MetaException {
        boolean isSourceMm = AcidUtils.isInsertOnlyTable(tblDesc.getTblProps());
        if (table != null) {
            if (table.isPartitioned()) {
                x.getLOG().debug("table partitioned");
                for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                    Map<String, String> partSpec = addPartitionDesc.getPartition(0).getPartSpec();
                    Partition ptn = null;
                    ptn = x.getHive().getPartition(table, partSpec, false);
                    if (ptn == null) {
                        x.getTasks().add(ImportSemanticAnalyzer.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, isSourceMm));
                        continue;
                    }
                    throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(ImportSemanticAnalyzer.partSpecToString(partSpec)));
                }
            } else {
                x.getLOG().debug("table non-partitioned");
                Path tgtPath = new Path(table.getDataLocation().toString());
                FileSystem tgtFs = FileSystem.get((URI)tgtPath.toUri(), (Configuration)x.getConf());
                ImportSemanticAnalyzer.checkTargetLocationEmpty(tgtFs, tgtPath, replicationSpec, x.getLOG());
                ImportSemanticAnalyzer.loadTable(fromURI, table, false, tgtPath, replicationSpec, x, writeId, stmtId, isSourceMm);
            }
            x.getOutputs().add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            x.getLOG().debug("table " + tblDesc.getTableName() + " does not exist");
            Task<?> t = ImportSemanticAnalyzer.createTableTask(tblDesc, x);
            table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc);
            Database parentDb = x.getHive().getDatabase(tblDesc.getDatabaseName());
            x.getOutputs().add(new WriteEntity(parentDb, WriteEntity.WriteType.DDL_SHARED));
            if (ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                    t.addDependentTask(ImportSemanticAnalyzer.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, isSourceMm));
                }
            } else {
                x.getLOG().debug("adding dependent CopyWork/MoveWork for table");
                if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
                    x.getLOG().debug("Importing in place, no emptiness check, no copying/loading");
                    Path dataPath = new Path(fromURI.toString(), "data");
                    tblDesc.setLocation(dataPath.toString());
                } else {
                    Path tablePath = null;
                    tablePath = tblDesc.getLocation() != null ? new Path(tblDesc.getLocation()) : wh.getDefaultTablePath(parentDb, tblDesc.getTableName());
                    FileSystem tgtFs = FileSystem.get((URI)tablePath.toUri(), (Configuration)x.getConf());
                    ImportSemanticAnalyzer.checkTargetLocationEmpty(tgtFs, tablePath, replicationSpec, x.getLOG());
                    t.addDependentTask(ImportSemanticAnalyzer.loadTable(fromURI, table, false, tablePath, replicationSpec, x, writeId, stmtId, isSourceMm));
                }
            }
            x.getTasks().add(t);
        }
    }

    private static Table createNewTableMetadataObject(ImportTableDesc tblDesc) throws SemanticException {
        Table newTable = new Table(tblDesc.getDatabaseName(), tblDesc.getTableName());
        newTable.setParameters(tblDesc.getTblProps());
        if (tblDesc.isExternal() && AcidUtils.isTransactionalTable(newTable)) {
            throw new SemanticException("External tables may not be transactional: " + Warehouse.getQualifiedName(tblDesc.getDatabaseName(), tblDesc.getTableName()));
        }
        return newTable;
    }

    private static void createReplImportTasks(ImportTableDesc tblDesc, List<AddPartitionDesc> partitionDescs, ReplicationSpec replicationSpec, boolean waitOnPrecursor, Table table, URI fromURI, FileSystem fs, Warehouse wh, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId, UpdatedMetaDataTracker updatedMetadata) throws HiveException, URISyntaxException, IOException, MetaException {
        Task<?> dropTblTask = null;
        boolean isSourceMm = AcidUtils.isInsertOnlyTable(tblDesc.getTblProps());
        WriteEntity.WriteType lockType = WriteEntity.WriteType.DDL_NO_LOCK;
        Database parentDb = x.getHive().getDatabase(tblDesc.getDatabaseName());
        if (parentDb == null && !waitOnPrecursor) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(tblDesc.getDatabaseName()));
        }
        if (table != null) {
            if (!replicationSpec.allowReplacementInto(table.getParameters())) {
                x.getLOG().info("Table {}.{} is not replaced as it is newer than the update", (Object)tblDesc.getDatabaseName(), (Object)tblDesc.getTableName());
                return;
            }
            if (x.getEventType() == DumpType.EVENT_CREATE_TABLE) {
                dropTblTask = ImportSemanticAnalyzer.dropTableTask(table, x, replicationSpec);
                table = null;
            }
        } else if (parentDb != null && !replicationSpec.allowReplacementInto(parentDb.getParameters())) {
            x.getLOG().info("Table {}.{} is not created as the database is newer than the update", (Object)tblDesc.getDatabaseName(), (Object)tblDesc.getTableName());
            return;
        }
        if (updatedMetadata != null) {
            updatedMetadata.set(replicationSpec.getReplicationState(), tblDesc.getDatabaseName(), tblDesc.getTableName(), null);
        }
        if (tblDesc.getLocation() == null) {
            if (!waitOnPrecursor) {
                tblDesc.setLocation(wh.getDefaultTablePath(parentDb, tblDesc.getTableName()).toString());
            } else {
                tblDesc.setLocation(wh.getDnsPath(new Path(wh.getDefaultDatabasePath(tblDesc.getDatabaseName()), MetaStoreUtils.encodeTableName(tblDesc.getTableName().toLowerCase()))).toString());
            }
        }
        if (table == null) {
            if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                lockType = WriteEntity.WriteType.DDL_SHARED;
            }
            Task<?> t = ImportSemanticAnalyzer.createTableTask(tblDesc, x);
            table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc);
            if (!replicationSpec.isMetadataOnly()) {
                if (ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                    for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                        addPartitionDesc.setReplicationSpec(replicationSpec);
                        t.addDependentTask(ImportSemanticAnalyzer.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, isSourceMm));
                        if (updatedMetadata == null) continue;
                        updatedMetadata.addPartition(addPartitionDesc.getPartition(0).getPartSpec());
                    }
                } else {
                    x.getLOG().debug("adding dependent CopyWork/MoveWork for table");
                    t.addDependentTask(ImportSemanticAnalyzer.loadTable(fromURI, table, true, new Path(tblDesc.getLocation()), replicationSpec, x, writeId, stmtId, isSourceMm));
                }
            }
            if (dropTblTask != null) {
                dropTblTask.addDependentTask(t);
                x.getTasks().add(dropTblTask);
            } else {
                x.getTasks().add(t);
            }
        } else {
            boolean isOldTableValid = true;
            if (table.isPartitioned() != ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc);
                isOldTableValid = false;
            }
            if (ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                x.getLOG().debug("table partitioned");
                for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                    addPartitionDesc.setReplicationSpec(replicationSpec);
                    Map<String, String> partSpec = addPartitionDesc.getPartition(0).getPartSpec();
                    Partition ptn = null;
                    if (isOldTableValid) {
                        try {
                            ptn = x.getHive().getPartition(table, partSpec, false);
                        }
                        catch (HiveException ex) {
                            ptn = null;
                            table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc);
                            isOldTableValid = false;
                        }
                    }
                    if (ptn == null) {
                        if (!replicationSpec.isMetadataOnly()) {
                            x.getTasks().add(ImportSemanticAnalyzer.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, isSourceMm));
                            if (updatedMetadata == null) continue;
                            updatedMetadata.addPartition(addPartitionDesc.getPartition(0).getPartSpec());
                            continue;
                        }
                        x.getTasks().add(ImportSemanticAnalyzer.alterSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, null, x));
                        if (updatedMetadata == null) continue;
                        updatedMetadata.addPartition(addPartitionDesc.getPartition(0).getPartSpec());
                        continue;
                    }
                    if (!replicationSpec.allowReplacementInto(ptn.getParameters())) continue;
                    if (!replicationSpec.isMetadataOnly()) {
                        x.getTasks().add(ImportSemanticAnalyzer.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, isSourceMm));
                    } else {
                        x.getTasks().add(ImportSemanticAnalyzer.alterSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, ptn, x));
                    }
                    if (updatedMetadata != null) {
                        updatedMetadata.addPartition(addPartitionDesc.getPartition(0).getPartSpec());
                    }
                    if (lockType != WriteEntity.WriteType.DDL_NO_LOCK) continue;
                    lockType = WriteEntity.WriteType.DDL_SHARED;
                }
                if (replicationSpec.isMetadataOnly() && partitionDescs.isEmpty()) {
                    x.getTasks().add(ImportSemanticAnalyzer.alterTableTask(tblDesc, x, replicationSpec));
                    if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                        lockType = WriteEntity.WriteType.DDL_SHARED;
                    }
                }
            } else {
                x.getLOG().debug("table non-partitioned");
                if (!replicationSpec.isMetadataOnly()) {
                    ImportSemanticAnalyzer.loadTable(fromURI, table, replicationSpec.isReplace(), new Path(tblDesc.getLocation()), replicationSpec, x, writeId, stmtId, isSourceMm);
                } else {
                    x.getTasks().add(ImportSemanticAnalyzer.alterTableTask(tblDesc, x, replicationSpec));
                }
                if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                    lockType = WriteEntity.WriteType.DDL_SHARED;
                }
            }
        }
        x.getOutputs().add(new WriteEntity(table, lockType));
    }

    public static boolean isPartitioned(ImportTableDesc tblDesc) {
        return tblDesc.getPartCols() != null && !tblDesc.getPartCols().isEmpty();
    }

    public static Table tableIfExists(ImportTableDesc tblDesc, Hive db) throws HiveException {
        try {
            return db.getTable(tblDesc.getDatabaseName(), tblDesc.getTableName());
        }
        catch (InvalidTableException e) {
            return null;
        }
    }
}

