/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTErrorNode;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HintParser;
import org.apache.hadoop.hive.ql.parse.HiveLexer;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_IdentifiersParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_ResourcePlanParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_SelectClauseParser;
import org.apache.hadoop.hive.ql.parse.ParseError;
import org.apache.hadoop.hive.ql.parse.ParseException;

public class ParseDriver {
    private static final Logger LOG = LoggerFactory.getLogger("hive.ql.parse.ParseDriver");
    public static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new ASTNode(payload);
        }

        public Object dupNode(Object t) {
            return this.create(((CommonTree)t).token);
        }

        public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
            return new ASTErrorNode(input, start, stop, e);
        }
    };

    public ASTNode parse(String command) throws ParseException {
        return this.parse(command, null);
    }

    public ASTNode parse(String command, Context ctx) throws ParseException {
        return this.parse(command, ctx, null);
    }

    public ASTNode parse(String command, Context ctx, String viewFullyQualifiedName) throws ParseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing command: " + command);
        }
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        if (ctx != null) {
            if (viewFullyQualifiedName == null) {
                ctx.setTokenRewriteStream(tokens);
            } else {
                ctx.addViewTokenRewriteStream(viewFullyQualifiedName, tokens);
            }
            lexer.setHiveConf(ctx.getConf());
        }
        HiveParser parser = new HiveParser((TokenStream)tokens);
        if (ctx != null) {
            parser.setHiveConf(ctx.getConf());
        }
        parser.setTreeAdaptor(adaptor);
        HiveParser.statement_return r = null;
        try {
            r = parser.statement();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        ASTNode tree = r.getTree();
        tree.setUnknownTokenBoundaries();
        return tree;
    }

    public ASTNode parseHint(String command) throws ParseException {
        LOG.info("Parsing hint: " + command);
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HintParser parser = new HintParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HintParser.hint_return r = null;
        try {
            r = parser.hint();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.info("Parse Completed");
        return r.getTree();
    }

    public ASTNode parseSelect(String command, Context ctx) throws ParseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing command: " + command);
        }
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        if (ctx != null) {
            ctx.setTokenRewriteStream(tokens);
        }
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HiveParser_SelectClauseParser.selectClause_return r = null;
        try {
            r = parser.selectClause();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        return r.getTree();
    }

    public ASTNode parseExpression(String command) throws ParseException {
        LOG.info("Parsing expression: " + command);
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HiveParser_IdentifiersParser.expression_return r = null;
        try {
            r = parser.expression();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.info("Parse Completed");
        return r.getTree();
    }

    public ASTNode parseTriggerExpression(String command) throws ParseException {
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HiveParser_ResourcePlanParser.triggerExpressionStandalone_return r = null;
        try {
            r = parser.gResourcePlanParser.triggerExpressionStandalone();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0) {
            throw new ParseException(lexer.getErrors());
        }
        if (parser.errors.size() != 0) {
            throw new ParseException(parser.errors);
        }
        return r.getTree();
    }

    public ASTNode parseTriggerActionExpression(String command) throws ParseException {
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HiveParser_ResourcePlanParser.triggerActionExpressionStandalone_return r = null;
        try {
            r = parser.gResourcePlanParser.triggerActionExpressionStandalone();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0) {
            throw new ParseException(lexer.getErrors());
        }
        if (parser.errors.size() != 0) {
            throw new ParseException(parser.errors);
        }
        return r.getTree();
    }

    public class HiveLexerX
    extends HiveLexer {
        private final ArrayList<ParseError> errors;

        public HiveLexerX() {
            this.errors = new ArrayList();
        }

        public HiveLexerX(CharStream input) {
            super(input);
            this.errors = new ArrayList();
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
            this.errors.add(new ParseError((BaseRecognizer)this, e, tokenNames));
        }

        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
            String msg = null;
            if (e instanceof NoViableAltException) {
                NoViableAltException nvae = (NoViableAltException)e;
                msg = "character " + this.getCharErrorDisplay(e.c) + " not supported here";
            } else {
                msg = super.getErrorMessage(e, tokenNames);
            }
            return msg;
        }

        public ArrayList<ParseError> getErrors() {
            return this.errors;
        }
    }

    public class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1) {
                return returnChar;
            }
            if (returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }
}

