/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import io.prestosql.hive.$internal.com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPartitionDesc {
    private static final long serialVersionUID = 1L;
    private VectorMapOperatorReadType vectorMapOperatorReadType;
    private final VectorDeserializeType vectorDeserializeType;
    private final String rowDeserializerClassName;
    private final String inputFileFormatClassName;
    boolean isInputFileFormatSelfDescribing;
    private TypeInfo[] dataTypeInfos;

    private VectorPartitionDesc(String inputFileFormatClassName, boolean isInputFileFormatSelfDescribing, VectorMapOperatorReadType vectorMapOperatorReadType) {
        this.vectorMapOperatorReadType = vectorMapOperatorReadType;
        this.vectorDeserializeType = VectorDeserializeType.NONE;
        this.inputFileFormatClassName = inputFileFormatClassName;
        this.rowDeserializerClassName = null;
        this.isInputFileFormatSelfDescribing = isInputFileFormatSelfDescribing;
        this.dataTypeInfos = null;
    }

    private VectorPartitionDesc(String inputFileFormatClassName, VectorDeserializeType vectorDeserializeType) {
        this.vectorMapOperatorReadType = VectorMapOperatorReadType.VECTOR_DESERIALIZE;
        this.vectorDeserializeType = vectorDeserializeType;
        this.inputFileFormatClassName = inputFileFormatClassName;
        this.rowDeserializerClassName = null;
        this.isInputFileFormatSelfDescribing = false;
        this.dataTypeInfos = null;
    }

    private VectorPartitionDesc(String inputFileFormatClassName, boolean isInputFileFormatSelfDescribing, String rowDeserializerClassName) {
        this.vectorMapOperatorReadType = VectorMapOperatorReadType.ROW_DESERIALIZE;
        this.vectorDeserializeType = VectorDeserializeType.NONE;
        this.inputFileFormatClassName = inputFileFormatClassName;
        this.rowDeserializerClassName = rowDeserializerClassName;
        this.isInputFileFormatSelfDescribing = isInputFileFormatSelfDescribing;
        this.dataTypeInfos = null;
    }

    public static VectorPartitionDesc createVectorizedInputFileFormat(String inputFileFormatClassName, boolean isInputFileFormatSelfDescribing) {
        return new VectorPartitionDesc(inputFileFormatClassName, isInputFileFormatSelfDescribing, VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT);
    }

    public static VectorPartitionDesc createVectorDeserialize(String inputFileFormatClassName, VectorDeserializeType vectorDeserializeType) {
        return new VectorPartitionDesc(inputFileFormatClassName, vectorDeserializeType);
    }

    public static VectorPartitionDesc createRowDeserialize(String inputFileFormatClassName, boolean isInputFileFormatSelfDescribing, String rowDeserializerClassName) {
        return new VectorPartitionDesc(rowDeserializerClassName, isInputFileFormatSelfDescribing, inputFileFormatClassName);
    }

    public VectorPartitionDesc clone() {
        VectorPartitionDesc result;
        switch (this.vectorMapOperatorReadType) {
            case VECTORIZED_INPUT_FILE_FORMAT: {
                result = new VectorPartitionDesc(this.inputFileFormatClassName, this.isInputFileFormatSelfDescribing, this.vectorMapOperatorReadType);
                break;
            }
            case VECTOR_DESERIALIZE: {
                result = new VectorPartitionDesc(this.inputFileFormatClassName, this.vectorDeserializeType);
                break;
            }
            case ROW_DESERIALIZE: {
                result = new VectorPartitionDesc(this.inputFileFormatClassName, this.isInputFileFormatSelfDescribing, this.rowDeserializerClassName);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected vector map operator read type " + this.vectorMapOperatorReadType.name());
            }
        }
        result.dataTypeInfos = Arrays.copyOf(this.dataTypeInfos, this.dataTypeInfos.length);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof VectorPartitionDesc) {
            VectorPartitionDesc other = (VectorPartitionDesc)o;
            return Strings.nullToEmpty(this.getInputFileFormatClassName()).equals(Strings.nullToEmpty(other.getInputFileFormatClassName())) && Strings.nullToEmpty(this.getRowDeserializerClassName()).equals(Strings.nullToEmpty(other.getRowDeserializerClassName())) && this.getVectorDeserializeType() == other.getVectorDeserializeType() && this.getVectorMapOperatorReadType() == other.getVectorMapOperatorReadType() && this.getIsInputFileFormatSelfDescribing() == other.getIsInputFileFormatSelfDescribing() && Arrays.equals(this.getDataTypeInfos(), other.getDataTypeInfos());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + (this.getInputFileFormatClassName() == null ? 0 : this.getInputFileFormatClassName().hashCode());
        result = result * 31 + (this.getRowDeserializerClassName() == null ? 0 : this.getRowDeserializerClassName().hashCode());
        result = result * 31 + (this.getVectorDeserializeType() == null ? 0 : this.getVectorDeserializeType().hashCode());
        result = result * 31 + (this.getVectorMapOperatorReadType() == null ? 0 : this.getVectorMapOperatorReadType().hashCode());
        result = result * 31 + Boolean.valueOf(this.getIsInputFileFormatSelfDescribing()).hashCode();
        result = result * 31 + Arrays.hashCode(this.getDataTypeInfos());
        return result;
    }

    public VectorMapOperatorReadType getVectorMapOperatorReadType() {
        return this.vectorMapOperatorReadType;
    }

    public String getInputFileFormatClassName() {
        return this.inputFileFormatClassName;
    }

    public VectorDeserializeType getVectorDeserializeType() {
        return this.vectorDeserializeType;
    }

    public String getRowDeserializerClassName() {
        return this.rowDeserializerClassName;
    }

    public boolean getIsInputFileFormatSelfDescribing() {
        return this.isInputFileFormatSelfDescribing;
    }

    public TypeInfo[] getDataTypeInfos() {
        return this.dataTypeInfos;
    }

    public void setDataTypeInfos(List<TypeInfo> dataTypeInfoList) {
        this.dataTypeInfos = dataTypeInfoList.toArray(new TypeInfo[0]);
    }

    public int getDataColumnCount() {
        return this.dataTypeInfos.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.vectorMapOperatorReadType.name());
        sb.append(", ");
        sb.append(this.inputFileFormatClassName);
        switch (this.vectorMapOperatorReadType) {
            case VECTORIZED_INPUT_FILE_FORMAT: {
                break;
            }
            case VECTOR_DESERIALIZE: {
                sb.append(", ");
                sb.append(this.vectorDeserializeType.name());
                break;
            }
            case ROW_DESERIALIZE: {
                sb.append(", ");
                sb.append(this.rowDeserializerClassName);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected vector map operator read type " + this.vectorMapOperatorReadType.name());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public void setVectorMapOperatorReadType(VectorMapOperatorReadType val) {
        this.vectorMapOperatorReadType = val;
    }

    public static enum VectorDeserializeType {
        NONE,
        LAZY_SIMPLE,
        LAZY_BINARY;

    }

    public static enum VectorMapOperatorReadType {
        NONE,
        VECTORIZED_INPUT_FILE_FORMAT,
        VECTOR_DESERIALIZE,
        ROW_DESERIALIZE;

    }
}

