/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import io.prestosql.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hive.$internal.com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignatureFactory;
import org.apache.hadoop.hive.ql.plan.mapper.GroupTransformer;

public class PlanMapper {
    Set<EquivGroup> groups = new HashSet<EquivGroup>();
    private Map<Object, EquivGroup> objectMap = new CompositeMap<Object, EquivGroup>(OpTreeSignature.class);
    private OpTreeSignatureFactory signatureCache = OpTreeSignatureFactory.newCache();

    public void link(Object o1, Object o2) {
        Set keySet = Collections.newSetFromMap(new IdentityHashMap());
        keySet.add(o1);
        keySet.add(o2);
        keySet.add(this.getKeyFor(o1));
        keySet.add(this.getKeyFor(o2));
        Set mGroups = Collections.newSetFromMap(new IdentityHashMap());
        for (Object object : keySet) {
            EquivGroup group = this.objectMap.get(object);
            if (group == null) continue;
            mGroups.add(group);
        }
        if (mGroups.size() > 1) {
            throw new RuntimeException("equivalence mapping violation");
        }
        EquivGroup targetGroup = mGroups.isEmpty() ? new EquivGroup() : (EquivGroup)mGroups.iterator().next();
        this.groups.add(targetGroup);
        targetGroup.add(o1);
        targetGroup.add(o2);
    }

    private Object getKeyFor(Object o) {
        if (o instanceof Operator) {
            Operator operator = (Operator)o;
            return this.signatureCache.getSignature(operator);
        }
        return o;
    }

    public <T> List<T> getAll(Class<T> clazz) {
        ArrayList<T> ret = new ArrayList<T>();
        for (EquivGroup g : this.groups) {
            ret.addAll(g.getAll(clazz));
        }
        return ret;
    }

    public void runMapper(GroupTransformer mapper) {
        for (EquivGroup equivGroup : this.groups) {
            mapper.map(equivGroup);
        }
    }

    public <T> List<T> lookupAll(Class<T> clazz, Object key) {
        EquivGroup group = this.objectMap.get(key);
        if (group == null) {
            throw new NoSuchElementException(Objects.toString(key));
        }
        return group.getAll(clazz);
    }

    public <T> T lookup(Class<T> clazz, Object key) {
        List<T> all = this.lookupAll(clazz, key);
        if (all.size() != 1) {
            throw new IllegalArgumentException("Expected match count is 1; but got:" + all);
        }
        return all.get(0);
    }

    @VisibleForTesting
    public Iterator<EquivGroup> iterateGroups() {
        return this.groups.iterator();
    }

    public OpTreeSignature getSignatureOf(Operator<?> op) {
        OpTreeSignature sig = this.signatureCache.getSignature(op);
        return sig;
    }

    public class EquivGroup {
        Set<Object> members = new HashSet<Object>();

        public void add(Object o) {
            if (this.members.contains(o)) {
                return;
            }
            this.members.add(o);
            PlanMapper.this.objectMap.put(o, this);
        }

        public <T> List<T> getAll(Class<T> clazz) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Object m : this.members) {
                if (!clazz.isInstance(m)) continue;
                ret.add(m);
            }
            return ret;
        }
    }

    private static class CompositeMap<K, V>
    implements Map<K, V> {
        Map<K, V> comparedMap = new HashMap();
        Map<K, V> identityMap = new IdentityHashMap();
        final Set<Class<?>> typeCompared;

        CompositeMap(Class<?> ... comparedTypes) {
            for (Class<?> class1 : comparedTypes) {
                if (Modifier.isFinal(class1.getModifiers())) continue;
                throw new RuntimeException(class1 + " is not final...for this to reliably work; it should be");
            }
            this.typeCompared = Sets.newHashSet(comparedTypes);
        }

        @Override
        public int size() {
            return this.comparedMap.size() + this.identityMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.comparedMap.isEmpty() && this.identityMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.comparedMap.containsKey(key) || this.identityMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.comparedMap.containsValue(value) || this.identityMap.containsValue(value);
        }

        @Override
        public V get(Object key) {
            V v0 = this.comparedMap.get(key);
            if (v0 != null) {
                return v0;
            }
            return this.identityMap.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (this.shouldCompare(key.getClass())) {
                return this.comparedMap.put(key, value);
            }
            return this.identityMap.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (this.shouldCompare(key.getClass())) {
                return this.comparedMap.remove(key);
            }
            return this.identityMap.remove(key);
        }

        private boolean shouldCompare(Class<?> key) {
            return this.typeCompared.contains(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public void clear() {
            this.comparedMap.clear();
            this.identityMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return Sets.union(this.comparedMap.keySet(), this.identityMap.keySet());
        }

        @Override
        public Collection<V> values() {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Sets.union(this.comparedMap.entrySet(), this.identityMap.entrySet());
        }
    }
}

